/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.BonePose;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintPose;
import com.esotericsoftware.spine.utils.SpineUtils;

public class TransformConstraintData
extends ConstraintData<TransformConstraint, TransformConstraintPose> {
    final Array<BoneData> bones = new Array(true, 0, BoneData[]::new);
    BoneData source;
    float[] offsets = new float[6];
    boolean localSource;
    boolean localTarget;
    boolean additive;
    boolean clamp;
    final Array<FromProperty> properties = new Array(true, 1, FromProperty[]::new);

    public TransformConstraintData(String string) {
        super(string, new TransformConstraintPose());
    }

    @Override
    public TransformConstraint create(Skeleton skeleton) {
        return new TransformConstraint(this, skeleton);
    }

    public static abstract class FromProperty {
        public float offset;
        public final Array<ToProperty> to = new Array(true, 1, ToProperty[]::new);

        public abstract float value(Skeleton var1, BonePose var2, boolean var3, float[] var4);
    }

    public static class ToShearY
    extends ToProperty {
        @Override
        public float mix(TransformConstraintPose transformConstraintPose) {
            return transformConstraintPose.mixShearY;
        }

        @Override
        public void apply(Skeleton skeleton, TransformConstraintPose transformConstraintPose, BonePose bonePose, float f, boolean bl, boolean bl2) {
            if (bl) {
                if (!bl2) {
                    f -= bonePose.shearY;
                }
                bonePose.shearY += f * transformConstraintPose.mixShearY;
            } else {
                float f2 = skeleton.scaleX;
                float f3 = skeleton.scaleY;
                float f4 = bonePose.b / f2;
                float f5 = bonePose.d / f3;
                float f6 = SpineUtils.atan2(f5, f4);
                f = (f + 90.0f) * ((float)Math.PI / 180);
                if (bl2) {
                    f -= 1.5707964f;
                } else if ((f -= f6 - SpineUtils.atan2(bonePose.c / f3, bonePose.a / f2)) > (float)Math.PI) {
                    f -= (float)Math.PI * 2;
                } else if (f < (float)(-Math.PI)) {
                    f += (float)Math.PI * 2;
                }
                f = f6 + f * transformConstraintPose.mixShearY;
                float f7 = (float)Math.sqrt(f4 * f4 + f5 * f5);
                bonePose.b = SpineUtils.cos(f) * f7 * f2;
                bonePose.d = SpineUtils.sin(f) * f7 * f3;
            }
        }
    }

    public static class FromShearY
    extends FromProperty {
        @Override
        public float value(Skeleton skeleton, BonePose bonePose, boolean bl, float[] fArray) {
            if (bl) {
                return bonePose.shearY + fArray[5];
            }
            float f = 1.0f / skeleton.scaleX;
            float f2 = 1.0f / skeleton.scaleY;
            return (SpineUtils.atan2(bonePose.d * f2, bonePose.b * f) - SpineUtils.atan2(bonePose.c * f2, bonePose.a * f)) * 57.295776f - 90.0f + fArray[5];
        }
    }

    public static class ToScaleY
    extends ToProperty {
        @Override
        public float mix(TransformConstraintPose transformConstraintPose) {
            return transformConstraintPose.mixScaleY;
        }

        @Override
        public void apply(Skeleton skeleton, TransformConstraintPose transformConstraintPose, BonePose bonePose, float f, boolean bl, boolean bl2) {
            if (bl) {
                if (bl2) {
                    bonePose.scaleY *= 1.0f + (f - 1.0f) * transformConstraintPose.mixScaleY;
                } else if (bonePose.scaleY != 0.0f) {
                    bonePose.scaleY += (f - bonePose.scaleY) * transformConstraintPose.mixScaleY;
                }
            } else if (bl2) {
                float f2 = 1.0f + (f - 1.0f) * transformConstraintPose.mixScaleY;
                bonePose.b *= f2;
                bonePose.d *= f2;
            } else {
                float f3 = bonePose.b / skeleton.scaleX;
                float f4 = bonePose.d / skeleton.scaleY;
                float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
                if (f5 != 0.0f) {
                    f5 = 1.0f + (f - f5) * transformConstraintPose.mixScaleY / f5;
                    bonePose.b *= f5;
                    bonePose.d *= f5;
                }
            }
        }
    }

    public static class FromScaleY
    extends FromProperty {
        @Override
        public float value(Skeleton skeleton, BonePose bonePose, boolean bl, float[] fArray) {
            if (bl) {
                return bonePose.scaleY + fArray[4];
            }
            float f = bonePose.b / skeleton.scaleX;
            float f2 = bonePose.d / skeleton.scaleY;
            return (float)Math.sqrt(f * f + f2 * f2) + fArray[4];
        }
    }

    public static class ToScaleX
    extends ToProperty {
        @Override
        public float mix(TransformConstraintPose transformConstraintPose) {
            return transformConstraintPose.mixScaleX;
        }

        @Override
        public void apply(Skeleton skeleton, TransformConstraintPose transformConstraintPose, BonePose bonePose, float f, boolean bl, boolean bl2) {
            if (bl) {
                if (bl2) {
                    bonePose.scaleX *= 1.0f + (f - 1.0f) * transformConstraintPose.mixScaleX;
                } else if (bonePose.scaleX != 0.0f) {
                    bonePose.scaleX += (f - bonePose.scaleX) * transformConstraintPose.mixScaleX;
                }
            } else if (bl2) {
                float f2 = 1.0f + (f - 1.0f) * transformConstraintPose.mixScaleX;
                bonePose.a *= f2;
                bonePose.c *= f2;
            } else {
                float f3 = bonePose.a / skeleton.scaleX;
                float f4 = bonePose.c / skeleton.scaleY;
                float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
                if (f5 != 0.0f) {
                    f5 = 1.0f + (f - f5) * transformConstraintPose.mixScaleX / f5;
                    bonePose.a *= f5;
                    bonePose.c *= f5;
                }
            }
        }
    }

    public static class FromScaleX
    extends FromProperty {
        @Override
        public float value(Skeleton skeleton, BonePose bonePose, boolean bl, float[] fArray) {
            if (bl) {
                return bonePose.scaleX + fArray[3];
            }
            float f = bonePose.a / skeleton.scaleX;
            float f2 = bonePose.c / skeleton.scaleY;
            return (float)Math.sqrt(f * f + f2 * f2) + fArray[3];
        }
    }

    public static class ToY
    extends ToProperty {
        @Override
        public float mix(TransformConstraintPose transformConstraintPose) {
            return transformConstraintPose.mixY;
        }

        @Override
        public void apply(Skeleton skeleton, TransformConstraintPose transformConstraintPose, BonePose bonePose, float f, boolean bl, boolean bl2) {
            if (bl) {
                bonePose.y = bonePose.y + (bl2 ? f : f - bonePose.y) * transformConstraintPose.mixY;
            } else {
                if (!bl2) {
                    f -= bonePose.worldY / skeleton.scaleY;
                }
                bonePose.worldY += f * transformConstraintPose.mixY * skeleton.scaleY;
            }
        }
    }

    public static class FromY
    extends FromProperty {
        @Override
        public float value(Skeleton skeleton, BonePose bonePose, boolean bl, float[] fArray) {
            return bl ? bonePose.y + fArray[2] : (fArray[1] * bonePose.c + fArray[2] * bonePose.d + bonePose.worldY) / skeleton.scaleY;
        }
    }

    public static class ToX
    extends ToProperty {
        @Override
        public float mix(TransformConstraintPose transformConstraintPose) {
            return transformConstraintPose.mixX;
        }

        @Override
        public void apply(Skeleton skeleton, TransformConstraintPose transformConstraintPose, BonePose bonePose, float f, boolean bl, boolean bl2) {
            if (bl) {
                bonePose.x = bonePose.x + (bl2 ? f : f - bonePose.x) * transformConstraintPose.mixX;
            } else {
                if (!bl2) {
                    f -= bonePose.worldX / skeleton.scaleX;
                }
                bonePose.worldX += f * transformConstraintPose.mixX * skeleton.scaleX;
            }
        }
    }

    public static class FromX
    extends FromProperty {
        @Override
        public float value(Skeleton skeleton, BonePose bonePose, boolean bl, float[] fArray) {
            return bl ? bonePose.x + fArray[1] : (fArray[1] * bonePose.a + fArray[2] * bonePose.b + bonePose.worldX) / skeleton.scaleX;
        }
    }

    public static class ToRotate
    extends ToProperty {
        @Override
        public float mix(TransformConstraintPose transformConstraintPose) {
            return transformConstraintPose.mixRotate;
        }

        @Override
        public void apply(Skeleton skeleton, TransformConstraintPose transformConstraintPose, BonePose bonePose, float f, boolean bl, boolean bl2) {
            if (bl) {
                bonePose.rotation = bonePose.rotation + (bl2 ? f : f - bonePose.rotation) * transformConstraintPose.mixRotate;
            } else {
                float f2 = skeleton.scaleX;
                float f3 = skeleton.scaleY;
                float f4 = 1.0f / f2;
                float f5 = 1.0f / f3;
                float f6 = bonePose.a * f4;
                float f7 = bonePose.b * f4;
                float f8 = bonePose.c * f5;
                float f9 = bonePose.d * f5;
                f *= (float)Math.PI / 180;
                if (!bl2) {
                    f -= SpineUtils.atan2(f8, f6);
                }
                if (f > (float)Math.PI) {
                    f -= (float)Math.PI * 2;
                } else if (f < (float)(-Math.PI)) {
                    f += (float)Math.PI * 2;
                }
                float f10 = SpineUtils.cos(f *= transformConstraintPose.mixRotate);
                float f11 = SpineUtils.sin(f);
                bonePose.a = (f10 * f6 - f11 * f8) * f2;
                bonePose.b = (f10 * f7 - f11 * f9) * f2;
                bonePose.c = (f11 * f6 + f10 * f8) * f3;
                bonePose.d = (f11 * f7 + f10 * f9) * f3;
            }
        }
    }

    public static class FromRotate
    extends FromProperty {
        @Override
        public float value(Skeleton skeleton, BonePose bonePose, boolean bl, float[] fArray) {
            if (bl) {
                return bonePose.rotation + fArray[0];
            }
            float f = skeleton.scaleY;
            float f2 = skeleton.scaleX;
            float f3 = SpineUtils.atan2(bonePose.c / f, bonePose.a / f2) * 57.295776f + ((bonePose.a * bonePose.d - bonePose.b * bonePose.c) * f2 * f > 0.0f ? fArray[0] : -fArray[0]);
            if (f3 < 0.0f) {
                f3 += 360.0f;
            }
            return f3;
        }
    }

    public static abstract class ToProperty {
        public float offset;
        public float max;
        public float scale;

        public abstract float mix(TransformConstraintPose var1);

        public abstract void apply(Skeleton var1, TransformConstraintPose var2, BonePose var3, float var4, boolean var5, boolean var6);
    }
}

