/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class DynamicLinkLoader {
    public static native long ndlopen(long var0, int var2);

    public static long dlopen(@Nullable ByteBuffer path, int mode) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(path);
        }
        return DynamicLinkLoader.ndlopen(MemoryUtil.memAddressSafe(path), mode);
    }

    public static native long ndlerror();

    @Nullable
    public static String dlerror() {
        long __result = DynamicLinkLoader.ndlerror();
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native long ndlsym(long var0, long var2);

    public static long dlsym(long handle, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.check(handle);
            Checks.checkNT1(name);
        }
        return DynamicLinkLoader.ndlsym(handle, MemoryUtil.memAddress(name));
    }

    public static native int ndlclose(long var0);

    public static int dlclose(long handle) {
        if (Checks.CHECKS) {
            Checks.check(handle);
        }
        return DynamicLinkLoader.ndlclose(handle);
    }

    static {
        Library.initialize();
    }
}

