/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.SkeletonViewer;
import com.esotericsoftware.spine.Skin;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;

class SkeletonViewerUI {
    final SkeletonViewer viewer;
    final OrthographicCamera camera;
    boolean prefsLoaded;
    Stage stage = new Stage(new ScreenViewport());
    com.badlogic.gdx.scenes.scene2d.ui.Skin skin = new com.badlogic.gdx.scenes.scene2d.ui.Skin(Gdx.files.internal("skin/skin.json"));
    Window window = new Window("Skeleton", this.skin);
    Table root = new Table(this.skin);
    TextButton openButton = new TextButton("Open", this.skin);
    TextButton reloadButton = new TextButton("Reload", this.skin);
    TextButton minimizeButton = new TextButton("-", this.skin);
    Slider loadScaleSlider = new Slider(0.1f, 3.0f, 0.01f, false, this.skin);
    Label loadScaleLabel = new Label((CharSequence)"100%", this.skin);
    TextButton loadScaleResetButton = new TextButton("Reset", this.skin);
    Slider zoomSlider = new Slider(0.01f, 10.0f, 0.01f, false, this.skin);
    Label zoomLabel = new Label((CharSequence)"100%", this.skin);
    TextButton zoomResetButton = new TextButton("Reset", this.skin);
    Slider xScaleSlider = new Slider(-2.0f, 2.0f, 0.01f, false, this.skin);
    Label xScaleLabel = new Label((CharSequence)"100%", this.skin);
    TextButton xScaleResetButton = new TextButton("Reset", this.skin);
    Slider yScaleSlider = new Slider(-2.0f, 2.0f, 0.01f, false, this.skin);
    Label yScaleLabel = new Label((CharSequence)"100%", this.skin);
    TextButton yScaleResetButton = new TextButton("Reset", this.skin);
    CheckBox debugBonesCheckbox = new CheckBox("Bones", this.skin);
    CheckBox debugRegionsCheckbox = new CheckBox("Regions", this.skin);
    CheckBox debugBoundingBoxesCheckbox = new CheckBox("Bounds", this.skin);
    CheckBox debugMeshHullCheckbox = new CheckBox("Mesh hull", this.skin);
    CheckBox debugMeshTrianglesCheckbox = new CheckBox("Triangles", this.skin);
    CheckBox debugPathsCheckbox = new CheckBox("Paths", this.skin);
    CheckBox debugPointsCheckbox = new CheckBox("Points", this.skin);
    CheckBox debugClippingCheckbox = new CheckBox("Clipping", this.skin);
    CheckBox pmaCheckbox = new CheckBox("Premultiplied", this.skin);
    CheckBox linearCheckbox = new CheckBox("Linear", this.skin);
    TextButton bonesSetupPoseButton = new TextButton("Bones", this.skin, "toggle");
    TextButton slotsSetupPoseButton = new TextButton("Slots", this.skin, "toggle");
    TextButton setupPoseButton = new TextButton("Both", this.skin, "toggle");
    List<String> skinList = new List(this.skin);
    ScrollPane skinScroll = new ScrollPane(this.skinList, this.skin, "bg");
    ButtonGroup<TextButton> trackButtons = new ButtonGroup();
    CheckBox loopCheckbox = new CheckBox("Loop", this.skin);
    CheckBox reverseCheckbox = new CheckBox("Reverse", this.skin);
    CheckBox holdPrevCheckbox = new HigherTrackCheckBox("Hold previous");
    CheckBox addCheckbox = new HigherTrackCheckBox("Add");
    Slider alphaSlider = new Slider(0.0f, 1.0f, 0.01f, false, this.skin);
    Label alphaLabel = new Label((CharSequence)"100%", this.skin);
    List<String> animationList = new List(this.skin);
    ScrollPane animationScroll = new ScrollPane(this.animationList, this.skin, "bg");
    Slider speedSlider = new Slider(0.0f, 3.0f, 0.01f, false, this.skin);
    Label speedLabel = new Label((CharSequence)"1.0x", this.skin);
    TextButton speedResetButton = new TextButton("Reset", this.skin);
    Slider mixSlider = new Slider(0.0f, 4.0f, 0.01f, false, this.skin);
    Label mixLabel = new Label((CharSequence)"0.3s", this.skin);
    Label statusLabel = new Label((CharSequence)"", this.skin);
    WidgetGroup toasts = new WidgetGroup();

    SkeletonViewerUI(SkeletonViewer skeletonViewer) {
        this.viewer = skeletonViewer;
        this.camera = skeletonViewer.camera;
        this.initialize();
        this.layout();
        this.events();
    }

    void initialize() {
        this.skin.getFont((String)"default").getData().markupEnabled = true;
        for (int i = 0; i < 6; ++i) {
            this.trackButtons.add(new TextButton(i + "", this.skin, "toggle"));
        }
        this.pmaCheckbox.setChecked(true);
        this.linearCheckbox.setChecked(true);
        new ButtonGroup(new Button[]{this.bonesSetupPoseButton, this.slotsSetupPoseButton, this.setupPoseButton}).setMinCheckCount(0);
        this.loopCheckbox.setChecked(true);
        this.loadScaleSlider.setValue(1.0f);
        this.loadScaleSlider.setSnapToValues(0.09f, 0.5f, 1.0f, 1.5f, 2.0f, 2.5f);
        this.zoomSlider.setValue(1.0f);
        this.zoomSlider.setSnapToValues(0.3f, 1.0f, 2.0f);
        this.xScaleSlider.setValue(1.0f);
        this.xScaleSlider.setSnapToValues(0.12f, -1.5f, -1.0f, -0.5f, 0.5f, 1.0f, 1.5f);
        this.yScaleSlider.setValue(1.0f);
        this.yScaleSlider.setSnapToValues(0.12f, -1.5f, -1.0f, -0.5f, 0.5f, 1.0f, 1.5f);
        this.skinList.getSelection().setRequired(false);
        this.skinList.getSelection().setToggle(true);
        this.animationList.getSelection().setRequired(false);
        this.animationList.getSelection().setToggle(true);
        this.mixSlider.setValue(0.3f);
        this.mixSlider.setSnapToValues(0.12f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f);
        this.speedSlider.setValue(1.0f);
        this.speedSlider.setSnapToValues(0.09f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f);
        this.alphaSlider.setValue(1.0f);
        this.alphaSlider.setDisabled(true);
        this.alphaLabel.setColor(this.skin.getColor("disabled"));
        this.addCheckbox.setDisabled(true);
        this.holdPrevCheckbox.setDisabled(true);
        this.window.setMovable(false);
        this.window.setResizable(false);
        this.window.setKeepWithinStage(false);
        this.window.setX(-3.0f);
        this.window.setY(-2.0f);
        this.window.getTitleLabel().setColor(new Color(-1040187393));
        this.window.getTitleTable().add(this.openButton).spaceLeft(10.0f);
        this.window.getTitleTable().add(this.reloadButton).space(3.0f);
        this.window.getTitleTable().add(this.minimizeButton).width(20.0f);
        this.skinScroll.setFadeScrollBars(false);
        this.animationScroll.setFadeScrollBars(false);
    }

    void layout() {
        float f = this.loadScaleResetButton.getPrefWidth();
        this.root.defaults().space(6.0f);
        this.root.columnDefaults(0).top().right().padTop(3.0f);
        this.root.columnDefaults(1).left();
        this.root.add("Load scale:");
        Table table = this.table(new Actor[0]);
        table.add(this.loadScaleLabel).width(29.0f);
        table.add(this.loadScaleSlider).growX();
        table.add(this.loadScaleResetButton).width(f);
        this.root.add(table).fill().row();
        this.root.add("Zoom:");
        table = this.table(new Actor[0]);
        table.add(this.zoomLabel).width(29.0f);
        table.add(this.zoomSlider).growX();
        table.add(this.zoomResetButton).width(f);
        this.root.add(table).fill().row();
        this.root.add("Scale X:");
        table = this.table(new Actor[0]);
        table.add(this.xScaleLabel).width(29.0f);
        table.add(this.xScaleSlider).growX();
        table.add(this.xScaleResetButton).width(f);
        this.root.add(table).fill().row();
        this.root.add("Scale Y:");
        table = this.table(new Actor[0]);
        table.add(this.yScaleLabel).width(29.0f);
        table.add(this.yScaleSlider).growX();
        table.add(this.yScaleResetButton).width(f);
        this.root.add(table).fill().row();
        this.root.add("Debug:");
        this.root.add(this.table(this.debugBonesCheckbox, this.debugRegionsCheckbox, this.debugBoundingBoxesCheckbox)).row();
        this.root.add();
        this.root.add(this.table(this.debugPathsCheckbox, this.debugPointsCheckbox, this.debugClippingCheckbox)).row();
        this.root.add();
        this.root.add(this.table(this.debugMeshHullCheckbox, this.debugMeshTrianglesCheckbox)).row();
        this.root.add("Atlas alpha:");
        table = this.table(new Actor[0]);
        table.add(this.pmaCheckbox);
        table.add("Filtering:").growX().getActor().setAlignment(16);
        table.add(this.linearCheckbox);
        this.root.add(table).fill().row();
        this.root.add(new Image(this.skin.newDrawable("white", new Color(0x4E4E4EFF)))).height(1.0f).fillX().colspan(2).pad(-3.0f, 0.0f, 1.0f, 0.0f).row();
        this.root.add("Setup pose:");
        this.root.add(this.table(this.bonesSetupPoseButton, this.slotsSetupPoseButton, this.setupPoseButton)).row();
        this.root.add("Skin:");
        this.root.add(this.skinScroll).grow().minHeight(64.0f).row();
        this.root.add(new Image(this.skin.newDrawable("white", new Color(0x4E4E4EFF)))).height(1.0f).fillX().colspan(2).pad(1.0f, 0.0f, 1.0f, 0.0f).row();
        this.root.add("Track:");
        table = this.table(new Actor[0]);
        for (TextButton textButton : this.trackButtons.getButtons()) {
            table.add(textButton);
        }
        table.add(this.loopCheckbox);
        this.root.add(table).row();
        this.root.add();
        table = this.table(new Actor[0]);
        table.add(this.reverseCheckbox);
        table.add(this.holdPrevCheckbox);
        table.add(this.addCheckbox);
        this.root.add(table).row();
        this.root.add("Entry alpha:");
        table = this.table(new Actor[0]);
        table.add(this.alphaLabel).width(29.0f);
        table.add(this.alphaSlider).growX();
        this.root.add(table).fill().row();
        this.root.add("Animation:");
        this.root.add(this.animationScroll).grow().minHeight(64.0f).row();
        this.root.add(new Image(this.skin.newDrawable("white", new Color(0x4E4E4EFF)))).height(1.0f).fillX().colspan(2).pad(1.0f, 0.0f, 1.0f, 0.0f).row();
        this.root.add("Speed:");
        table = this.table(new Actor[0]);
        table.add(this.speedLabel).width(29.0f);
        table.add(this.speedSlider).growX();
        table.add(this.speedResetButton);
        this.root.add(table).fill().row();
        this.root.add("Default mix:");
        table = this.table(new Actor[0]);
        table.add(this.mixLabel).width(29.0f);
        table.add(this.mixSlider).growX();
        this.root.add(table).fill().row();
        this.window.add(this.root).grow();
        this.window.pack();
        this.stage.addActor(this.window);
        this.stage.addActor(this.statusLabel);
        table = new Table();
        table.setFillParent(true);
        table.setTouchable(Touchable.disabled);
        this.stage.addActor(table);
        table.pad(10.0f, 10.0f, 22.0f, 10.0f).bottom().right();
        table.add(this.toasts);
        table = new Table();
        table.setFillParent(true);
        table.setTouchable(Touchable.disabled);
        this.stage.addActor(table);
        table.pad(10.0f).top().right();
        table.defaults().right();
        table.add(new Label("4.2.40", this.skin, "default", Color.LIGHT_GRAY));
    }

    void events() {
        this.window.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                inputEvent.cancel();
                return true;
            }
        });
        this.openButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                FileDialog fileDialog = new FileDialog((Frame)null, "Choose skeleton file");
                fileDialog.setMode(0);
                fileDialog.setVisible(true);
                String string = fileDialog.getFile();
                String string2 = fileDialog.getDirectory();
                if (string == null || string2 == null) {
                    return;
                }
                if (SkeletonViewerUI.this.viewer.loadSkeleton(new FileHandle(new File(string2, string).getAbsolutePath()))) {
                    SkeletonViewerUI.this.toast("Loaded.");
                }
            }
        });
        this.setupPoseButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.viewer.skeleton != null) {
                    SkeletonViewerUI.this.viewer.skeleton.setToSetupPose();
                }
            }
        });
        this.bonesSetupPoseButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.viewer.skeleton != null) {
                    SkeletonViewerUI.this.viewer.skeleton.setBonesToSetupPose();
                }
            }
        });
        this.slotsSetupPoseButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.viewer.skeleton != null) {
                    SkeletonViewerUI.this.viewer.skeleton.setSlotsToSetupPose();
                }
            }
        });
        this.reloadButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.viewer.resetCameraPosition();
                if (SkeletonViewerUI.this.viewer.loadSkeleton(SkeletonViewerUI.this.viewer.lastFile)) {
                    SkeletonViewerUI.this.toast("Reloaded.");
                }
            }
        });
        this.minimizeButton.addListener(new ClickListener(){

            @Override
            public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                inputEvent.cancel();
                return super.touchDown(inputEvent, f, f2, n, n2);
            }

            @Override
            public void clicked(InputEvent inputEvent, float f, float f2) {
                if (SkeletonViewerUI.this.minimizeButton.isChecked()) {
                    SkeletonViewerUI.this.window.getCells().get(0).setActor(null);
                    SkeletonViewerUI.this.window.setHeight(37.0f);
                    SkeletonViewerUI.this.minimizeButton.setText("+");
                } else {
                    SkeletonViewerUI.this.window.getCells().get(0).setActor(SkeletonViewerUI.this.root);
                    SkeletonViewerUI.this.window.setHeight((float)Gdx.graphics.getHeight() / SkeletonViewer.uiScale + 8.0f);
                    SkeletonViewerUI.this.minimizeButton.setText("-");
                }
                SkeletonViewerUI.this.window.setWidth(SkeletonViewerUI.this.window.getPrefWidth());
            }
        });
        this.loadScaleSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.loadScaleLabel.setText(Integer.toString((int)(SkeletonViewerUI.this.loadScaleSlider.getValue() * 100.0f)) + "%");
                if (!SkeletonViewerUI.this.loadScaleSlider.isDragging() && SkeletonViewerUI.this.viewer.loadSkeleton(SkeletonViewerUI.this.viewer.skeletonFile)) {
                    SkeletonViewerUI.this.toast("Reloaded.");
                }
            }
        });
        this.loadScaleResetButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.viewer.resetCameraPosition();
                SkeletonViewerUI.this.loadScaleSlider.setValue(1.0f);
            }
        });
        this.zoomSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.zoomLabel.setText(Integer.toString((int)(SkeletonViewerUI.this.zoomSlider.getValue() * 100.0f)) + "%");
                float f = 1.0f / SkeletonViewerUI.this.zoomSlider.getValue();
                SkeletonViewerUI.this.camera.position.x -= SkeletonViewerUI.this.window.getWidth() / 2.0f * (f - SkeletonViewerUI.this.camera.zoom);
                SkeletonViewerUI.this.camera.zoom = f;
            }
        });
        this.zoomResetButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.viewer.resetCameraPosition();
                float f = SkeletonViewerUI.this.camera.position.x;
                SkeletonViewerUI.this.zoomSlider.setValue(1.0f);
                SkeletonViewerUI.this.camera.position.x = f;
            }
        });
        this.xScaleSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.xScaleSlider.getValue() == 0.0f) {
                    SkeletonViewerUI.this.xScaleSlider.setValue(0.01f);
                }
                SkeletonViewerUI.this.xScaleLabel.setText(Integer.toString((int)(SkeletonViewerUI.this.xScaleSlider.getValue() * 100.0f)) + "%");
            }
        });
        this.xScaleResetButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.xScaleSlider.setValue(1.0f);
            }
        });
        this.yScaleSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.yScaleSlider.getValue() == 0.0f) {
                    SkeletonViewerUI.this.yScaleSlider.setValue(0.01f);
                }
                SkeletonViewerUI.this.yScaleLabel.setText(Integer.toString((int)(SkeletonViewerUI.this.yScaleSlider.getValue() * 100.0f)) + "%");
            }
        });
        this.yScaleResetButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.yScaleSlider.setValue(1.0f);
            }
        });
        this.speedSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.speedLabel.setText(Float.toString((float)((int)(SkeletonViewerUI.this.speedSlider.getValue() * 100.0f)) / 100.0f) + "x");
            }
        });
        this.speedResetButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.speedSlider.setValue(1.0f);
            }
        });
        this.alphaSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                AnimationState.TrackEntry trackEntry;
                SkeletonViewerUI.this.alphaLabel.setText(Integer.toString((int)(SkeletonViewerUI.this.alphaSlider.getValue() * 100.0f)) + "%");
                int n = SkeletonViewerUI.this.trackButtons.getCheckedIndex();
                if (n > 0 && (trackEntry = SkeletonViewerUI.this.viewer.state.getCurrent(n)) != null) {
                    trackEntry.setAlpha(SkeletonViewerUI.this.alphaSlider.getValue());
                    trackEntry.resetRotationDirections();
                }
            }
        });
        this.mixSlider.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.mixLabel.setText(Float.toString((float)((int)(SkeletonViewerUI.this.mixSlider.getValue() * 100.0f)) / 100.0f) + "s");
                if (SkeletonViewerUI.this.viewer.state != null) {
                    SkeletonViewerUI.this.viewer.state.getData().setDefaultMix(SkeletonViewerUI.this.mixSlider.getValue());
                }
            }
        });
        InputListener inputListener = new InputListener(){

            @Override
            public void enter(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                if (n == -1) {
                    SkeletonViewerUI.this.stage.setScrollFocus(inputEvent.getListenerActor());
                }
            }

            @Override
            public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
                if (n == -1 && SkeletonViewerUI.this.stage.getScrollFocus() == inputEvent.getListenerActor()) {
                    SkeletonViewerUI.this.stage.setScrollFocus(null);
                }
            }
        };
        this.animationList.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.viewer.state != null) {
                    String string = SkeletonViewerUI.this.animationList.getSelected();
                    if (string == null) {
                        SkeletonViewerUI.this.viewer.state.setEmptyAnimation(SkeletonViewerUI.this.trackButtons.getCheckedIndex(), SkeletonViewerUI.this.mixSlider.getValue());
                    } else {
                        SkeletonViewerUI.this.viewer.setAnimation(false);
                    }
                }
            }
        });
        this.animationScroll.addListener(inputListener);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                SkeletonViewerUI.this.viewer.setAnimation(false);
            }
        };
        this.loopCheckbox.addListener(changeListener);
        this.reverseCheckbox.addListener(changeListener);
        this.holdPrevCheckbox.addListener(changeListener);
        this.addCheckbox.addListener(changeListener);
        this.linearCheckbox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.viewer.atlas == null) {
                    return;
                }
                Texture.TextureFilter textureFilter = SkeletonViewerUI.this.linearCheckbox.isChecked() ? Texture.TextureFilter.Linear : Texture.TextureFilter.Nearest;
                for (Texture texture : SkeletonViewerUI.this.viewer.atlas.getTextures()) {
                    texture.setFilter(textureFilter, textureFilter);
                }
            }
        });
        this.skinList.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (SkeletonViewerUI.this.viewer.skeleton != null) {
                    String string = SkeletonViewerUI.this.skinList.getSelected();
                    if (string == null) {
                        SkeletonViewerUI.this.viewer.skeleton.setSkin((Skin)null);
                    } else {
                        SkeletonViewerUI.this.viewer.skeleton.setSkin(string);
                    }
                    SkeletonViewerUI.this.viewer.skeleton.setSlotsToSetupPose();
                }
            }
        });
        this.skinScroll.addListener(inputListener);
        ChangeListener changeListener2 = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                int n = SkeletonViewerUI.this.trackButtons.getCheckedIndex();
                if (n == -1) {
                    return;
                }
                AnimationState.TrackEntry trackEntry = SkeletonViewerUI.this.viewer.state.getCurrent(n);
                SkeletonViewerUI.this.animationList.getSelection().setProgrammaticChangeEvents(false);
                SkeletonViewerUI.this.animationList.setSelected(trackEntry == null ? null : trackEntry.animation.name);
                SkeletonViewerUI.this.animationList.getSelection().setProgrammaticChangeEvents(true);
                SkeletonViewerUI.this.alphaSlider.setDisabled(n == 0);
                SkeletonViewerUI.this.alphaLabel.setColor(n == 0 ? SkeletonViewerUI.this.skin.getColor("disabled") : Color.WHITE);
                SkeletonViewerUI.this.alphaSlider.setValue(trackEntry == null ? 1.0f : trackEntry.alpha);
                SkeletonViewerUI.this.addCheckbox.setDisabled(n == 0);
                SkeletonViewerUI.this.holdPrevCheckbox.setDisabled(n == 0);
                if (trackEntry != null) {
                    SkeletonViewerUI.this.loopCheckbox.setChecked(trackEntry.getLoop());
                    SkeletonViewerUI.this.reverseCheckbox.setChecked(trackEntry.getReverse());
                    if (n > 0) {
                        SkeletonViewerUI.this.addCheckbox.setChecked(trackEntry.getMixBlend() == Animation.MixBlend.add);
                        SkeletonViewerUI.this.holdPrevCheckbox.setChecked(trackEntry.getHoldPrevious());
                    }
                }
            }
        };
        for (TextButton textButton : this.trackButtons.getButtons()) {
            textButton.addListener(changeListener2);
        }
        Gdx.input.setInputProcessor(new InputMultiplexer(this.stage, new InputAdapter(){
            float offsetX;
            float offsetY;

            @Override
            public boolean touchDown(int n, int n2, int n3, int n4) {
                this.offsetX = n;
                this.offsetY = Gdx.graphics.getHeight() - 1 - n2;
                return false;
            }

            @Override
            public boolean touchDragged(int n, int n2, int n3) {
                float f = (float)n - this.offsetX;
                float f2 = (float)(Gdx.graphics.getHeight() - 1 - n2) - this.offsetY;
                SkeletonViewerUI.this.camera.position.x -= f * SkeletonViewerUI.this.camera.zoom;
                SkeletonViewerUI.this.camera.position.y -= f2 * SkeletonViewerUI.this.camera.zoom;
                this.offsetX = n;
                this.offsetY = Gdx.graphics.getHeight() - 1 - n2;
                return false;
            }

            @Override
            public boolean touchUp(int n, int n2, int n3, int n4) {
                SkeletonViewerUI.this.savePrefs();
                return false;
            }

            @Override
            public boolean scrolled(float f, float f2) {
                float f3 = SkeletonViewerUI.this.zoomSlider.getValue();
                float f4 = SkeletonViewerUI.this.zoomSlider.getMinValue();
                float f5 = SkeletonViewerUI.this.zoomSlider.getMaxValue();
                float f6 = Math.min(1.2f, (f3 - f4) / (f5 - f4) * 3.5f);
                SkeletonViewerUI.this.zoomSlider.setValue(MathUtils.clamp(f3 -= Interpolation.linear.apply(0.02f, 0.2f, f6) * Math.signum(f2), f4, f5));
                return false;
            }
        }));
        ChangeListener changeListener3 = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (actor instanceof Slider && ((Slider)actor).isDragging()) {
                    return;
                }
                SkeletonViewerUI.this.savePrefs();
            }
        };
        this.debugBonesCheckbox.addListener(changeListener3);
        this.debugRegionsCheckbox.addListener(changeListener3);
        this.debugMeshHullCheckbox.addListener(changeListener3);
        this.debugMeshTrianglesCheckbox.addListener(changeListener3);
        this.debugPathsCheckbox.addListener(changeListener3);
        this.debugPointsCheckbox.addListener(changeListener3);
        this.debugClippingCheckbox.addListener(changeListener3);
        this.pmaCheckbox.addListener(changeListener3);
        this.linearCheckbox.addListener(changeListener3);
        this.bonesSetupPoseButton.addListener(changeListener3);
        this.slotsSetupPoseButton.addListener(changeListener3);
        this.setupPoseButton.addListener(changeListener3);
        this.loopCheckbox.addListener(changeListener3);
        this.addCheckbox.addListener(changeListener3);
        this.holdPrevCheckbox.addListener(changeListener3);
        this.reverseCheckbox.addListener(changeListener3);
        this.speedSlider.addListener(changeListener3);
        this.speedResetButton.addListener(changeListener3);
        this.mixSlider.addListener(changeListener3);
        this.loadScaleSlider.addListener(changeListener3);
        this.loadScaleResetButton.addListener(changeListener3);
        this.zoomSlider.addListener(changeListener3);
        this.zoomResetButton.addListener(changeListener3);
        this.animationList.addListener(changeListener3);
        this.skinList.addListener(changeListener3);
    }

    Table table(Actor ... actorArray) {
        Table table = new Table(this.skin);
        table.defaults().space(6.0f);
        table.add(actorArray);
        return table;
    }

    void render() {
        if (this.viewer.state != null && this.viewer.state.getCurrent(this.trackButtons.getCheckedIndex()) == null) {
            this.animationList.getSelection().setProgrammaticChangeEvents(false);
            this.animationList.setSelected(null);
            this.animationList.getSelection().setProgrammaticChangeEvents(true);
        }
        this.statusLabel.pack();
        if (this.minimizeButton.isChecked()) {
            this.statusLabel.setPosition(10.0f, 25.0f, 12);
        } else {
            this.statusLabel.setPosition(this.window.getWidth() + 6.0f, 5.0f, 12);
        }
        this.stage.act();
        this.stage.draw();
    }

    void toast(String string) {
        Table table = new Table();
        table.add(new Label((CharSequence)string, this.skin));
        table.getColor().a = 0.0f;
        table.pack();
        table.setPosition(-table.getWidth(), -3.0f - table.getHeight());
        table.addAction(Actions.sequence(Actions.parallel(Actions.moveBy(0.0f, table.getHeight(), 0.3f), Actions.fadeIn(0.3f)), Actions.delay(5.0f), Actions.parallel(Actions.moveBy(0.0f, table.getHeight(), 0.3f), Actions.fadeOut(0.3f)), Actions.removeActor()));
        for (Actor actor : this.toasts.getChildren()) {
            actor.addAction(Actions.moveBy(0.0f, table.getHeight(), 0.3f));
        }
        this.toasts.addActor(table);
        this.toasts.getParent().toFront();
    }

    void savePrefs() {
        AnimationState.TrackEntry trackEntry;
        if (!this.prefsLoaded) {
            return;
        }
        Preferences preferences = this.viewer.prefs;
        preferences.putBoolean("debugBones", this.debugBonesCheckbox.isChecked());
        preferences.putBoolean("debugRegions", this.debugRegionsCheckbox.isChecked());
        preferences.putBoolean("debugMeshHull", this.debugMeshHullCheckbox.isChecked());
        preferences.putBoolean("debugMeshTriangles", this.debugMeshTrianglesCheckbox.isChecked());
        preferences.putBoolean("debugPaths", this.debugPathsCheckbox.isChecked());
        preferences.putBoolean("debugPoints", this.debugPointsCheckbox.isChecked());
        preferences.putBoolean("debugClipping", this.debugClippingCheckbox.isChecked());
        preferences.putBoolean("premultiplied", this.pmaCheckbox.isChecked());
        preferences.putBoolean("linear", this.linearCheckbox.isChecked());
        if (this.bonesSetupPoseButton.isChecked()) {
            preferences.putString("setupPose", "bones");
        } else if (this.slotsSetupPoseButton.isChecked()) {
            preferences.putString("setupPose", "slots");
        } else if (this.setupPoseButton.isChecked()) {
            preferences.putString("setupPose", "both");
        } else {
            preferences.remove("setupPose");
        }
        preferences.putBoolean("loop", this.loopCheckbox.isChecked());
        preferences.putBoolean("add", this.addCheckbox.isChecked());
        preferences.putBoolean("holdPrev", this.holdPrevCheckbox.isChecked());
        preferences.putBoolean("reverse", this.reverseCheckbox.isChecked());
        preferences.putFloat("speed", this.speedSlider.getValue());
        preferences.putFloat("mix", this.mixSlider.getValue());
        preferences.putFloat("scale", this.loadScaleSlider.getValue());
        preferences.putFloat("zoom", this.zoomSlider.getValue());
        preferences.putFloat("x", this.camera.position.x);
        preferences.putFloat("y", this.camera.position.y);
        if (this.viewer.state != null && (trackEntry = this.viewer.state.getCurrent(0)) != null) {
            String string = trackEntry.animation.name;
            if (string.equals("<empty>")) {
                string = trackEntry.next == null ? "" : trackEntry.next.animation.name;
            }
            preferences.putString("animationName", string);
        }
        if (this.skinList.getSelected() != null) {
            preferences.putString("skinName", this.skinList.getSelected());
        }
        preferences.flush();
    }

    void loadPrefs() {
        try {
            Preferences preferences = this.viewer.prefs;
            this.debugBonesCheckbox.setChecked(preferences.getBoolean("debugBones", true));
            this.debugRegionsCheckbox.setChecked(preferences.getBoolean("debugRegions", false));
            this.debugMeshHullCheckbox.setChecked(preferences.getBoolean("debugMeshHull", false));
            this.debugMeshTrianglesCheckbox.setChecked(preferences.getBoolean("debugMeshTriangles", false));
            this.debugPathsCheckbox.setChecked(preferences.getBoolean("debugPaths", true));
            this.debugPointsCheckbox.setChecked(preferences.getBoolean("debugPoints", true));
            this.debugClippingCheckbox.setChecked(preferences.getBoolean("debugClipping", true));
            this.pmaCheckbox.setChecked(preferences.getBoolean("premultiplied", true));
            this.linearCheckbox.setChecked(preferences.getBoolean("linear", true));
            String string = preferences.getString("setupPose", "");
            this.bonesSetupPoseButton.setChecked(string.equals("bones"));
            this.slotsSetupPoseButton.setChecked(string.equals("slots"));
            this.setupPoseButton.setChecked(string.equals("both"));
            this.loopCheckbox.setChecked(preferences.getBoolean("loop", true));
            this.addCheckbox.setChecked(preferences.getBoolean("add", false));
            this.holdPrevCheckbox.setChecked(preferences.getBoolean("holdPrev", false));
            this.reverseCheckbox.setChecked(preferences.getBoolean("reverse", false));
            this.speedSlider.setValue(preferences.getFloat("speed", 0.3f));
            this.mixSlider.setValue(preferences.getFloat("mix", 0.3f));
            this.zoomSlider.setValue(preferences.getFloat("zoom", 1.0f));
            this.camera.zoom = 1.0f / preferences.getFloat("zoom", 1.0f);
            this.camera.position.x = preferences.getFloat("x", 0.0f);
            this.camera.position.y = preferences.getFloat("y", 0.0f);
            this.loadScaleSlider.setValue(preferences.getFloat("scale", 1.0f));
            this.animationList.setSelected(preferences.getString("animationName", null));
            this.skinList.setSelected(preferences.getString("skinName", null));
        }
        catch (Throwable throwable) {
            System.out.println("Unable to read preferences:");
            throwable.printStackTrace();
        }
    }

    class HigherTrackCheckBox
    extends CheckBox {
        public HigherTrackCheckBox(String string) {
            super(string, SkeletonViewerUI.this.skin);
        }

        @Override
        protected Drawable getImageDrawable() {
            if (SkeletonViewerUI.this.trackButtons.getCheckedIndex() == 0) {
                return this.getStyle().checkboxOffDisabled;
            }
            return super.getImageDrawable();
        }
    }
}

