/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;

public class JsonWriter
extends Writer {
    final Writer writer;
    private final Array<JsonObject> stack;
    private JsonObject current;
    private boolean named;

    public JsonWriter pop() throws IOException {
        if (this.named) {
            throw new IllegalStateException("Expected an object, array, or value since a name was set.");
        }
        this.stack.pop().close();
        this.current = this.stack.size == 0 ? null : this.stack.peek();
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size > 0) {
            this.pop();
        }
        this.writer.close();
    }

    public static enum OutputType {
        json,
        javascript,
        minimal;

        private static Pattern javascriptPattern;
        private static Pattern minimalNamePattern;
        private static Pattern minimalValuePattern;

        public String quoteValue(Object value) {
            int length;
            if (value == null) {
                return "null";
            }
            String string = value.toString();
            if (value instanceof Number || value instanceof Boolean) {
                return string;
            }
            StringBuilder buffer = new StringBuilder(string);
            buffer.replace('\\', "\\\\").replace('\r', "\\r").replace('\n', "\\n").replace('\t', "\\t");
            if (!(this != minimal || string.equals("true") || string.equals("false") || string.equals("null") || string.contains("//") || string.contains("/*") || (length = buffer.length()) <= 0 || buffer.charAt(length - 1) == ' ' || !minimalValuePattern.matcher(buffer).matches())) {
                return buffer.toString();
            }
            return "\"" + buffer.replace('\"', "\\\"").toString() + "\"";
        }

        public String quoteName(String value) {
            StringBuilder buffer = new StringBuilder(value);
            buffer.replace('\\', "\\\\").replace('\r', "\\r").replace('\n', "\\n").replace('\t', "\\t");
            switch (this) {
                case minimal: {
                    if (!value.contains("//") && !value.contains("/*") && minimalNamePattern.matcher(buffer).matches()) {
                        return buffer.toString();
                    }
                }
                case javascript: {
                    if (!javascriptPattern.matcher(buffer).matches()) break;
                    return buffer.toString();
                }
            }
            return "\"" + buffer.replace('\"', "\\\"").toString() + "\"";
        }

        static {
            javascriptPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
            minimalNamePattern = Pattern.compile("^[^\":,}/ ][^:]*$");
            minimalValuePattern = Pattern.compile("^[^\":,{\\[\\]/ ][^}\\],]*$");
        }
    }

    private class JsonObject {
        final boolean array;
        final /* synthetic */ JsonWriter this$0;

        void close() throws IOException {
            this.this$0.writer.write(this.array ? 93 : 125);
        }
    }
}

