/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.HasTextureRegion;
import com.esotericsoftware.spine.attachments.Sequence;

public class RegionAttachment
extends Attachment
implements HasTextureRegion {
    private TextureRegion region;
    private String path;
    private float x;
    private float y;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float rotation;
    private float width;
    private float height;
    private final float[] uvs = new float[8];
    private final float[] offset = new float[8];
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Sequence sequence;

    public RegionAttachment(String string) {
        super(string);
    }

    @Override
    public void updateRegion() {
        if (this.region == null) {
            this.uvs[0] = 0.0f;
            this.uvs[1] = 0.0f;
            this.uvs[2] = 0.0f;
            this.uvs[3] = 1.0f;
            this.uvs[4] = 1.0f;
            this.uvs[5] = 1.0f;
            this.uvs[6] = 1.0f;
            this.uvs[7] = 0.0f;
            return;
        }
        float f = this.getWidth();
        float f2 = this.getHeight();
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        float f5 = -f3;
        float f6 = -f4;
        boolean bl = false;
        if (this.region instanceof TextureAtlas.AtlasRegion) {
            TextureAtlas.AtlasRegion atlasRegion = (TextureAtlas.AtlasRegion)this.region;
            f5 += atlasRegion.offsetX / (float)atlasRegion.originalWidth * f;
            f6 += atlasRegion.offsetY / (float)atlasRegion.originalHeight * f2;
            if (atlasRegion.degrees == 90) {
                bl = true;
                f3 -= ((float)atlasRegion.originalWidth - atlasRegion.offsetX - (float)atlasRegion.packedHeight) / (float)atlasRegion.originalWidth * f;
                f4 -= ((float)atlasRegion.originalHeight - atlasRegion.offsetY - (float)atlasRegion.packedWidth) / (float)atlasRegion.originalHeight * f2;
            } else {
                f3 -= ((float)atlasRegion.originalWidth - atlasRegion.offsetX - (float)atlasRegion.packedWidth) / (float)atlasRegion.originalWidth * f;
                f4 -= ((float)atlasRegion.originalHeight - atlasRegion.offsetY - (float)atlasRegion.packedHeight) / (float)atlasRegion.originalHeight * f2;
            }
        }
        float f7 = this.getScaleX();
        float f8 = this.getScaleY();
        f5 *= f7;
        f6 *= f8;
        f3 *= f7;
        f4 *= f8;
        float f9 = this.getRotation();
        float f10 = (float)Math.cos((float)Math.PI / 180 * f9);
        float f11 = (float)Math.sin((float)Math.PI / 180 * f9);
        float f12 = this.getX();
        float f13 = this.getY();
        float f14 = f5 * f10 + f12;
        float f15 = f5 * f11;
        float f16 = f6 * f10 + f13;
        float f17 = f6 * f11;
        float f18 = f3 * f10 + f12;
        float f19 = f3 * f11;
        float f20 = f4 * f10 + f13;
        float f21 = f4 * f11;
        float[] fArray = this.offset;
        fArray[0] = f14 - f17;
        fArray[1] = f16 + f15;
        fArray[2] = f14 - f21;
        fArray[3] = f20 + f15;
        fArray[4] = f18 - f21;
        fArray[5] = f20 + f19;
        fArray[6] = f18 - f17;
        fArray[7] = f16 + f19;
        float[] fArray2 = this.uvs;
        if (bl) {
            fArray2[0] = this.region.getU2();
            fArray2[1] = this.region.getV();
            fArray2[2] = this.region.getU2();
            fArray2[3] = this.region.getV2();
            fArray2[4] = this.region.getU();
            fArray2[5] = this.region.getV2();
            fArray2[6] = this.region.getU();
            fArray2[7] = this.region.getV();
        } else {
            fArray2[0] = this.region.getU2();
            fArray2[1] = this.region.getV2();
            fArray2[2] = this.region.getU();
            fArray2[3] = this.region.getV2();
            fArray2[4] = this.region.getU();
            fArray2[5] = this.region.getV();
            fArray2[6] = this.region.getU2();
            fArray2[7] = this.region.getV();
        }
    }

    @Override
    public void setRegion(TextureRegion textureRegion) {
        if (textureRegion == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = textureRegion;
    }

    @Override
    public TextureRegion getRegion() {
        return this.region;
    }

    public void computeWorldVertices(Slot slot, float[] fArray, int n, int n2) {
        if (this.sequence != null) {
            this.sequence.apply(slot, this);
        }
        float[] fArray2 = this.offset;
        Bone bone = slot.getBone();
        float f = bone.getWorldX();
        float f2 = bone.getWorldY();
        float f3 = bone.getA();
        float f4 = bone.getB();
        float f5 = bone.getC();
        float f6 = bone.getD();
        float f7 = fArray2[6];
        float f8 = fArray2[7];
        fArray[n] = f7 * f3 + f8 * f4 + f;
        fArray[n + 1] = f7 * f5 + f8 * f6 + f2;
        f7 = fArray2[0];
        f8 = fArray2[1];
        fArray[n += n2] = f7 * f3 + f8 * f4 + f;
        fArray[n + 1] = f7 * f5 + f8 * f6 + f2;
        f7 = fArray2[2];
        f8 = fArray2[3];
        fArray[n += n2] = f7 * f3 + f8 * f4 + f;
        fArray[n + 1] = f7 * f5 + f8 * f6 + f2;
        f7 = fArray2[4];
        f8 = fArray2[5];
        fArray[n += n2] = f7 * f3 + f8 * f4 + f;
        fArray[n + 1] = f7 * f5 + f8 * f6 + f2;
    }

    public float[] getUVs() {
        return this.uvs;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public Color getColor() {
        return this.color;
    }

    public void setPath(String string) {
        this.path = string;
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }
}

