/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import java.util.Arrays;

public class PathConstraint
implements Updatable {
    final PathConstraintData data;
    final Array<Bone> bones;
    Slot target;
    float position;
    float spacing;
    float mixRotate;
    float mixX;
    float mixY;
    boolean active;
    private final FloatArray spaces = new FloatArray();
    private final FloatArray positions = new FloatArray();
    private final FloatArray world = new FloatArray();
    private final FloatArray curves = new FloatArray();
    private final FloatArray lengths = new FloatArray();
    private final float[] segments = new float[10];

    public PathConstraint(PathConstraintData pathConstraintData, Skeleton skeleton) {
        if (pathConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = pathConstraintData;
        this.bones = new Array(pathConstraintData.bones.size);
        for (BoneData boneData : pathConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findSlot(pathConstraintData.target.name);
        this.position = pathConstraintData.position;
        this.spacing = pathConstraintData.spacing;
        this.mixRotate = pathConstraintData.mixRotate;
        this.mixX = pathConstraintData.mixX;
        this.mixY = pathConstraintData.mixY;
    }

    public PathConstraint(PathConstraint pathConstraint, Skeleton skeleton) {
        if (pathConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = pathConstraint.data;
        this.bones = new Array(pathConstraint.bones.size);
        for (Bone bone : pathConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.slots.get(pathConstraint.target.data.index);
        this.position = pathConstraint.position;
        this.spacing = pathConstraint.spacing;
        this.mixRotate = pathConstraint.mixRotate;
        this.mixX = pathConstraint.mixX;
        this.mixY = pathConstraint.mixY;
    }

    @Override
    public void update() {
        boolean bl;
        float f;
        Attachment attachment = this.target.attachment;
        if (!(attachment instanceof PathAttachment)) {
            return;
        }
        float f2 = this.mixRotate;
        float f3 = this.mixX;
        float f4 = this.mixY;
        if (f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) {
            return;
        }
        PathConstraintData pathConstraintData = this.data;
        boolean bl2 = pathConstraintData.rotateMode == PathConstraintData.RotateMode.tangent;
        boolean bl3 = pathConstraintData.rotateMode == PathConstraintData.RotateMode.chainScale;
        int n = this.bones.size;
        int n2 = bl2 ? n : n + 1;
        T[] TArray = this.bones.items;
        float[] fArray = this.spaces.setSize(n2);
        float[] fArray2 = bl3 ? this.lengths.setSize(n) : null;
        float f5 = this.spacing;
        switch (pathConstraintData.spacingMode) {
            case percent: {
                float f6;
                int n3;
                if (bl3) {
                    n3 = n2 - 1;
                    for (int i = 0; i < n3; ++i) {
                        Bone bone = (Bone)TArray[i];
                        float f7 = bone.data.length;
                        if (f7 < 1.0E-5f) {
                            fArray2[i] = 0.0f;
                            continue;
                        }
                        float f8 = f7 * bone.a;
                        f6 = f7 * bone.c;
                        fArray2[i] = (float)Math.sqrt(f8 * f8 + f6 * f6);
                    }
                }
                Arrays.fill(fArray, 1, n2, f5);
                break;
            }
            case proportional: {
                float f9;
                float f10;
                float f6;
                float f11 = 0.0f;
                int n3 = 0;
                int n4 = n2 - 1;
                while (n3 < n4) {
                    Bone bone = (Bone)TArray[n3];
                    float f12 = bone.data.length;
                    if (f12 < 1.0E-5f) {
                        if (bl3) {
                            fArray2[n3] = 0.0f;
                        }
                        fArray[++n3] = f5;
                        continue;
                    }
                    f6 = f12 * bone.a;
                    f10 = f12 * bone.c;
                    f9 = (float)Math.sqrt(f6 * f6 + f10 * f10);
                    if (bl3) {
                        fArray2[n3] = f9;
                    }
                    fArray[++n3] = f9;
                    f11 += f9;
                }
                if (!(f11 > 0.0f)) break;
                f11 = (float)n2 / f11 * f5;
                n3 = 1;
                while (n3 < n2) {
                    int n5 = n3++;
                    fArray[n5] = fArray[n5] * f11;
                }
                break;
            }
            default: {
                float f9;
                float f10;
                float f6;
                int n3 = pathConstraintData.spacingMode == PathConstraintData.SpacingMode.length ? 1 : 0;
                int n6 = 0;
                int n7 = n2 - 1;
                while (n6 < n7) {
                    Bone bone = (Bone)TArray[n6];
                    f6 = bone.data.length;
                    if (f6 < 1.0E-5f) {
                        if (bl3) {
                            fArray2[n6] = 0.0f;
                        }
                        fArray[++n6] = f5;
                        continue;
                    }
                    f10 = f6 * bone.a;
                    f9 = f6 * bone.c;
                    f = (float)Math.sqrt(f10 * f10 + f9 * f9);
                    if (bl3) {
                        fArray2[n6] = f;
                    }
                    fArray[++n6] = (n3 != 0 ? f6 + f5 : f5) * f / f6;
                }
                break block0;
            }
        }
        float[] fArray3 = this.computeWorldPositions((PathAttachment)attachment, n2, bl2);
        float f13 = fArray3[0];
        float f14 = fArray3[1];
        float f15 = pathConstraintData.offsetRotation;
        if (f15 == 0.0f) {
            bl = pathConstraintData.rotateMode == PathConstraintData.RotateMode.chain;
        } else {
            bl = false;
            Bone bone = this.target.bone;
            f15 *= bone.a * bone.d - bone.b * bone.c > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        }
        int n8 = 0;
        int n9 = 3;
        while (n8 < n) {
            float f16;
            float f17;
            Bone bone = (Bone)TArray[n8];
            bone.worldX += (f13 - bone.worldX) * f3;
            bone.worldY += (f14 - bone.worldY) * f4;
            f = fArray3[n9];
            float f18 = fArray3[n9 + 1];
            float f19 = f - f13;
            float f20 = f18 - f14;
            if (bl3 && (f17 = fArray2[n8]) >= 1.0E-5f) {
                f16 = ((float)Math.sqrt(f19 * f19 + f20 * f20) / f17 - 1.0f) * f2 + 1.0f;
                bone.a *= f16;
                bone.c *= f16;
            }
            f13 = f;
            f14 = f18;
            if (f2 > 0.0f) {
                float f21;
                float f22;
                f17 = bone.a;
                f16 = bone.b;
                float f23 = bone.c;
                float f24 = bone.d;
                float f25 = bl2 ? fArray3[n9 - 1] : (fArray[n8 + 1] < 1.0E-5f ? fArray3[n9 + 2] : (float)Math.atan2(f20, f19));
                f25 -= (float)Math.atan2(f23, f17);
                if (bl) {
                    f22 = (float)Math.cos(f25);
                    f21 = (float)Math.sin(f25);
                    float f26 = bone.data.length;
                    f13 += (f26 * (f22 * f17 - f21 * f23) - f19) * f2;
                    f14 += (f26 * (f21 * f17 + f22 * f23) - f20) * f2;
                } else {
                    f25 += f15;
                }
                if (f25 > (float)Math.PI) {
                    f25 -= (float)Math.PI * 2;
                } else if (f25 < (float)(-Math.PI)) {
                    f25 += (float)Math.PI * 2;
                }
                f22 = (float)Math.cos(f25 *= f2);
                f21 = (float)Math.sin(f25);
                bone.a = f22 * f17 - f21 * f23;
                bone.b = f22 * f16 - f21 * f24;
                bone.c = f21 * f17 + f22 * f23;
                bone.d = f21 * f16 + f22 * f24;
            }
            bone.updateAppliedTransform();
            ++n8;
            n9 += 3;
        }
    }

    /*
     * Unable to fully structure code
     */
    float[] computeWorldPositions(PathAttachment var1_1, int var2_2, boolean var3_3) {
        block41: {
            var4_4 = this.target;
            var5_5 = this.position;
            var6_6 = this.spaces.items;
            var7_7 = this.positions.setSize(var2_2 * 3 + 2);
            var9_8 = var1_1.getClosed();
            var10_9 = var1_1.getWorldVerticesLength();
            var11_10 = var10_9 / 6;
            var12_11 = -1;
            if (var1_1.getConstantSpeed()) break block41;
            var13_12 = var1_1.getLengths();
            var14_14 = var13_12[var11_10 -= var9_8 != false ? 1 : 2];
            if (this.data.positionMode == PathConstraintData.PositionMode.percent) {
                var5_5 *= var14_14;
            }
            switch (1.$SwitchMap$com$esotericsoftware$spine$PathConstraintData$SpacingMode[this.data.spacingMode.ordinal()]) {
                case 1: {
                    var15_16 = var14_14;
                    break;
                }
                case 2: {
                    var15_16 = var14_14 / (float)var2_2;
                    break;
                }
                default: {
                    var15_16 = 1.0f;
                }
            }
            var8_18 = this.world.setSize(8);
            var16_20 = 0;
            var17_22 = 0;
            var18_24 = 0;
            while (var16_20 < var2_2) {
                block42: {
                    var19_26 = var6_6[var16_20] * var15_16;
                    var20_28 = var5_5 += var19_26;
                    if (!var9_8) break block42;
                    if ((var20_28 %= var14_14) < 0.0f) {
                        var20_28 += var14_14;
                    }
                    var18_24 = 0;
                    ** GOTO lbl-1000
                }
                if (var20_28 < 0.0f) {
                    if (var12_11 != -2) {
                        var12_11 = -2;
                        var1_1.computeWorldVertices(var4_4, 2, 4, var8_18, 0, 2);
                    }
                    this.addBeforePosition(var20_28, var8_18, 0, var7_7, var17_22);
                } else if (var20_28 > var14_14) {
                    if (var12_11 != -3) {
                        var12_11 = -3;
                        var1_1.computeWorldVertices(var4_4, var10_9 - 6, 4, var8_18, 0, 2);
                    }
                    this.addAfterPosition(var20_28 - var14_14, var8_18, 0, var7_7, var17_22);
                } else lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (!(var20_28 > (var21_30 = var13_12[var18_24]))) {
                            if (var18_24 == 0) {
                                var20_28 /= var21_30;
                                break;
                            }
                            var22_32 = var13_12[var18_24 - 1];
                            var20_28 = (var20_28 - var22_32) / (var21_30 - var22_32);
                            break;
                        }
                        ++var18_24;
                    }
                    if (var18_24 != var12_11) {
                        var12_11 = var18_24;
                        if (var9_8 && var18_24 == var11_10) {
                            var1_1.computeWorldVertices(var4_4, var10_9 - 4, 4, var8_18, 0, 2);
                            var1_1.computeWorldVertices(var4_4, 0, 4, var8_18, 4, 2);
                        } else {
                            var1_1.computeWorldVertices(var4_4, var18_24 * 6 + 2, 8, var8_18, 0, 2);
                        }
                    }
                    this.addCurvePosition(var20_28, var8_18[0], var8_18[1], var8_18[2], var8_18[3], var8_18[4], var8_18[5], var8_18[6], var8_18[7], var7_7, var17_22, var3_3 != false || var16_20 > 0 && var19_26 < 1.0E-5f);
                }
                ++var16_20;
                var17_22 += 3;
            }
            return var7_7;
        }
        if (var9_8) {
            var8_19 = this.world.setSize(var10_9 += 2);
            var1_1.computeWorldVertices(var4_4, 2, var10_9 - 4, var8_19, 0, 2);
            var1_1.computeWorldVertices(var4_4, 0, 2, var8_19, var10_9 - 4, 2);
            var8_19[var10_9 - 2] = var8_19[0];
            var8_19[var10_9 - 1] = var8_19[1];
        } else {
            --var11_10;
            var8_19 = this.world.setSize(var10_9 -= 4);
            var1_1.computeWorldVertices(var4_4, 2, var10_9, var8_19, 0, 2);
        }
        var13_13 = this.curves.setSize(var11_10);
        var14_15 = 0.0f;
        var15_17 = var8_19[0];
        var16_21 = var8_19[1];
        var17_23 = 0.0f;
        var18_25 = 0.0f;
        var19_27 = 0.0f;
        var20_29 = 0.0f;
        var21_31 = 0.0f;
        var22_33 = 0.0f;
        var31_34 = 0;
        var32_36 = 2;
        while (var31_34 < var11_10) {
            var17_23 = var8_19[var32_36];
            var18_25 = var8_19[var32_36 + 1];
            var19_27 = var8_19[var32_36 + 2];
            var20_29 = var8_19[var32_36 + 3];
            var21_31 = var8_19[var32_36 + 4];
            var22_33 = var8_19[var32_36 + 5];
            var23_38 = (var15_17 - var17_23 * 2.0f + var19_27) * 0.1875f;
            var24_39 = (var16_21 - var18_25 * 2.0f + var20_29) * 0.1875f;
            var25_40 = ((var17_23 - var19_27) * 3.0f - var15_17 + var21_31) * 0.09375f;
            var26_41 = ((var18_25 - var20_29) * 3.0f - var16_21 + var22_33) * 0.09375f;
            var27_42 = var23_38 * 2.0f + var25_40;
            var28_43 = var24_39 * 2.0f + var26_41;
            var29_44 = (var17_23 - var15_17) * 0.75f + var23_38 + var25_40 * 0.16666667f;
            var30_45 = (var18_25 - var16_21) * 0.75f + var24_39 + var26_41 * 0.16666667f;
            var14_15 += (float)Math.sqrt(var29_44 * var29_44 + var30_45 * var30_45);
            var29_44 += var27_42;
            var30_45 += var28_43;
            var14_15 += (float)Math.sqrt(var29_44 * var29_44 + var30_45 * var30_45);
            var14_15 += (float)Math.sqrt((var29_44 += (var27_42 += var25_40)) * var29_44 + (var30_45 += (var28_43 += var26_41)) * var30_45);
            var13_13[var31_34] = var14_15 += (float)Math.sqrt((var29_44 += var27_42 + var25_40) * var29_44 + (var30_45 += var28_43 + var26_41) * var30_45);
            var15_17 = var21_31;
            var16_21 = var22_33;
            ++var31_34;
            var32_36 += 6;
        }
        if (this.data.positionMode == PathConstraintData.PositionMode.percent) {
            var5_5 *= var14_15;
        }
        switch (1.$SwitchMap$com$esotericsoftware$spine$PathConstraintData$SpacingMode[this.data.spacingMode.ordinal()]) {
            case 1: {
                var31_35 = var14_15;
                break;
            }
            case 2: {
                var31_35 = var14_15 / (float)var2_2;
                break;
            }
            default: {
                var31_35 = 1.0f;
            }
        }
        var32_37 = this.segments;
        var33_46 = 0.0f;
        var34_47 = 0;
        var35_48 = 0;
        var36_49 = 0;
        var37_50 = 0;
        while (var34_47 < var2_2) {
            block43: {
                var38_51 = var6_6[var34_47] * var31_35;
                var39_52 = var5_5 += var38_51;
                if (!var9_8) break block43;
                if ((var39_52 %= var14_15) < 0.0f) {
                    var39_52 += var14_15;
                }
                var36_49 = 0;
                ** GOTO lbl-1000
            }
            if (var39_52 < 0.0f) {
                this.addBeforePosition(var39_52, var8_19, 0, var7_7, var35_48);
            } else if (var39_52 > var14_15) {
                this.addAfterPosition(var39_52 - var14_15, var8_19, var10_9 - 4, var7_7, var35_48);
            } else lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (!(var39_52 > (var40_53 = var13_13[var36_49]))) {
                        if (var36_49 == 0) {
                            var39_52 /= var40_53;
                            break;
                        }
                        var41_55 = var13_13[var36_49 - 1];
                        var39_52 = (var39_52 - var41_55) / (var40_53 - var41_55);
                        break;
                    }
                    ++var36_49;
                }
                if (var36_49 != var12_11) {
                    var12_11 = var36_49;
                    var40_54 = var36_49 * 6;
                    var15_17 = var8_19[var40_54];
                    var16_21 = var8_19[var40_54 + 1];
                    var17_23 = var8_19[var40_54 + 2];
                    var18_25 = var8_19[var40_54 + 3];
                    var19_27 = var8_19[var40_54 + 4];
                    var20_29 = var8_19[var40_54 + 5];
                    var21_31 = var8_19[var40_54 + 6];
                    var22_33 = var8_19[var40_54 + 7];
                    var23_38 = (var15_17 - var17_23 * 2.0f + var19_27) * 0.03f;
                    var24_39 = (var16_21 - var18_25 * 2.0f + var20_29) * 0.03f;
                    var25_40 = ((var17_23 - var19_27) * 3.0f - var15_17 + var21_31) * 0.006f;
                    var26_41 = ((var18_25 - var20_29) * 3.0f - var16_21 + var22_33) * 0.006f;
                    var27_42 = var23_38 * 2.0f + var25_40;
                    var28_43 = var24_39 * 2.0f + var26_41;
                    var29_44 = (var17_23 - var15_17) * 0.3f + var23_38 + var25_40 * 0.16666667f;
                    var30_45 = (var18_25 - var16_21) * 0.3f + var24_39 + var26_41 * 0.16666667f;
                    var32_37[0] = var33_46 = (float)Math.sqrt(var29_44 * var29_44 + var30_45 * var30_45);
                    for (var40_54 = 1; var40_54 < 8; ++var40_54) {
                        var32_37[var40_54] = var33_46 += (float)Math.sqrt((var29_44 += (var27_42 += var25_40)) * var29_44 + (var30_45 += (var28_43 += var26_41)) * var30_45);
                    }
                    var32_37[8] = var33_46 += (float)Math.sqrt((var29_44 += var27_42) * var29_44 + (var30_45 += var28_43) * var30_45);
                    var32_37[9] = var33_46 += (float)Math.sqrt((var29_44 += var27_42 + var25_40) * var29_44 + (var30_45 += var28_43 + var26_41) * var30_45);
                    var37_50 = 0;
                }
                var39_52 *= var33_46;
                while (true) {
                    if (!(var39_52 > (var40_53 = var32_37[var37_50]))) {
                        if (var37_50 == 0) {
                            var39_52 /= var40_53;
                            break;
                        }
                        var41_55 = var32_37[var37_50 - 1];
                        var39_52 = (float)var37_50 + (var39_52 - var41_55) / (var40_53 - var41_55);
                        break;
                    }
                    ++var37_50;
                }
                this.addCurvePosition(var39_52 * 0.1f, var15_17, var16_21, var17_23, var18_25, var19_27, var20_29, var21_31, var22_33, var7_7, var35_48, var3_3 != false || var34_47 > 0 && var38_51 < 1.0E-5f);
            }
            ++var34_47;
            var35_48 += 3;
        }
        return var7_7;
    }

    private void addBeforePosition(float f, float[] fArray, int n, float[] fArray2, int n2) {
        float f2 = fArray[n];
        float f3 = fArray[n + 1];
        float f4 = fArray[n + 2] - f2;
        float f5 = fArray[n + 3] - f3;
        float f6 = (float)Math.atan2(f5, f4);
        fArray2[n2] = f2 + f * (float)Math.cos(f6);
        fArray2[n2 + 1] = f3 + f * (float)Math.sin(f6);
        fArray2[n2 + 2] = f6;
    }

    private void addAfterPosition(float f, float[] fArray, int n, float[] fArray2, int n2) {
        float f2 = fArray[n + 2];
        float f3 = fArray[n + 3];
        float f4 = f2 - fArray[n];
        float f5 = f3 - fArray[n + 1];
        float f6 = (float)Math.atan2(f5, f4);
        fArray2[n2] = f2 + f * (float)Math.cos(f6);
        fArray2[n2 + 1] = f3 + f * (float)Math.sin(f6);
        fArray2[n2 + 2] = f6;
    }

    private void addCurvePosition(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray, int n, boolean bl) {
        if (f < 1.0E-5f || Float.isNaN(f)) {
            fArray[n] = f2;
            fArray[n + 1] = f3;
            fArray[n + 2] = (float)Math.atan2(f5 - f3, f4 - f2);
            return;
        }
        float f10 = f * f;
        float f11 = f10 * f;
        float f12 = 1.0f - f;
        float f13 = f12 * f12;
        float f14 = f13 * f12;
        float f15 = f12 * f;
        float f16 = f15 * 3.0f;
        float f17 = f12 * f16;
        float f18 = f16 * f;
        float f19 = f2 * f14 + f4 * f17 + f6 * f18 + f8 * f11;
        float f20 = f3 * f14 + f5 * f17 + f7 * f18 + f9 * f11;
        fArray[n] = f19;
        fArray[n + 1] = f20;
        if (bl) {
            fArray[n + 2] = f < 0.001f ? (float)Math.atan2(f5 - f3, f4 - f2) : (float)Math.atan2(f20 - (f3 * f13 + f5 * f15 * 2.0f + f7 * f10), f19 - (f2 * f13 + f4 * f15 * 2.0f + f6 * f10));
        }
    }

    public String toString() {
        return this.data.name;
    }
}

