/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL15 {
    public static void glBindBuffer(int target, int buffer) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBindBuffer;
        BufferChecks.checkFunctionAddress(function_pointer);
        StateTracker.bindBuffer(caps, target, buffer);
        GL15.nglBindBuffer(target, buffer, function_pointer);
    }

    static native void nglBindBuffer(int var0, int var1, long var2);

    static native void nglDeleteBuffers(int var0, long var1, long var3);

    public static void glDeleteBuffers(int buffer) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteBuffers;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL15.nglDeleteBuffers(1, APIUtil.getInt(caps, buffer), function_pointer);
    }

    static native void nglGenBuffers(int var0, long var1, long var3);

    public static int glGenBuffers() {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGenBuffers;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer buffers = APIUtil.getBufferInt(caps);
        GL15.nglGenBuffers(1, MemoryUtil.getAddress(buffers), function_pointer);
        return buffers.get(0);
    }

    public static void glBufferData(int target, long data_size, int usage) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferData;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL15.nglBufferData(target, data_size, 0L, usage, function_pointer);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferData(target, data.remaining(), MemoryUtil.getAddress(data), usage, function_pointer);
    }

    public static void glBufferData(int target, DoubleBuffer data, int usage) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferData(target, data.remaining() << 3, MemoryUtil.getAddress(data), usage, function_pointer);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.getAddress(data), usage, function_pointer);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferData(target, data.remaining() << 2, MemoryUtil.getAddress(data), usage, function_pointer);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferData(target, data.remaining() << 1, MemoryUtil.getAddress(data), usage, function_pointer);
    }

    static native void nglBufferData(int var0, long var1, long var3, int var5, long var6);

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferSubData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.getAddress(data), function_pointer);
    }

    public static void glBufferSubData(int target, long offset, DoubleBuffer data) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferSubData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining() << 3, MemoryUtil.getAddress(data), function_pointer);
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferSubData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data), function_pointer);
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferSubData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data), function_pointer);
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBufferSubData;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(data);
        GL15.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.getAddress(data), function_pointer);
    }

    static native void nglBufferSubData(int var0, long var1, long var3, long var5, long var7);
}

