/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonRenderer;

public class SkeletonDrawable
extends BaseDrawable {
    private SkeletonRenderer renderer;
    private Skeleton skeleton;
    AnimationState state;
    private boolean resetBlendFunction = true;

    public SkeletonDrawable() {
    }

    public SkeletonDrawable(SkeletonRenderer skeletonRenderer, Skeleton skeleton, AnimationState animationState) {
        this.renderer = skeletonRenderer;
        this.skeleton = skeleton;
        this.state = animationState;
    }

    public void update(float f) {
        this.state.update(f);
        this.state.apply(this.skeleton);
    }

    @Override
    public void draw(Batch batch, float f, float f2, float f3, float f4) {
        int n = batch.getBlendSrcFunc();
        int n2 = batch.getBlendDstFunc();
        int n3 = batch.getBlendSrcFuncAlpha();
        int n4 = batch.getBlendDstFuncAlpha();
        this.skeleton.setPosition(f, f2);
        this.skeleton.updateWorldTransform();
        this.renderer.draw(batch, this.skeleton);
        if (this.resetBlendFunction) {
            batch.setBlendFunctionSeparate(n, n2, n3, n4);
        }
    }

    public SkeletonRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(SkeletonRenderer skeletonRenderer) {
        this.renderer = skeletonRenderer;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public AnimationState getAnimationState() {
        return this.state;
    }

    public void setAnimationState(AnimationState animationState) {
        this.state = animationState;
    }

    public boolean getResetBlendFunction() {
        return this.resetBlendFunction;
    }

    public void setResetBlendFunction(boolean bl) {
        this.resetBlendFunction = bl;
    }
}

