/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;

public class BoneData {
    final int index;
    final String name;
    final BoneData parent;
    float length;
    float x;
    float y;
    float rotation;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float shearX;
    float shearY;
    TransformMode transformMode = TransformMode.normal;
    final Color color = new Color(0.61f, 0.61f, 0.61f, 1.0f);

    public BoneData(int n, String string, BoneData boneData) {
        if (n < 0) {
            throw new IllegalArgumentException("index must be >= 0.");
        }
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.index = n;
        this.name = string;
        this.parent = boneData;
    }

    public BoneData(BoneData boneData, BoneData boneData2) {
        if (boneData == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        this.index = boneData.index;
        this.name = boneData.name;
        this.parent = boneData2;
        this.length = boneData.length;
        this.x = boneData.x;
        this.y = boneData.y;
        this.rotation = boneData.rotation;
        this.scaleX = boneData.scaleX;
        this.scaleY = boneData.scaleY;
        this.shearX = boneData.shearX;
        this.shearY = boneData.shearY;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public BoneData getParent() {
        return this.parent;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        this.length = f;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public float getShearX() {
        return this.shearX;
    }

    public void setShearX(float f) {
        this.shearX = f;
    }

    public float getShearY() {
        return this.shearY;
    }

    public void setShearY(float f) {
        this.shearY = f;
    }

    public TransformMode getTransformMode() {
        return this.transformMode;
    }

    public void setTransformMode(TransformMode transformMode) {
        this.transformMode = transformMode;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    public static enum TransformMode {
        normal,
        onlyTranslation,
        noRotationOrReflection,
        noScale,
        noScaleOrReflection;

        public static final TransformMode[] values;

        static {
            values = TransformMode.values();
        }
    }
}

