/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;

public class JsonRollback {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: <inputFile> [outputFile]");
            System.exit(0);
        }
        JsonValue root = (JsonValue)new Json().fromJson(null, new FileHandle(args[0]));
        JsonRollback.setValue(root, "skinnedmesh", "skins", "*", "*", "*", "type", "weightedmesh");
        JsonRollback.delete(root, "animations", "*", "bones", "*", "shear");
        JsonRollback.rename(root, "ffd", "animations", "*", "deform");
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "mesh")) {
            if (value.parent.get((String)"uvs").size == value.parent.get((String)"vertices").size) continue;
            value.set("skinnedmesh");
        }
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "linkedmesh")) {
            String slot = value.parent.parent.name.replaceAll("", "");
            String skinName = value.parent.getString("skin", "default");
            String parentName = value.parent.getString("parent");
            if (JsonRollback.find((JsonValue)root, new Array<JsonValue>(), (int)0, (String[])new StringBuilder((String)"skins~~").append((String)skinName).append((String)"~~").append((String)slot).append((String)"~~").append((String)parentName).append((String)"~~type~~skinnedmesh").toString().split((String)"~~")).size <= 0) continue;
            value.set("weightedlinkedmesh");
        }
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "boundingbox")) {
            if (value.parent.getInt("vertexCount") * 2 == value.parent.get((String)"vertices").size) continue;
            value.parent.parent.remove(value.parent.name);
        }
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, "skins", "*", "*", "*", "type", "path")) {
            String attachment = value.parent.name;
            value.parent.parent.remove(attachment);
            String slot = value.parent.parent.name;
            JsonRollback.delete(root, "animations", "*", "ffd", "*", slot, attachment);
        }
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, "animations", "*", "ik", "*")) {
            JsonValue child = value.child;
            while (child != null) {
                if (!child.has("bendPositive")) {
                    child.addChild("bendPositive", new JsonValue(true));
                }
                child = child.next;
            }
        }
        JsonValue child = root.getChild("transform");
        while (child != null) {
            JsonValue bones = child.remove("bones");
            if (bones != null) {
                child.addChild("bone", new JsonValue(bones.child.asString()));
            }
            child = child.next;
        }
        if (args.length > 1) {
            new FileHandle(args[1]).writeString(root.prettyPrint(JsonWriter.OutputType.json, 130), false, "UTF-8");
        } else {
            System.out.println(root.prettyPrint(JsonWriter.OutputType.json, 130));
        }
    }

    static void setValue(JsonValue root, String newValue, String ... path) {
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, path)) {
            value.set(newValue);
        }
    }

    static void rename(JsonValue root, String newName, String ... path) {
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, path)) {
            value.name = newName;
        }
    }

    static void delete(JsonValue root, String ... path) {
        for (JsonValue value : JsonRollback.find(root, new Array<JsonValue>(), 0, path)) {
            value.parent.remove(value.name);
        }
    }

    static Array<JsonValue> find(JsonValue current, Array<JsonValue> values, int index, String ... path) {
        String name = path[index];
        if (current.name == null) {
            if (name.equals("*") && index == path.length - 1) {
                values.add(current);
            } else if (current.has(name)) {
                return JsonRollback.find(current.get(name), values, index, path);
            }
        } else if (name.equals("*") || current.name.equals(name)) {
            if (++index == path.length || index == path.length - 1 && current.isString() && current.asString().equals(path[index])) {
                values.add(current);
            } else {
                JsonValue child = current.child;
                while (child != null) {
                    JsonRollback.find(child, values, index, path);
                    child = child.next;
                }
            }
        }
        return values;
    }
}

