/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.VertexAttachment;

public class MeshAttachment
extends VertexAttachment {
    private TextureRegion region;
    private String path;
    private float[] regionUVs;
    private float[] worldVertices;
    private short[] triangles;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private int hullLength;
    private MeshAttachment parentMesh;
    private boolean inheritDeform;
    private short[] edges;
    private float width;
    private float height;

    public MeshAttachment(String string) {
        super(string);
    }

    public void setRegion(TextureRegion textureRegion) {
        if (textureRegion == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = textureRegion;
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public void updateUVs() {
        float f;
        float f2;
        float f3;
        float f4;
        float[] fArray = this.regionUVs;
        int n = fArray.length;
        int n2 = (n >> 1) * 5;
        if (this.worldVertices == null || this.worldVertices.length != n2) {
            this.worldVertices = new float[n2];
        }
        if (this.region == null) {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 1.0f;
            f = 1.0f;
        } else {
            f3 = this.region.getU();
            f4 = this.region.getV();
            f = this.region.getU2() - f3;
            f2 = this.region.getV2() - f4;
        }
        if (this.region instanceof TextureAtlas.AtlasRegion && ((TextureAtlas.AtlasRegion)this.region).rotate) {
            int n3 = 0;
            int n4 = 3;
            while (n3 < n) {
                this.worldVertices[n4] = f3 + fArray[n3 + 1] * f;
                this.worldVertices[n4 + 1] = f4 + f2 - fArray[n3] * f2;
                n3 += 2;
                n4 += 5;
            }
        } else {
            int n5 = 0;
            int n6 = 3;
            while (n5 < n) {
                this.worldVertices[n6] = f3 + fArray[n5] * f;
                this.worldVertices[n6 + 1] = f4 + fArray[n5 + 1] * f2;
                n5 += 2;
                n6 += 5;
            }
        }
    }

    public float[] updateWorldVertices(Slot slot, boolean bl) {
        Skeleton skeleton = slot.getSkeleton();
        Color color = skeleton.getColor();
        Color color2 = slot.getColor();
        Color color3 = this.color;
        float f = color.a * color2.a * color3.a * 255.0f;
        float f2 = bl ? f : 255.0f;
        float f3 = NumberUtils.intToFloatColor((int)f << 24 | (int)(color.b * color2.b * color3.b * f2) << 16 | (int)(color.g * color2.g * color3.g * f2) << 8 | (int)(color.r * color2.r * color3.r * f2));
        FloatArray floatArray = slot.getAttachmentVertices();
        float[] fArray = this.vertices;
        float[] fArray2 = this.worldVertices;
        int[] nArray = this.bones;
        if (nArray == null) {
            int n = fArray.length;
            if (floatArray.size > 0) {
                fArray = floatArray.items;
            }
            Bone bone = slot.getBone();
            float f4 = bone.getWorldX();
            float f5 = bone.getWorldY();
            float f6 = bone.getA();
            float f7 = bone.getB();
            float f8 = bone.getC();
            float f9 = bone.getD();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                float f10 = fArray[n2];
                float f11 = fArray[n2 + 1];
                fArray2[n3] = f10 * f6 + f11 * f7 + f4;
                fArray2[n3 + 1] = f10 * f8 + f11 * f9 + f5;
                fArray2[n3 + 2] = f3;
                n2 += 2;
                n3 += 5;
            }
            return fArray2;
        }
        T[] TArray = skeleton.getBones().items;
        if (floatArray.size == 0) {
            int n = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = nArray.length;
            while (n4 < n6) {
                float f12 = 0.0f;
                float f13 = 0.0f;
                int n7 = nArray[n4++] + n4;
                while (n4 < n7) {
                    Bone bone = (Bone)TArray[nArray[n4]];
                    float f14 = fArray[n5];
                    float f15 = fArray[n5 + 1];
                    float f16 = fArray[n5 + 2];
                    f12 += (f14 * bone.getA() + f15 * bone.getB() + bone.getWorldX()) * f16;
                    f13 += (f14 * bone.getC() + f15 * bone.getD() + bone.getWorldY()) * f16;
                    ++n4;
                    n5 += 3;
                }
                fArray2[n] = f12;
                fArray2[n + 1] = f13;
                fArray2[n + 2] = f3;
                n += 5;
            }
        } else {
            float[] fArray3 = floatArray.items;
            int n = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = nArray.length;
            while (n8 < n11) {
                float f17 = 0.0f;
                float f18 = 0.0f;
                int n12 = nArray[n8++] + n8;
                while (n8 < n12) {
                    Bone bone = (Bone)TArray[nArray[n8]];
                    float f19 = fArray[n9] + fArray3[n10];
                    float f20 = fArray[n9 + 1] + fArray3[n10 + 1];
                    float f21 = fArray[n9 + 2];
                    f17 += (f19 * bone.getA() + f20 * bone.getB() + bone.getWorldX()) * f21;
                    f18 += (f19 * bone.getC() + f20 * bone.getD() + bone.getWorldY()) * f21;
                    ++n8;
                    n9 += 3;
                    n10 += 2;
                }
                fArray2[n] = f17;
                fArray2[n + 1] = f18;
                fArray2[n + 2] = f3;
                n += 5;
            }
        }
        return fArray2;
    }

    @Override
    public boolean applyDeform(VertexAttachment vertexAttachment) {
        return this == vertexAttachment || this.inheritDeform && this.parentMesh == vertexAttachment;
    }

    public float[] getWorldVertices() {
        return this.worldVertices;
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public void setTriangles(short[] sArray) {
        this.triangles = sArray;
    }

    public float[] getRegionUVs() {
        return this.regionUVs;
    }

    public void setRegionUVs(float[] fArray) {
        this.regionUVs = fArray;
    }

    public Color getColor() {
        return this.color;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public int getHullLength() {
        return this.hullLength;
    }

    public void setHullLength(int n) {
        this.hullLength = n;
    }

    public void setEdges(short[] sArray) {
        this.edges = sArray;
    }

    public short[] getEdges() {
        return this.edges;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public MeshAttachment getParentMesh() {
        return this.parentMesh;
    }

    public void setParentMesh(MeshAttachment meshAttachment) {
        this.parentMesh = meshAttachment;
        if (meshAttachment != null) {
            this.bones = meshAttachment.bones;
            this.vertices = meshAttachment.vertices;
            this.regionUVs = meshAttachment.regionUVs;
            this.triangles = meshAttachment.triangles;
            this.hullLength = meshAttachment.hullLength;
            this.worldVerticesLength = meshAttachment.worldVerticesLength;
            this.edges = meshAttachment.edges;
            this.width = meshAttachment.width;
            this.height = meshAttachment.height;
        }
    }

    public boolean getInheritDeform() {
        return this.inheritDeform;
    }

    public void setInheritDeform(boolean bl) {
        this.inheritDeform = bl;
    }
}

