/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBounds;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkinnedMeshAttachment;

public class SkeletonRendererDebug {
    private static final Color boneLineColor = Color.RED;
    private static final Color boneOriginColor = Color.GREEN;
    private static final Color attachmentLineColor = new Color(0.0f, 0.0f, 1.0f, 0.5f);
    private static final Color triangleLineColor = new Color(1.0f, 0.64f, 0.0f, 0.5f);
    private static final Color boundingBoxColor = new Color(0.0f, 1.0f, 0.0f, 0.8f);
    private static final Color aabbColor = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    private final ShapeRenderer shapes;
    private boolean drawBones = true;
    private boolean drawRegionAttachments = true;
    private boolean drawBoundingBoxes = true;
    private boolean drawMeshHull = true;
    private boolean drawMeshTriangles = true;
    private final SkeletonBounds bounds = new SkeletonBounds();
    private float scale = 1.0f;
    private float boneWidth = 2.0f;
    private boolean premultipliedAlpha;

    public SkeletonRendererDebug() {
        this.shapes = new ShapeRenderer();
    }

    public SkeletonRendererDebug(ShapeRenderer shapes) {
        this.shapes = shapes;
    }

    public void draw(Skeleton skeleton) {
        int i;
        Bone bone;
        float skeletonX = skeleton.getX();
        float skeletonY = skeleton.getY();
        Gdx.gl.glEnable(3042);
        int srcFunc = this.premultipliedAlpha ? 1 : 770;
        Gdx.gl.glBlendFunc(srcFunc, 771);
        ShapeRenderer shapes = this.shapes;
        Array<Bone> bones = skeleton.getBones();
        if (this.drawBones) {
            shapes.setColor(boneLineColor);
            shapes.begin(ShapeRenderer.ShapeType.Filled);
            int i2 = 0;
            int n = bones.size;
            while (i2 < n) {
                bone = bones.get(i2);
                if (bone.parent != null) {
                    float x = skeletonX + bone.data.length * bone.m00 + bone.worldX;
                    float y = skeletonY + bone.data.length * bone.m10 + bone.worldY;
                    shapes.rectLine(skeletonX + bone.worldX, skeletonY + bone.worldY, x, y, this.boneWidth * this.scale);
                }
                ++i2;
            }
            shapes.end();
            shapes.begin(ShapeRenderer.ShapeType.Line);
            shapes.x(skeletonX, skeletonY, 4.0f * this.scale);
        } else {
            shapes.begin(ShapeRenderer.ShapeType.Line);
        }
        if (this.drawRegionAttachments) {
            shapes.setColor(attachmentLineColor);
            Array<Slot> slots = skeleton.getSlots();
            i = 0;
            int n = slots.size;
            while (i < n) {
                Slot slot = slots.get(i);
                Attachment attachment = slot.attachment;
                if (attachment instanceof RegionAttachment) {
                    RegionAttachment regionAttachment = (RegionAttachment)attachment;
                    regionAttachment.updateWorldVertices(slot, false);
                    float[] vertices = regionAttachment.getWorldVertices();
                    shapes.line(vertices[0], vertices[1], vertices[5], vertices[6]);
                    shapes.line(vertices[5], vertices[6], vertices[10], vertices[11]);
                    shapes.line(vertices[10], vertices[11], vertices[15], vertices[16]);
                    shapes.line(vertices[15], vertices[16], vertices[0], vertices[1]);
                }
                ++i;
            }
        }
        if (this.drawMeshHull || this.drawMeshTriangles) {
            Array<Slot> slots = skeleton.getSlots();
            i = 0;
            int n = slots.size;
            while (i < n) {
                Slot slot = slots.get(i);
                Attachment attachment = slot.attachment;
                float[] vertices = null;
                short[] triangles = null;
                int hullLength = 0;
                if (attachment instanceof MeshAttachment) {
                    MeshAttachment mesh = (MeshAttachment)attachment;
                    mesh.updateWorldVertices(slot, false);
                    vertices = mesh.getWorldVertices();
                    triangles = mesh.getTriangles();
                    hullLength = mesh.getHullLength();
                } else if (attachment instanceof SkinnedMeshAttachment) {
                    SkinnedMeshAttachment mesh = (SkinnedMeshAttachment)attachment;
                    mesh.updateWorldVertices(slot, false);
                    vertices = mesh.getWorldVertices();
                    triangles = mesh.getTriangles();
                    hullLength = mesh.getHullLength();
                }
                if (vertices != null && triangles != null) {
                    if (this.drawMeshTriangles) {
                        shapes.setColor(triangleLineColor);
                        int ii = 0;
                        int nn = triangles.length;
                        while (ii < nn) {
                            int v1 = triangles[ii] * 5;
                            int v2 = triangles[ii + 1] * 5;
                            int v3 = triangles[ii + 2] * 5;
                            shapes.triangle(vertices[v1], vertices[v1 + 1], vertices[v2], vertices[v2 + 1], vertices[v3], vertices[v3 + 1]);
                            ii += 3;
                        }
                    }
                    if (this.drawMeshHull && hullLength > 0) {
                        shapes.setColor(attachmentLineColor);
                        hullLength = hullLength / 2 * 5;
                        float lastX = vertices[hullLength - 5];
                        float lastY = vertices[hullLength - 4];
                        int ii = 0;
                        int nn = hullLength;
                        while (ii < nn) {
                            float x = vertices[ii];
                            float y = vertices[ii + 1];
                            shapes.line(x, y, lastX, lastY);
                            lastX = x;
                            lastY = y;
                            ii += 5;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.drawBoundingBoxes) {
            SkeletonBounds bounds = this.bounds;
            bounds.update(skeleton, true);
            shapes.setColor(aabbColor);
            shapes.rect(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
            shapes.setColor(boundingBoxColor);
            Array<FloatArray> polygons = bounds.getPolygons();
            int i3 = 0;
            int n = polygons.size;
            while (i3 < n) {
                FloatArray polygon = polygons.get(i3);
                shapes.polygon(polygon.items, 0, polygon.size);
                ++i3;
            }
        }
        shapes.end();
        shapes.begin(ShapeRenderer.ShapeType.Filled);
        if (this.drawBones) {
            shapes.setColor(boneOriginColor);
            int i4 = 0;
            int n = bones.size;
            while (i4 < n) {
                bone = bones.get(i4);
                shapes.setColor(Color.GREEN);
                shapes.circle(skeletonX + bone.worldX, skeletonY + bone.worldY, 3.0f * this.scale, 8);
                ++i4;
            }
        }
        shapes.end();
    }

    public ShapeRenderer getShapeRenderer() {
        return this.shapes;
    }

    public void setBones(boolean bones) {
        this.drawBones = bones;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setRegionAttachments(boolean regionAttachments) {
        this.drawRegionAttachments = regionAttachments;
    }

    public void setBoundingBoxes(boolean boundingBoxes) {
        this.drawBoundingBoxes = boundingBoxes;
    }

    public void setMeshHull(boolean meshHull) {
        this.drawMeshHull = meshHull;
    }

    public void setMeshTriangles(boolean meshTriangles) {
        this.drawMeshTriangles = meshTriangles;
    }

    public void setPremultipliedAlpha(boolean premultipliedAlpha) {
        this.premultipliedAlpha = premultipliedAlpha;
    }
}

