/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkinnedMeshAttachment;

public class Skeleton {
    final SkeletonData data;
    final Array<Bone> bones;
    final Array<Slot> slots;
    Array<Slot> drawOrder;
    final Array<IkConstraint> ikConstraints;
    private final Array<Array<Bone>> boneCache = new Array();
    Skin skin;
    final Color color;
    float time;
    boolean flipX;
    boolean flipY;
    float x;
    float y;

    public Skeleton(SkeletonData data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = data;
        this.bones = new Array(data.bones.size);
        for (BoneData boneData : data.bones) {
            Bone parent = boneData.parent == null ? null : this.bones.get(data.bones.indexOf(boneData.parent, true));
            this.bones.add(new Bone(boneData, this, parent));
        }
        this.slots = new Array(data.slots.size);
        this.drawOrder = new Array(data.slots.size);
        for (SlotData slotData : data.slots) {
            Bone bone = this.bones.get(data.bones.indexOf(slotData.boneData, true));
            Slot slot = new Slot(slotData, bone);
            this.slots.add(slot);
            this.drawOrder.add(slot);
        }
        this.ikConstraints = new Array(data.ikConstraints.size);
        for (IkConstraintData ikConstraintData : data.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraintData, this));
        }
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.updateCache();
    }

    public Skeleton(Skeleton skeleton) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = skeleton.data;
        this.bones = new Array(skeleton.bones.size);
        for (Bone bone : skeleton.bones) {
            Bone parent = bone.parent == null ? null : this.bones.get(skeleton.bones.indexOf(bone.parent, true));
            this.bones.add(new Bone(bone, this, parent));
        }
        this.slots = new Array(skeleton.slots.size);
        for (Slot slot : skeleton.slots) {
            Bone bone = this.bones.get(skeleton.bones.indexOf(slot.bone, true));
            this.slots.add(new Slot(slot, bone));
        }
        this.drawOrder = new Array(this.slots.size);
        for (Slot slot : skeleton.drawOrder) {
            this.drawOrder.add(this.slots.get(skeleton.slots.indexOf(slot, true)));
        }
        this.ikConstraints = new Array(skeleton.ikConstraints.size);
        for (IkConstraint ikConstraint : skeleton.ikConstraints) {
            Bone target = this.bones.get(skeleton.bones.indexOf(ikConstraint.target, true));
            Array<Bone> ikBones = new Array<Bone>(ikConstraint.bones.size);
            for (Bone bone : ikConstraint.bones) {
                ikBones.add(this.bones.get(skeleton.bones.indexOf(bone, true)));
            }
            this.ikConstraints.add(new IkConstraint(ikConstraint, ikBones, target));
        }
        this.skin = skeleton.skin;
        this.color = new Color(skeleton.color);
        this.time = skeleton.time;
        this.flipX = skeleton.flipX;
        this.flipY = skeleton.flipY;
        this.updateCache();
    }

    public void updateCache() {
        Array<Bone> bones = this.bones;
        Array<Array<Bone>> boneCache = this.boneCache;
        Array<IkConstraint> ikConstraints = this.ikConstraints;
        int ikConstraintsCount = ikConstraints.size;
        int arrayCount = ikConstraintsCount + 1;
        while (boneCache.size < arrayCount) {
            boneCache.add(new Array());
        }
        int i = 0;
        while (i < arrayCount) {
            boneCache.get(i).clear();
            ++i;
        }
        Array<Bone> nonIkBones = boneCache.first();
        int i2 = 0;
        int n = bones.size;
        while (i2 < n) {
            block7: {
                Bone bone;
                Bone current = bone = bones.get(i2);
                do {
                    int ii = 0;
                    while (ii < ikConstraintsCount) {
                        IkConstraint ikConstraint = ikConstraints.get(ii);
                        Bone parent = ikConstraint.bones.first();
                        Bone child = ikConstraint.bones.peek();
                        while (true) {
                            if (current == child) {
                                boneCache.get(ii).add(bone);
                                boneCache.get(ii + 1).add(bone);
                                break block7;
                            }
                            if (child == parent) break;
                            child = child.parent;
                        }
                        ++ii;
                    }
                } while ((current = current.parent) != null);
                nonIkBones.add(bone);
            }
            ++i2;
        }
    }

    public void updateWorldTransform() {
        Array<Bone> bones = this.bones;
        int i = 0;
        int nn = bones.size;
        while (i < nn) {
            Bone bone = bones.get(i);
            bone.rotationIK = bone.rotation;
            ++i;
        }
        Array<Array<Bone>> boneCache = this.boneCache;
        Array<IkConstraint> ikConstraints = this.ikConstraints;
        int i2 = 0;
        int last = ikConstraints.size;
        while (true) {
            Array<Bone> updateBones = boneCache.get(i2);
            int ii = 0;
            int nn2 = updateBones.size;
            while (ii < nn2) {
                updateBones.get(ii).updateWorldTransform();
                ++ii;
            }
            if (i2 == last) break;
            ikConstraints.get(i2).apply();
            ++i2;
        }
    }

    public void setToSetupPose() {
        this.setBonesToSetupPose();
        this.setSlotsToSetupPose();
    }

    public void setBonesToSetupPose() {
        Array<Bone> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            bones.get(i).setToSetupPose();
            ++i;
        }
        Array<IkConstraint> ikConstraints = this.ikConstraints;
        int i2 = 0;
        int n2 = ikConstraints.size;
        while (i2 < n2) {
            IkConstraint ikConstraint = ikConstraints.get(i2);
            ikConstraint.bendDirection = ikConstraint.data.bendDirection;
            ikConstraint.mix = ikConstraint.data.mix;
            ++i2;
        }
    }

    public void setSlotsToSetupPose() {
        Array<Slot> slots = this.slots;
        System.arraycopy(slots.items, 0, this.drawOrder.items, 0, slots.size);
        int i = 0;
        int n = slots.size;
        while (i < n) {
            slots.get(i).setToSetupPose(i);
            ++i;
        }
    }

    public SkeletonData getData() {
        return this.data;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone getRootBone() {
        if (this.bones.size == 0) {
            return null;
        }
        return this.bones.first();
    }

    public Bone findBone(String boneName) {
        if (boneName == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<Bone> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            Bone bone = bones.get(i);
            if (bone.data.name.equals(boneName)) {
                return bone;
            }
            ++i;
        }
        return null;
    }

    public int findBoneIndex(String boneName) {
        if (boneName == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<Bone> bones = this.bones;
        int i = 0;
        int n = bones.size;
        while (i < n) {
            if (bones.get((int)i).data.name.equals(boneName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Array<Slot> getSlots() {
        return this.slots;
    }

    public Slot findSlot(String slotName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            Slot slot = slots.get(i);
            if (slot.data.name.equals(slotName)) {
                return slot;
            }
            ++i;
        }
        return null;
    }

    public int findSlotIndex(String slotName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            if (slots.get((int)i).data.name.equals(slotName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Array<Slot> getDrawOrder() {
        return this.drawOrder;
    }

    public void setDrawOrder(Array<Slot> drawOrder) {
        this.drawOrder = drawOrder;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(String skinName) {
        Skin skin = this.data.findSkin(skinName);
        if (skin == null) {
            throw new IllegalArgumentException("Skin not found: " + skinName);
        }
        this.setSkin(skin);
    }

    public void setSkin(Skin newSkin) {
        if (newSkin != null) {
            if (this.skin != null) {
                newSkin.attachAll(this, this.skin);
            } else {
                Array<Slot> slots = this.slots;
                int i = 0;
                int n = slots.size;
                while (i < n) {
                    Attachment attachment;
                    Slot slot = slots.get(i);
                    String name = slot.data.attachmentName;
                    if (name != null && (attachment = newSkin.getAttachment(i, name)) != null) {
                        slot.setAttachment(attachment);
                    }
                    ++i;
                }
            }
        }
        this.skin = newSkin;
    }

    public Attachment getAttachment(String slotName, String attachmentName) {
        return this.getAttachment(this.data.findSlotIndex(slotName), attachmentName);
    }

    public Attachment getAttachment(int slotIndex, String attachmentName) {
        Attachment attachment;
        if (attachmentName == null) {
            throw new IllegalArgumentException("attachmentName cannot be null.");
        }
        if (this.skin != null && (attachment = this.skin.getAttachment(slotIndex, attachmentName)) != null) {
            return attachment;
        }
        if (this.data.defaultSkin != null) {
            return this.data.defaultSkin.getAttachment(slotIndex, attachmentName);
        }
        return null;
    }

    public void setAttachment(String slotName, String attachmentName) {
        if (slotName == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> slots = this.slots;
        int i = 0;
        int n = slots.size;
        while (i < n) {
            Slot slot = slots.get(i);
            if (slot.data.name.equals(slotName)) {
                Attachment attachment = null;
                if (attachmentName != null && (attachment = this.getAttachment(i, attachmentName)) == null) {
                    throw new IllegalArgumentException("Attachment not found: " + attachmentName + ", for slot: " + slotName);
                }
                slot.setAttachment(attachment);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Slot not found: " + slotName);
    }

    public Array<IkConstraint> getIkConstraints() {
        return this.ikConstraints;
    }

    public IkConstraint findIkConstraint(String ikConstraintName) {
        if (ikConstraintName == null) {
            throw new IllegalArgumentException("ikConstraintName cannot be null.");
        }
        Array<IkConstraint> ikConstraints = this.ikConstraints;
        int i = 0;
        int n = ikConstraints.size;
        while (i < n) {
            IkConstraint ikConstraint = ikConstraints.get(i);
            if (ikConstraint.data.name.equals(ikConstraintName)) {
                return ikConstraint;
            }
            ++i;
        }
        return null;
    }

    public void getBounds(Vector2 offset, Vector2 size) {
        Array<Slot> drawOrder = this.drawOrder;
        float minX = 2.1474836E9f;
        float minY = 2.1474836E9f;
        float maxX = -2.1474836E9f;
        float maxY = -2.1474836E9f;
        int i = 0;
        int n = drawOrder.size;
        while (i < n) {
            Slot slot = drawOrder.get(i);
            float[] vertices = null;
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                RegionAttachment region = (RegionAttachment)attachment;
                region.updateWorldVertices(slot, false);
                vertices = region.getWorldVertices();
            } else if (attachment instanceof MeshAttachment) {
                MeshAttachment mesh = (MeshAttachment)attachment;
                mesh.updateWorldVertices(slot, true);
                vertices = mesh.getWorldVertices();
            } else if (attachment instanceof SkinnedMeshAttachment) {
                SkinnedMeshAttachment mesh = (SkinnedMeshAttachment)attachment;
                mesh.updateWorldVertices(slot, true);
                vertices = mesh.getWorldVertices();
            }
            if (vertices != null) {
                int ii = 0;
                int nn = vertices.length;
                while (ii < nn) {
                    float x = vertices[ii];
                    float y = vertices[ii + 1];
                    minX = Math.min(minX, x);
                    minY = Math.min(minY, y);
                    maxX = Math.max(maxX, x);
                    maxY = Math.max(maxY, y);
                    ii += 5;
                }
            }
            ++i;
        }
        offset.set(minX, minY);
        size.set(maxX - minX, maxY - minY);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public boolean getFlipX() {
        return this.flipX;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public void setFlip(boolean flipX, boolean flipY) {
        this.flipX = flipX;
        this.flipY = flipY;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void update(float delta) {
        this.time += delta;
    }

    public String toString() {
        return this.data.name != null ? this.data.name : super.toString();
    }
}

