/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class Animation {
    final String name;
    private final Array<Timeline> timelines;
    private float duration;

    public Animation(String name, Array<Timeline> timelines, float duration) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (timelines == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.name = name;
        this.timelines = timelines;
        this.duration = duration;
    }

    public Array<Timeline> getTimelines() {
        return this.timelines;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void apply(Skeleton skeleton, float lastTime, float time, boolean loop, Array<Event> events) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (loop && this.duration != 0.0f) {
            time %= this.duration;
            lastTime %= this.duration;
        }
        Array<Timeline> timelines = this.timelines;
        int i = 0;
        int n = timelines.size;
        while (i < n) {
            timelines.get(i).apply(skeleton, lastTime, time, events, 1.0f);
            ++i;
        }
    }

    public void mix(Skeleton skeleton, float lastTime, float time, boolean loop, Array<Event> events, float alpha) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (loop && this.duration != 0.0f) {
            time %= this.duration;
            lastTime %= this.duration;
        }
        Array<Timeline> timelines = this.timelines;
        int i = 0;
        int n = timelines.size;
        while (i < n) {
            timelines.get(i).apply(skeleton, lastTime, time, events, alpha);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static int binarySearch(float[] values, float target, int step) {
        int low = 0;
        int high = values.length / step - 2;
        if (high == 0) {
            return step;
        }
        int current = high >>> 1;
        while (true) {
            if (values[(current + 1) * step] <= target) {
                low = current + 1;
            } else {
                high = current;
            }
            if (low == high) {
                return (low + 1) * step;
            }
            current = low + high >>> 1;
        }
    }

    static int binarySearch(float[] values, float target) {
        int low = 0;
        int high = values.length - 2;
        if (high == 0) {
            return 1;
        }
        int current = high >>> 1;
        while (true) {
            if (values[current + 1] <= target) {
                low = current + 1;
            } else {
                high = current;
            }
            if (low == high) {
                return low + 1;
            }
            current = low + high >>> 1;
        }
    }

    static int linearSearch(float[] values, float target, int step) {
        int i = 0;
        int last = values.length - step;
        while (i <= last) {
            if (values[i] > target) {
                return i;
            }
            i += step;
        }
        return -1;
    }

    public static class AttachmentTimeline
    implements Timeline {
        int slotIndex;
        final float[] frames;
        final String[] attachmentNames;

        public AttachmentTimeline(int frameCount) {
            this.frames = new float[frameCount];
            this.attachmentNames = new String[frameCount];
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setSlotIndex(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public String[] getAttachmentNames() {
            return this.attachmentNames;
        }

        public void setFrame(int frameIndex, float time, String attachmentName) {
            this.frames[frameIndex] = time;
            this.attachmentNames[frameIndex] = attachmentName;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> events, float alpha) {
            String attachmentName;
            int frameIndex;
            float[] frames = this.frames;
            if (time < frames[0]) {
                if (lastTime > time) {
                    this.apply(skeleton, lastTime, 2.1474836E9f, null, 0.0f);
                }
                return;
            }
            if (lastTime > time) {
                lastTime = -1.0f;
            }
            if (frames[frameIndex = (time >= frames[frames.length - 1] ? frames.length : Animation.binarySearch(frames, time)) - 1] < lastTime) {
                return;
            }
            skeleton.slots.get(this.slotIndex).setAttachment((attachmentName = this.attachmentNames[frameIndex]) == null ? null : skeleton.getAttachment(this.slotIndex, attachmentName));
        }
    }

    public static class ColorTimeline
    extends CurveTimeline {
        private static final int PREV_FRAME_TIME = -5;
        private static final int FRAME_R = 1;
        private static final int FRAME_G = 2;
        private static final int FRAME_B = 3;
        private static final int FRAME_A = 4;
        int slotIndex;
        private final float[] frames;

        public ColorTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount * 5];
        }

        public void setSlotIndex(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, float r, float g, float b, float a) {
            this.frames[frameIndex *= 5] = time;
            this.frames[frameIndex + 1] = r;
            this.frames[frameIndex + 2] = g;
            this.frames[frameIndex + 3] = b;
            this.frames[frameIndex + 4] = a;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> events, float alpha) {
            float a;
            float b;
            float g;
            float r;
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            if (time >= frames[frames.length - 5]) {
                int i = frames.length - 1;
                r = frames[i - 3];
                g = frames[i - 2];
                b = frames[i - 1];
                a = frames[i];
            } else {
                int frameIndex = Animation.binarySearch(frames, time, 5);
                float prevFrameR = frames[frameIndex - 4];
                float prevFrameG = frames[frameIndex - 3];
                float prevFrameB = frames[frameIndex - 2];
                float prevFrameA = frames[frameIndex - 1];
                float frameTime = frames[frameIndex];
                float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -5] - frameTime), 0.0f, 1.0f);
                percent = this.getCurvePercent(frameIndex / 5 - 1, percent);
                r = prevFrameR + (frames[frameIndex + 1] - prevFrameR) * percent;
                g = prevFrameG + (frames[frameIndex + 2] - prevFrameG) * percent;
                b = prevFrameB + (frames[frameIndex + 3] - prevFrameB) * percent;
                a = prevFrameA + (frames[frameIndex + 4] - prevFrameA) * percent;
            }
            Color color = skeleton.slots.get((int)this.slotIndex).color;
            if (alpha < 1.0f) {
                color.add((r - color.r) * alpha, (g - color.g) * alpha, (b - color.b) * alpha, (a - color.a) * alpha);
            } else {
                color.set(r, g, b, a);
            }
        }
    }

    public static abstract class CurveTimeline
    implements Timeline {
        public static final float LINEAR = 0.0f;
        public static final float STEPPED = 1.0f;
        public static final float BEZIER = 2.0f;
        private static final int BEZIER_SEGMENTS = 10;
        private static final int BEZIER_SIZE = 19;
        private final float[] curves;

        public CurveTimeline(int frameCount) {
            if (frameCount <= 0) {
                throw new IllegalArgumentException("frameCount must be > 0: " + frameCount);
            }
            this.curves = new float[(frameCount - 1) * 19];
        }

        public int getFrameCount() {
            return this.curves.length / 19 + 1;
        }

        public void setLinear(int frameIndex) {
            this.curves[frameIndex * 19] = 0.0f;
        }

        public void setStepped(int frameIndex) {
            this.curves[frameIndex * 19] = 1.0f;
        }

        public float getCurveType(int frameIndex) {
            int index = frameIndex * 19;
            if (index == this.curves.length) {
                return 0.0f;
            }
            float type = this.curves[index];
            if (type == 0.0f) {
                return 0.0f;
            }
            if (type == 1.0f) {
                return 1.0f;
            }
            return 2.0f;
        }

        public void setCurve(int frameIndex, float cx1, float cy1, float cx2, float cy2) {
            float subdiv1 = 0.1f;
            float subdiv2 = subdiv1 * subdiv1;
            float subdiv3 = subdiv2 * subdiv1;
            float pre1 = 3.0f * subdiv1;
            float pre2 = 3.0f * subdiv2;
            float pre4 = 6.0f * subdiv2;
            float pre5 = 6.0f * subdiv3;
            float tmp1x = -cx1 * 2.0f + cx2;
            float tmp1y = -cy1 * 2.0f + cy2;
            float tmp2x = (cx1 - cx2) * 3.0f + 1.0f;
            float tmp2y = (cy1 - cy2) * 3.0f + 1.0f;
            float dfx = cx1 * pre1 + tmp1x * pre2 + tmp2x * subdiv3;
            float dfy = cy1 * pre1 + tmp1y * pre2 + tmp2y * subdiv3;
            float ddfx = tmp1x * pre4 + tmp2x * pre5;
            float ddfy = tmp1y * pre4 + tmp2y * pre5;
            float dddfx = tmp2x * pre5;
            float dddfy = tmp2y * pre5;
            int i = frameIndex * 19;
            float[] curves = this.curves;
            curves[i++] = 2.0f;
            float x = dfx;
            float y = dfy;
            int n = i + 19 - 1;
            while (i < n) {
                curves[i] = x;
                curves[i + 1] = y;
                x += (dfx += (ddfx += dddfx));
                y += (dfy += (ddfy += dddfy));
                i += 2;
            }
        }

        public float getCurvePercent(int frameIndex, float percent) {
            float[] curves = this.curves;
            int i = frameIndex * 19;
            float type = curves[i];
            if (type == 0.0f) {
                return percent;
            }
            if (type == 1.0f) {
                return 0.0f;
            }
            float x = 0.0f;
            int start = ++i;
            int n = i + 19 - 1;
            while (i < n) {
                x = curves[i];
                if (x >= percent) {
                    float prevY;
                    float prevX;
                    if (i == start) {
                        prevX = 0.0f;
                        prevY = 0.0f;
                    } else {
                        prevX = curves[i - 2];
                        prevY = curves[i - 1];
                    }
                    return prevY + (curves[i + 1] - prevY) * (percent - prevX) / (x - prevX);
                }
                i += 2;
            }
            float y = curves[i - 1];
            return y + (1.0f - y) * (percent - x) / (1.0f - x);
        }
    }

    public static class DrawOrderTimeline
    implements Timeline {
        private final float[] frames;
        private final int[][] drawOrders;

        public DrawOrderTimeline(int frameCount) {
            this.frames = new float[frameCount];
            this.drawOrders = new int[frameCount][];
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public int[][] getDrawOrders() {
            return this.drawOrders;
        }

        public void setFrame(int frameIndex, float time, int[] drawOrder) {
            this.frames[frameIndex] = time;
            this.drawOrders[frameIndex] = drawOrder;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> firedEvents, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            int frameIndex = time >= frames[frames.length - 1] ? frames.length - 1 : Animation.binarySearch(frames, time) - 1;
            Array<Slot> drawOrder = skeleton.drawOrder;
            Array<Slot> slots = skeleton.slots;
            int[] drawOrderToSetupIndex = this.drawOrders[frameIndex];
            if (drawOrderToSetupIndex == null) {
                System.arraycopy(slots.items, 0, drawOrder.items, 0, slots.size);
            } else {
                int i = 0;
                int n = drawOrderToSetupIndex.length;
                while (i < n) {
                    drawOrder.set(i, slots.get(drawOrderToSetupIndex[i]));
                    ++i;
                }
            }
        }
    }

    public static class EventTimeline
    implements Timeline {
        private final float[] frames;
        private final Event[] events;

        public EventTimeline(int frameCount) {
            this.frames = new float[frameCount];
            this.events = new Event[frameCount];
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public Event[] getEvents() {
            return this.events;
        }

        public void setFrame(int frameIndex, float time, Event event) {
            this.frames[frameIndex] = time;
            this.events[frameIndex] = event;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> firedEvents, float alpha) {
            int frameIndex;
            if (firedEvents == null) {
                return;
            }
            float[] frames = this.frames;
            int frameCount = frames.length;
            if (lastTime > time) {
                this.apply(skeleton, lastTime, 2.1474836E9f, firedEvents, alpha);
                lastTime = -1.0f;
            } else if (lastTime >= frames[frameCount - 1]) {
                return;
            }
            if (time < frames[0]) {
                return;
            }
            if (lastTime < frames[0]) {
                frameIndex = 0;
            } else {
                frameIndex = Animation.binarySearch(frames, lastTime);
                float frame = frames[frameIndex];
                while (frameIndex > 0) {
                    if (frames[frameIndex - 1] != frame) break;
                    --frameIndex;
                }
            }
            while (frameIndex < frameCount && time >= frames[frameIndex]) {
                firedEvents.add(this.events[frameIndex]);
                ++frameIndex;
            }
        }
    }

    public static class FfdTimeline
    extends CurveTimeline {
        private final float[] frames;
        private final float[][] frameVertices;
        int slotIndex;
        Attachment attachment;

        public FfdTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount];
            this.frameVertices = new float[frameCount][];
        }

        public void setSlotIndex(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setAttachment(Attachment attachment) {
            this.attachment = attachment;
        }

        public Attachment getAttachment() {
            return this.attachment;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public float[][] getVertices() {
            return this.frameVertices;
        }

        public void setFrame(int frameIndex, float time, float[] vertices) {
            this.frames[frameIndex] = time;
            this.frameVertices[frameIndex] = vertices;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> firedEvents, float alpha) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (slot.getAttachment() != this.attachment) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            float[][] frameVertices = this.frameVertices;
            int vertexCount = frameVertices[0].length;
            FloatArray verticesArray = slot.getAttachmentVertices();
            if (verticesArray.size != vertexCount) {
                alpha = 1.0f;
            }
            verticesArray.size = 0;
            verticesArray.ensureCapacity(vertexCount);
            verticesArray.size = vertexCount;
            float[] vertices = verticesArray.items;
            if (time >= frames[frames.length - 1]) {
                float[] lastVertices = frameVertices[frames.length - 1];
                if (alpha < 1.0f) {
                    int i = 0;
                    while (i < vertexCount) {
                        int n = i;
                        vertices[n] = vertices[n] + (lastVertices[i] - vertices[i]) * alpha;
                        ++i;
                    }
                } else {
                    System.arraycopy(lastVertices, 0, vertices, 0, vertexCount);
                }
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time);
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex - 1] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex - 1, percent);
            float[] prevVertices = frameVertices[frameIndex - 1];
            float[] nextVertices = frameVertices[frameIndex];
            if (alpha < 1.0f) {
                int i = 0;
                while (i < vertexCount) {
                    float prev = prevVertices[i];
                    int n = i;
                    vertices[n] = vertices[n] + (prev + (nextVertices[i] - prev) * percent - vertices[i]) * alpha;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < vertexCount) {
                    float prev = prevVertices[i];
                    vertices[i] = prev + (nextVertices[i] - prev) * percent;
                    ++i;
                }
            }
        }
    }

    public static class FlipXTimeline
    implements Timeline {
        int boneIndex;
        final float[] frames;

        public FlipXTimeline(int frameCount) {
            this.frames = new float[frameCount << 1];
        }

        public void setBoneIndex(int boneIndex) {
            this.boneIndex = boneIndex;
        }

        public int getBoneIndex() {
            return this.boneIndex;
        }

        public int getFrameCount() {
            return this.frames.length >> 1;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, boolean flip) {
            this.frames[frameIndex *= 2] = time;
            this.frames[frameIndex + 1] = flip ? 1 : 0;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> events, float alpha) {
            int frameIndex;
            float[] frames = this.frames;
            if (time < frames[0]) {
                if (lastTime > time) {
                    this.apply(skeleton, lastTime, 2.1474836E9f, null, 0.0f);
                }
                return;
            }
            if (lastTime > time) {
                lastTime = -1.0f;
            }
            if (frames[frameIndex = (time >= frames[frames.length - 2] ? frames.length : Animation.binarySearch(frames, time, 2)) - 2] < lastTime) {
                return;
            }
            this.setFlip(skeleton.bones.get(this.boneIndex), frames[frameIndex + 1] != 0.0f);
        }

        protected void setFlip(Bone bone, boolean flip) {
            bone.setFlipX(flip);
        }
    }

    public static class FlipYTimeline
    extends FlipXTimeline {
        public FlipYTimeline(int frameCount) {
            super(frameCount);
        }

        @Override
        protected void setFlip(Bone bone, boolean flip) {
            bone.setFlipY(flip);
        }
    }

    public static class IkConstraintTimeline
    extends CurveTimeline {
        private static final int PREV_FRAME_TIME = -3;
        private static final int PREV_FRAME_MIX = -2;
        private static final int PREV_FRAME_BEND_DIRECTION = -1;
        private static final int FRAME_MIX = 1;
        int ikConstraintIndex;
        private final float[] frames;

        public IkConstraintTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount * 3];
        }

        public void setIkConstraintIndex(int ikConstraint) {
            this.ikConstraintIndex = ikConstraint;
        }

        public int getIkConstraintIndex() {
            return this.ikConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, float mix, int bendDirection) {
            this.frames[frameIndex *= 3] = time;
            this.frames[frameIndex + 1] = mix;
            this.frames[frameIndex + 2] = bendDirection;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> events, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            IkConstraint ikConstraint = skeleton.ikConstraints.get(this.ikConstraintIndex);
            if (time >= frames[frames.length - 3]) {
                ikConstraint.mix += (frames[frames.length - 2] - ikConstraint.mix) * alpha;
                ikConstraint.bendDirection = (int)frames[frames.length - 1];
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 3);
            float prevFrameMix = frames[frameIndex + -2];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -3] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex / 3 - 1, percent);
            float mix = prevFrameMix + (frames[frameIndex + 1] - prevFrameMix) * percent;
            ikConstraint.mix += (mix - ikConstraint.mix) * alpha;
            ikConstraint.bendDirection = (int)frames[frameIndex + -1];
        }
    }

    public static class RotateTimeline
    extends CurveTimeline {
        private static final int PREV_FRAME_TIME = -2;
        private static final int FRAME_VALUE = 1;
        int boneIndex;
        private final float[] frames;

        public RotateTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount << 1];
        }

        public void setBoneIndex(int boneIndex) {
            this.boneIndex = boneIndex;
        }

        public int getBoneIndex() {
            return this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, float angle) {
            this.frames[frameIndex *= 2] = time;
            this.frames[frameIndex + 1] = angle;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> events, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (time >= frames[frames.length - 2]) {
                float amount = bone.data.rotation + frames[frames.length - 1] - bone.rotation;
                while (amount > 180.0f) {
                    amount -= 360.0f;
                }
                while (amount < -180.0f) {
                    amount += 360.0f;
                }
                bone.rotation += amount * alpha;
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 2);
            float prevFrameValue = frames[frameIndex - 1];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -2] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent((frameIndex >> 1) - 1, percent);
            float amount = frames[frameIndex + 1] - prevFrameValue;
            while (amount > 180.0f) {
                amount -= 360.0f;
            }
            while (amount < -180.0f) {
                amount += 360.0f;
            }
            amount = bone.data.rotation + (prevFrameValue + amount * percent) - bone.rotation;
            while (amount > 180.0f) {
                amount -= 360.0f;
            }
            while (amount < -180.0f) {
                amount += 360.0f;
            }
            bone.rotation += amount * alpha;
        }
    }

    public static class ScaleTimeline
    extends TranslateTimeline {
        public ScaleTimeline(int frameCount) {
            super(frameCount);
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> events, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (time >= frames[frames.length - 3]) {
                bone.scaleX += (bone.data.scaleX * frames[frames.length - 2] - bone.scaleX) * alpha;
                bone.scaleY += (bone.data.scaleY * frames[frames.length - 1] - bone.scaleY) * alpha;
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 3);
            float prevFrameX = frames[frameIndex - 2];
            float prevFrameY = frames[frameIndex - 1];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -3] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex / 3 - 1, percent);
            bone.scaleX += (bone.data.scaleX * (prevFrameX + (frames[frameIndex + 1] - prevFrameX) * percent) - bone.scaleX) * alpha;
            bone.scaleY += (bone.data.scaleY * (prevFrameY + (frames[frameIndex + 2] - prevFrameY) * percent) - bone.scaleY) * alpha;
        }
    }

    public static interface Timeline {
        public void apply(Skeleton var1, float var2, float var3, Array<Event> var4, float var5);
    }

    public static class TranslateTimeline
    extends CurveTimeline {
        static final int PREV_FRAME_TIME = -3;
        static final int FRAME_X = 1;
        static final int FRAME_Y = 2;
        int boneIndex;
        final float[] frames;

        public TranslateTimeline(int frameCount) {
            super(frameCount);
            this.frames = new float[frameCount * 3];
        }

        public void setBoneIndex(int boneIndex) {
            this.boneIndex = boneIndex;
        }

        public int getBoneIndex() {
            return this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int frameIndex, float time, float x, float y) {
            this.frames[frameIndex *= 3] = time;
            this.frames[frameIndex + 1] = x;
            this.frames[frameIndex + 2] = y;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, Array<Event> events, float alpha) {
            float[] frames = this.frames;
            if (time < frames[0]) {
                return;
            }
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (time >= frames[frames.length - 3]) {
                bone.x += (bone.data.x + frames[frames.length - 2] - bone.x) * alpha;
                bone.y += (bone.data.y + frames[frames.length - 1] - bone.y) * alpha;
                return;
            }
            int frameIndex = Animation.binarySearch(frames, time, 3);
            float prevFrameX = frames[frameIndex - 2];
            float prevFrameY = frames[frameIndex - 1];
            float frameTime = frames[frameIndex];
            float percent = MathUtils.clamp(1.0f - (time - frameTime) / (frames[frameIndex + -3] - frameTime), 0.0f, 1.0f);
            percent = this.getCurvePercent(frameIndex / 3 - 1, percent);
            bone.x += (bone.data.x + prevFrameX + (frames[frameIndex + 1] - prevFrameX) * percent - bone.x) * alpha;
            bone.y += (bone.data.y + prevFrameY + (frames[frameIndex + 2] - prevFrameY) * percent - bone.y) * alpha;
        }
    }
}

