/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class XmlReader {
    private final Array<Element> elements = new Array(8);
    private Element root;
    private Element current;
    private final StringBuilder textBuffer = new StringBuilder(64);
    private String entitiesText;
    private static final byte[] _xml_actions = XmlReader.init__xml_actions_0();
    private static final byte[] _xml_key_offsets = XmlReader.init__xml_key_offsets_0();
    private static final char[] _xml_trans_keys = XmlReader.init__xml_trans_keys_0();
    private static final byte[] _xml_single_lengths = XmlReader.init__xml_single_lengths_0();
    private static final byte[] _xml_range_lengths = XmlReader.init__xml_range_lengths_0();
    private static final short[] _xml_index_offsets = XmlReader.init__xml_index_offsets_0();
    private static final byte[] _xml_indicies = XmlReader.init__xml_indicies_0();
    private static final byte[] _xml_trans_targs = XmlReader.init__xml_trans_targs_0();
    private static final byte[] _xml_trans_actions = XmlReader.init__xml_trans_actions_0();
    static final int xml_start = 1;
    static final int xml_first_final = 34;
    static final int xml_error = 0;
    static final int xml_en_elementBody = 15;
    static final int xml_en_main = 1;

    public Element parse(String xml) {
        char[] data = xml.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public Element parse(Reader reader) {
        try {
            int length;
            char[] data = new char[1024];
            int offset = 0;
            while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                if (length == 0) {
                    char[] newData = new char[data.length * 2];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                    continue;
                }
                offset += length;
            }
            Element element = this.parse(data, 0, offset);
            return element;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
    }

    public Element parse(InputStream input) {
        try {
            Element element = this.parse(new InputStreamReader(input, "UTF-8"));
            return element;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(input);
        }
    }

    public Element parse(FileHandle file) {
        try {
            return this.parse(file.reader("UTF-8"));
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Element parse(char[] data, int offset, int length) {
        p = offset;
        pe = length;
        s = 0;
        attributeName = null;
        hasBody = false;
        cs = 1;
        _trans = 0;
        _goto_targ = 0;
        block19: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block19;
                    }
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block19;
                    }
                }
                case 1: {
                    _keys = XmlReader._xml_key_offsets[cs];
                    _trans = XmlReader._xml_index_offsets[cs];
                    _klen = XmlReader._xml_single_lengths[cs];
                    if (_klen <= 0) ** GOTO lbl37
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (data[p] < XmlReader._xml_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (data[p] > XmlReader._xml_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl51
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl37:
                    // 2 sources

                    if ((_klen = XmlReader._xml_range_lengths[cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (data[p] < XmlReader._xml_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (data[p] > XmlReader._xml_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl51
                        }
                        _trans += _klen;
                    }
lbl51:
                    // 5 sources

                    _trans = XmlReader._xml_indicies[_trans];
                    cs = XmlReader._xml_trans_targs[_trans];
                    if (XmlReader._xml_trans_actions[_trans] == 0) ** GOTO lbl147
                    _acts = XmlReader._xml_trans_actions[_trans];
                    _nacts = XmlReader._xml_actions[_acts++];
                    while (_nacts-- > 0) {
                        switch (XmlReader._xml_actions[_acts++]) {
                            case 0: {
                                s = p;
                                break;
                            }
                            case 1: {
                                c = data[s];
                                if (c != '?' && c != '!') ** GOTO lbl83
                                if (data[s + 1] != '[' || data[s + 2] != 'C' || data[s + 3] != 'D' || data[s + 4] != 'A' || data[s + 5] != 'T' || data[s + 6] != 'A' || data[s + 7] != '[') ** GOTO lbl71
                                p = (s += 8) + 2;
                                while (data[p - 2] != ']' || data[p - 1] != ']' || data[p] != '>') {
                                    ++p;
                                }
                                this.text(new String(data, s, p - s - 2));
                                ** GOTO lbl80
lbl71:
                                // 1 sources

                                if (c != '!' || data[s + 1] != '-' || data[s + 2] != '-') ** GOTO lbl79
                                p = s + 3;
                                while (data[p] != '-' || data[p + 1] != '-' || data[p + 2] != '>') {
                                    ++p;
                                }
                                p += 2;
                                ** GOTO lbl80
lbl-1000:
                                // 1 sources

                                {
                                    ++p;
lbl79:
                                    // 2 sources

                                    ** while (data[p] != '>')
                                }
lbl80:
                                // 3 sources

                                cs = 15;
                                _goto_targ = 2;
                                continue block19;
lbl83:
                                // 1 sources

                                hasBody = true;
                                this.open(new String(data, s, p - s));
                                break;
                            }
                            case 2: {
                                hasBody = false;
                                this.close();
                                cs = 15;
                                _goto_targ = 2;
                                continue block19;
                            }
                            case 3: {
                                this.close();
                                cs = 15;
                                _goto_targ = 2;
                                continue block19;
                            }
                            case 4: {
                                if (!hasBody) break;
                                cs = 15;
                                _goto_targ = 2;
                                continue block19;
                            }
                            case 5: {
                                attributeName = new String(data, s, p - s);
                                break;
                            }
                            case 6: {
                                end = p;
                                block26: while (end != s) {
                                    switch (data[end - 1]) {
                                        case '\t': 
                                        case '\n': 
                                        case '\r': 
                                        case ' ': {
                                            --end;
                                            break;
                                        }
                                        default: {
                                            break block26;
                                        }
                                    }
                                }
                                current = s;
                                entityFound = false;
                                block27: while (current != end) {
                                    if (data[current++] != '&') continue;
                                    entityStart = current;
                                    while (current != end) {
                                        if (data[current++] != ';') continue;
                                        this.textBuffer.append(data, s, entityStart - s - 1);
                                        name = new String(data, entityStart, current - entityStart - 1);
                                        value = this.entity(name);
                                        this.textBuffer.append(value != null ? value : name);
                                        s = current;
                                        entityFound = true;
                                        continue block27;
                                    }
                                }
                                if (entityFound) {
                                    if (s < end) {
                                        this.textBuffer.append(data, s, end - s);
                                    }
                                    this.entitiesText = this.textBuffer.toString();
                                    this.textBuffer.setLength(0);
                                    break;
                                }
                                this.entitiesText = new String(data, s, end - s);
                                break;
                            }
                            case 7: {
                                this.attribute(attributeName, this.entitiesText);
                                break;
                            }
                            case 8: {
                                this.text(this.entitiesText);
                            }
                        }
                    }
                }
lbl147:
                // 3 sources

                case 2: {
                    if (cs == 0) {
                        _goto_targ = 5;
                        continue block19;
                    }
                    if (++p == pe) break block19;
                    _goto_targ = 1;
                    continue block19;
                }
            }
            break;
        }
        this.entitiesText = null;
        if (p < pe) {
            lineNumber = 1;
            i = 0;
            while (i < p) {
                if (data[i] == '\n') {
                    ++lineNumber;
                }
                ++i;
            }
            throw new SerializationException("Error parsing XML on line " + lineNumber + " near: " + new String(data, p, Math.min(32, pe - p)));
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            throw new SerializationException("Error parsing XML, unclosed element: " + element.getName());
        }
        root = this.root;
        this.root = null;
        return root;
    }

    private static byte[] init__xml_actions_0() {
        byte[] byArray = new byte[29];
        byArray[1] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 2;
        byArray[7] = 1;
        byArray[8] = 3;
        byArray[9] = 1;
        byArray[10] = 4;
        byArray[11] = 1;
        byArray[12] = 5;
        byArray[13] = 2;
        byArray[14] = 1;
        byArray[15] = 4;
        byArray[16] = 2;
        byArray[17] = 2;
        byArray[18] = 4;
        byArray[19] = 2;
        byArray[20] = 6;
        byArray[21] = 7;
        byArray[22] = 2;
        byArray[23] = 6;
        byArray[24] = 8;
        byArray[25] = 3;
        byArray[27] = 6;
        byArray[28] = 7;
        return byArray;
    }

    private static byte[] init__xml_key_offsets_0() {
        byte[] byArray = new byte[36];
        byArray[2] = 4;
        byArray[3] = 9;
        byArray[4] = 14;
        byArray[5] = 20;
        byArray[6] = 26;
        byArray[7] = 30;
        byArray[8] = 35;
        byArray[9] = 36;
        byArray[10] = 37;
        byArray[11] = 42;
        byArray[12] = 46;
        byArray[13] = 50;
        byArray[14] = 51;
        byArray[15] = 52;
        byArray[16] = 56;
        byArray[17] = 57;
        byArray[18] = 62;
        byArray[19] = 67;
        byArray[20] = 73;
        byArray[21] = 79;
        byArray[22] = 83;
        byArray[23] = 88;
        byArray[24] = 89;
        byArray[25] = 90;
        byArray[26] = 95;
        byArray[27] = 99;
        byArray[28] = 103;
        byArray[29] = 104;
        byArray[30] = 108;
        byArray[31] = 109;
        byArray[32] = 110;
        byArray[33] = 111;
        byArray[34] = 112;
        byArray[35] = 115;
        return byArray;
    }

    private static char[] init__xml_trans_keys_0() {
        char[] cArray = new char[116];
        cArray[0] = 32;
        cArray[1] = 60;
        cArray[2] = 9;
        cArray[3] = 13;
        cArray[4] = 32;
        cArray[5] = 47;
        cArray[6] = 62;
        cArray[7] = 9;
        cArray[8] = 13;
        cArray[9] = 32;
        cArray[10] = 47;
        cArray[11] = 62;
        cArray[12] = 9;
        cArray[13] = 13;
        cArray[14] = 32;
        cArray[15] = 47;
        cArray[16] = 61;
        cArray[17] = 62;
        cArray[18] = 9;
        cArray[19] = 13;
        cArray[20] = 32;
        cArray[21] = 47;
        cArray[22] = 61;
        cArray[23] = 62;
        cArray[24] = 9;
        cArray[25] = 13;
        cArray[26] = 32;
        cArray[27] = 61;
        cArray[28] = 9;
        cArray[29] = 13;
        cArray[30] = 32;
        cArray[31] = 34;
        cArray[32] = 39;
        cArray[33] = 9;
        cArray[34] = 13;
        cArray[35] = 34;
        cArray[36] = 34;
        cArray[37] = 32;
        cArray[38] = 47;
        cArray[39] = 62;
        cArray[40] = 9;
        cArray[41] = 13;
        cArray[42] = 32;
        cArray[43] = 62;
        cArray[44] = 9;
        cArray[45] = 13;
        cArray[46] = 32;
        cArray[47] = 62;
        cArray[48] = 9;
        cArray[49] = 13;
        cArray[50] = 39;
        cArray[51] = 39;
        cArray[52] = 32;
        cArray[53] = 60;
        cArray[54] = 9;
        cArray[55] = 13;
        cArray[56] = 60;
        cArray[57] = 32;
        cArray[58] = 47;
        cArray[59] = 62;
        cArray[60] = 9;
        cArray[61] = 13;
        cArray[62] = 32;
        cArray[63] = 47;
        cArray[64] = 62;
        cArray[65] = 9;
        cArray[66] = 13;
        cArray[67] = 32;
        cArray[68] = 47;
        cArray[69] = 61;
        cArray[70] = 62;
        cArray[71] = 9;
        cArray[72] = 13;
        cArray[73] = 32;
        cArray[74] = 47;
        cArray[75] = 61;
        cArray[76] = 62;
        cArray[77] = 9;
        cArray[78] = 13;
        cArray[79] = 32;
        cArray[80] = 61;
        cArray[81] = 9;
        cArray[82] = 13;
        cArray[83] = 32;
        cArray[84] = 34;
        cArray[85] = 39;
        cArray[86] = 9;
        cArray[87] = 13;
        cArray[88] = 34;
        cArray[89] = 34;
        cArray[90] = 32;
        cArray[91] = 47;
        cArray[92] = 62;
        cArray[93] = 9;
        cArray[94] = 13;
        cArray[95] = 32;
        cArray[96] = 62;
        cArray[97] = 9;
        cArray[98] = 13;
        cArray[99] = 32;
        cArray[100] = 62;
        cArray[101] = 9;
        cArray[102] = 13;
        cArray[103] = 60;
        cArray[104] = 32;
        cArray[105] = 47;
        cArray[106] = 9;
        cArray[107] = 13;
        cArray[108] = 62;
        cArray[109] = 62;
        cArray[110] = 39;
        cArray[111] = 39;
        cArray[112] = 32;
        cArray[113] = 9;
        cArray[114] = 13;
        return cArray;
    }

    private static byte[] init__xml_single_lengths_0() {
        byte[] byArray = new byte[36];
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 4;
        byArray[6] = 2;
        byArray[7] = 3;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 3;
        byArray[11] = 2;
        byArray[12] = 2;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 2;
        byArray[16] = 1;
        byArray[17] = 3;
        byArray[18] = 3;
        byArray[19] = 4;
        byArray[20] = 4;
        byArray[21] = 2;
        byArray[22] = 3;
        byArray[23] = 1;
        byArray[24] = 1;
        byArray[25] = 3;
        byArray[26] = 2;
        byArray[27] = 2;
        byArray[28] = 1;
        byArray[29] = 2;
        byArray[30] = 1;
        byArray[31] = 1;
        byArray[32] = 1;
        byArray[33] = 1;
        byArray[34] = 1;
        return byArray;
    }

    private static byte[] init__xml_range_lengths_0() {
        byte[] byArray = new byte[36];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 1;
        byArray[15] = 1;
        byArray[17] = 1;
        byArray[18] = 1;
        byArray[19] = 1;
        byArray[20] = 1;
        byArray[21] = 1;
        byArray[22] = 1;
        byArray[25] = 1;
        byArray[26] = 1;
        byArray[27] = 1;
        byArray[29] = 1;
        byArray[34] = 1;
        return byArray;
    }

    private static short[] init__xml_index_offsets_0() {
        short[] sArray = new short[36];
        sArray[2] = 4;
        sArray[3] = 9;
        sArray[4] = 14;
        sArray[5] = 20;
        sArray[6] = 26;
        sArray[7] = 30;
        sArray[8] = 35;
        sArray[9] = 37;
        sArray[10] = 39;
        sArray[11] = 44;
        sArray[12] = 48;
        sArray[13] = 52;
        sArray[14] = 54;
        sArray[15] = 56;
        sArray[16] = 60;
        sArray[17] = 62;
        sArray[18] = 67;
        sArray[19] = 72;
        sArray[20] = 78;
        sArray[21] = 84;
        sArray[22] = 88;
        sArray[23] = 93;
        sArray[24] = 95;
        sArray[25] = 97;
        sArray[26] = 102;
        sArray[27] = 106;
        sArray[28] = 110;
        sArray[29] = 112;
        sArray[30] = 116;
        sArray[31] = 118;
        sArray[32] = 120;
        sArray[33] = 122;
        sArray[34] = 124;
        sArray[35] = 127;
        return sArray;
    }

    private static byte[] init__xml_indicies_0() {
        byte[] byArray = new byte[129];
        byArray[1] = 2;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 2;
        byArray[8] = 3;
        byArray[9] = 5;
        byArray[10] = 6;
        byArray[11] = 7;
        byArray[12] = 5;
        byArray[13] = 4;
        byArray[14] = 9;
        byArray[15] = 10;
        byArray[16] = 1;
        byArray[17] = 11;
        byArray[18] = 9;
        byArray[19] = 8;
        byArray[20] = 13;
        byArray[21] = 1;
        byArray[22] = 14;
        byArray[23] = 1;
        byArray[24] = 13;
        byArray[25] = 12;
        byArray[26] = 15;
        byArray[27] = 16;
        byArray[28] = 15;
        byArray[29] = 1;
        byArray[30] = 16;
        byArray[31] = 17;
        byArray[32] = 18;
        byArray[33] = 16;
        byArray[34] = 1;
        byArray[35] = 20;
        byArray[36] = 19;
        byArray[37] = 22;
        byArray[38] = 21;
        byArray[39] = 9;
        byArray[40] = 10;
        byArray[41] = 11;
        byArray[42] = 9;
        byArray[43] = 1;
        byArray[44] = 23;
        byArray[45] = 24;
        byArray[46] = 23;
        byArray[47] = 1;
        byArray[48] = 25;
        byArray[49] = 11;
        byArray[50] = 25;
        byArray[51] = 1;
        byArray[52] = 20;
        byArray[53] = 26;
        byArray[54] = 22;
        byArray[55] = 27;
        byArray[56] = 29;
        byArray[57] = 30;
        byArray[58] = 29;
        byArray[59] = 28;
        byArray[60] = 32;
        byArray[61] = 31;
        byArray[62] = 30;
        byArray[63] = 34;
        byArray[64] = 1;
        byArray[65] = 30;
        byArray[66] = 33;
        byArray[67] = 36;
        byArray[68] = 37;
        byArray[69] = 38;
        byArray[70] = 36;
        byArray[71] = 35;
        byArray[72] = 40;
        byArray[73] = 41;
        byArray[74] = 1;
        byArray[75] = 42;
        byArray[76] = 40;
        byArray[77] = 39;
        byArray[78] = 44;
        byArray[79] = 1;
        byArray[80] = 45;
        byArray[81] = 1;
        byArray[82] = 44;
        byArray[83] = 43;
        byArray[84] = 46;
        byArray[85] = 47;
        byArray[86] = 46;
        byArray[87] = 1;
        byArray[88] = 47;
        byArray[89] = 48;
        byArray[90] = 49;
        byArray[91] = 47;
        byArray[92] = 1;
        byArray[93] = 51;
        byArray[94] = 50;
        byArray[95] = 53;
        byArray[96] = 52;
        byArray[97] = 40;
        byArray[98] = 41;
        byArray[99] = 42;
        byArray[100] = 40;
        byArray[101] = 1;
        byArray[102] = 54;
        byArray[103] = 55;
        byArray[104] = 54;
        byArray[105] = 1;
        byArray[106] = 56;
        byArray[107] = 42;
        byArray[108] = 56;
        byArray[109] = 1;
        byArray[110] = 57;
        byArray[111] = 1;
        byArray[112] = 57;
        byArray[113] = 34;
        byArray[114] = 57;
        byArray[115] = 1;
        byArray[116] = 1;
        byArray[117] = 58;
        byArray[118] = 59;
        byArray[119] = 58;
        byArray[120] = 51;
        byArray[121] = 60;
        byArray[122] = 53;
        byArray[123] = 61;
        byArray[124] = 62;
        byArray[125] = 62;
        byArray[126] = 1;
        byArray[127] = 1;
        return byArray;
    }

    private static byte[] init__xml_trans_targs_0() {
        byte[] byArray = new byte[63];
        byArray[0] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 3;
        byArray[5] = 4;
        byArray[6] = 11;
        byArray[7] = 34;
        byArray[8] = 5;
        byArray[9] = 4;
        byArray[10] = 11;
        byArray[11] = 34;
        byArray[12] = 5;
        byArray[13] = 6;
        byArray[14] = 7;
        byArray[15] = 6;
        byArray[16] = 7;
        byArray[17] = 8;
        byArray[18] = 13;
        byArray[19] = 9;
        byArray[20] = 10;
        byArray[21] = 9;
        byArray[22] = 10;
        byArray[23] = 12;
        byArray[24] = 34;
        byArray[25] = 12;
        byArray[26] = 14;
        byArray[27] = 14;
        byArray[28] = 16;
        byArray[29] = 15;
        byArray[30] = 17;
        byArray[31] = 16;
        byArray[32] = 17;
        byArray[33] = 18;
        byArray[34] = 30;
        byArray[35] = 18;
        byArray[36] = 19;
        byArray[37] = 26;
        byArray[38] = 28;
        byArray[39] = 20;
        byArray[40] = 19;
        byArray[41] = 26;
        byArray[42] = 28;
        byArray[43] = 20;
        byArray[44] = 21;
        byArray[45] = 22;
        byArray[46] = 21;
        byArray[47] = 22;
        byArray[48] = 23;
        byArray[49] = 32;
        byArray[50] = 24;
        byArray[51] = 25;
        byArray[52] = 24;
        byArray[53] = 25;
        byArray[54] = 27;
        byArray[55] = 28;
        byArray[56] = 27;
        byArray[57] = 29;
        byArray[58] = 31;
        byArray[59] = 35;
        byArray[60] = 33;
        byArray[61] = 33;
        byArray[62] = 34;
        return byArray;
    }

    private static byte[] init__xml_trans_actions_0() {
        byte[] byArray = new byte[63];
        byArray[3] = 1;
        byArray[5] = 3;
        byArray[6] = 3;
        byArray[7] = 13;
        byArray[8] = 1;
        byArray[11] = 9;
        byArray[13] = 11;
        byArray[14] = 11;
        byArray[19] = 1;
        byArray[20] = 25;
        byArray[22] = 19;
        byArray[23] = 5;
        byArray[24] = 16;
        byArray[26] = 1;
        byArray[28] = 1;
        byArray[32] = 22;
        byArray[33] = 1;
        byArray[36] = 3;
        byArray[37] = 3;
        byArray[38] = 13;
        byArray[39] = 1;
        byArray[42] = 9;
        byArray[44] = 11;
        byArray[45] = 11;
        byArray[50] = 1;
        byArray[51] = 25;
        byArray[53] = 19;
        byArray[54] = 5;
        byArray[55] = 16;
        byArray[59] = 7;
        byArray[60] = 1;
        return byArray;
    }

    protected void open(String name) {
        Element child = new Element(name, this.current);
        Element parent = this.current;
        if (parent != null) {
            parent.addChild(child);
        }
        this.elements.add(child);
        this.current = child;
    }

    protected void attribute(String name, String value) {
        this.current.setAttribute(name, value);
    }

    @Null
    protected String entity(String name) {
        if (name.equals("lt")) {
            return "<";
        }
        if (name.equals("gt")) {
            return ">";
        }
        if (name.equals("amp")) {
            return "&";
        }
        if (name.equals("apos")) {
            return "'";
        }
        if (name.equals("quot")) {
            return "\"";
        }
        if (name.startsWith("#x")) {
            return Character.toString((char)Integer.parseInt(name.substring(2), 16));
        }
        return null;
    }

    protected void text(String text) {
        String existing = this.current.getText();
        this.current.setText(existing != null ? String.valueOf(existing) + text : text);
    }

    protected void close() {
        this.root = this.elements.pop();
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    public static class Element {
        private final String name;
        private ObjectMap<String, String> attributes;
        private Array<Element> children;
        private String text;
        private Element parent;

        public Element(String name, Element parent) {
            this.name = name;
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public ObjectMap<String, String> getAttributes() {
            return this.attributes;
        }

        public String getAttribute(String name) {
            if (this.attributes == null) {
                throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute: " + name);
            }
            String value = this.attributes.get(name);
            if (value == null) {
                throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute: " + name);
            }
            return value;
        }

        public String getAttribute(String name, String defaultValue) {
            if (this.attributes == null) {
                return defaultValue;
            }
            String value = this.attributes.get(name);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public boolean hasAttribute(String name) {
            if (this.attributes == null) {
                return false;
            }
            return this.attributes.containsKey(name);
        }

        public void setAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new ObjectMap(8);
            }
            this.attributes.put(name, value);
        }

        public int getChildCount() {
            if (this.children == null) {
                return 0;
            }
            return this.children.size;
        }

        public Element getChild(int index) {
            if (this.children == null) {
                throw new GdxRuntimeException("Element has no children: " + this.name);
            }
            return this.children.get(index);
        }

        public void addChild(Element element) {
            if (this.children == null) {
                this.children = new Array(8);
            }
            this.children.add(element);
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void removeChild(int index) {
            if (this.children != null) {
                this.children.removeIndex(index);
            }
        }

        public void removeChild(Element child) {
            if (this.children != null) {
                this.children.removeValue(child, true);
            }
        }

        public void remove() {
            this.parent.removeChild(this);
        }

        public Element getParent() {
            return this.parent;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String indent) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(indent);
            buffer.append('<');
            buffer.append(this.name);
            if (this.attributes != null) {
                for (ObjectMap.Entry entry : this.attributes.entries()) {
                    buffer.append(' ');
                    buffer.append((String)entry.key);
                    buffer.append("=\"");
                    buffer.append((String)entry.value);
                    buffer.append('\"');
                }
            }
            if (this.children == null && (this.text == null || this.text.length() == 0)) {
                buffer.append("/>");
            } else {
                buffer.append(">\n");
                String string = String.valueOf(indent) + '\t';
                if (this.text != null && this.text.length() > 0) {
                    buffer.append(string);
                    buffer.append(this.text);
                    buffer.append('\n');
                }
                if (this.children != null) {
                    for (Element child : this.children) {
                        buffer.append(child.toString(string));
                        buffer.append('\n');
                    }
                }
                buffer.append(indent);
                buffer.append("</");
                buffer.append(this.name);
                buffer.append('>');
            }
            return buffer.toString();
        }

        @Null
        public Element getChildByName(String name) {
            if (this.children == null) {
                return null;
            }
            int i = 0;
            while (i < this.children.size) {
                Element element = this.children.get(i);
                if (element.name.equals(name)) {
                    return element;
                }
                ++i;
            }
            return null;
        }

        public boolean hasChild(String name) {
            if (this.children == null) {
                return false;
            }
            return this.getChildByName(name) != null;
        }

        @Null
        public Element getChildByNameRecursive(String name) {
            if (this.children == null) {
                return null;
            }
            int i = 0;
            while (i < this.children.size) {
                Element element = this.children.get(i);
                if (element.name.equals(name)) {
                    return element;
                }
                Element found = element.getChildByNameRecursive(name);
                if (found != null) {
                    return found;
                }
                ++i;
            }
            return null;
        }

        public boolean hasChildRecursive(String name) {
            if (this.children == null) {
                return false;
            }
            return this.getChildByNameRecursive(name) != null;
        }

        public Array<Element> getChildrenByName(String name) {
            Array<Element> result = new Array<Element>();
            if (this.children == null) {
                return result;
            }
            int i = 0;
            while (i < this.children.size) {
                Element child = this.children.get(i);
                if (child.name.equals(name)) {
                    result.add(child);
                }
                ++i;
            }
            return result;
        }

        public Array<Element> getChildrenByNameRecursively(String name) {
            Array<Element> result = new Array<Element>();
            this.getChildrenByNameRecursively(name, result);
            return result;
        }

        private void getChildrenByNameRecursively(String name, Array<Element> result) {
            if (this.children == null) {
                return;
            }
            int i = 0;
            while (i < this.children.size) {
                Element child = this.children.get(i);
                if (child.name.equals(name)) {
                    result.add(child);
                }
                child.getChildrenByNameRecursively(name, result);
                ++i;
            }
        }

        public float getFloatAttribute(String name) {
            return Float.parseFloat(this.getAttribute(name));
        }

        public float getFloatAttribute(String name, float defaultValue) {
            String value = this.getAttribute(name, null);
            if (value == null) {
                return defaultValue;
            }
            return Float.parseFloat(value);
        }

        public int getIntAttribute(String name) {
            return Integer.parseInt(this.getAttribute(name));
        }

        public int getIntAttribute(String name, int defaultValue) {
            String value = this.getAttribute(name, null);
            if (value == null) {
                return defaultValue;
            }
            return Integer.parseInt(value);
        }

        public boolean getBooleanAttribute(String name) {
            return Boolean.parseBoolean(this.getAttribute(name));
        }

        public boolean getBooleanAttribute(String name, boolean defaultValue) {
            String value = this.getAttribute(name, null);
            if (value == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(value);
        }

        public String get(String name) {
            String value = this.get(name, null);
            if (value == null) {
                throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + name);
            }
            return value;
        }

        public String get(String name, String defaultValue) {
            String value;
            if (this.attributes != null && (value = this.attributes.get(name)) != null) {
                return value;
            }
            Element child = this.getChildByName(name);
            if (child == null) {
                return defaultValue;
            }
            String value2 = child.getText();
            if (value2 == null) {
                return defaultValue;
            }
            return value2;
        }

        public int getInt(String name) {
            String value = this.get(name, null);
            if (value == null) {
                throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + name);
            }
            return Integer.parseInt(value);
        }

        public int getInt(String name, int defaultValue) {
            String value = this.get(name, null);
            if (value == null) {
                return defaultValue;
            }
            return Integer.parseInt(value);
        }

        public float getFloat(String name) {
            String value = this.get(name, null);
            if (value == null) {
                throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + name);
            }
            return Float.parseFloat(value);
        }

        public float getFloat(String name, float defaultValue) {
            String value = this.get(name, null);
            if (value == null) {
                return defaultValue;
            }
            return Float.parseFloat(value);
        }

        public boolean getBoolean(String name) {
            String value = this.get(name, null);
            if (value == null) {
                throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + name);
            }
            return Boolean.parseBoolean(value);
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            String value = this.get(name, null);
            if (value == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(value);
        }
    }
}

