/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Queue;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class QueueTest {
    @Test
    public void addFirstAndLastTest() {
        Queue<Integer> queue = new Queue<Integer>();
        queue.addFirst(1);
        queue.addLast(2);
        queue.addFirst(3);
        queue.addLast(4);
        Assert.assertEquals((long)0L, (long)queue.indexOf(3, true));
        Assert.assertEquals((long)1L, (long)queue.indexOf(1, true));
        Assert.assertEquals((long)2L, (long)queue.indexOf(2, true));
        Assert.assertEquals((long)3L, (long)queue.indexOf(4, true));
    }

    @Test
    public void removeLastTest() {
        Queue<Integer> queue = new Queue<Integer>();
        queue.addLast(1);
        queue.addLast(2);
        queue.addLast(3);
        queue.addLast(4);
        Assert.assertEquals((long)4L, (long)queue.size);
        Assert.assertEquals((long)3L, (long)queue.indexOf(4, true));
        Assert.assertEquals((Object)4, queue.removeLast());
        Assert.assertEquals((long)3L, (long)queue.size);
        Assert.assertEquals((long)2L, (long)queue.indexOf(3, true));
        Assert.assertEquals((Object)3, queue.removeLast());
        Assert.assertEquals((long)2L, (long)queue.size);
        Assert.assertEquals((long)1L, (long)queue.indexOf(2, true));
        Assert.assertEquals((Object)2, queue.removeLast());
        Assert.assertEquals((long)1L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(1, true));
        Assert.assertEquals((Object)1, queue.removeLast());
        Assert.assertEquals((long)0L, (long)queue.size);
    }

    @Test
    public void removeFirstTest() {
        Queue<Integer> queue = new Queue<Integer>();
        queue.addLast(1);
        queue.addLast(2);
        queue.addLast(3);
        queue.addLast(4);
        Assert.assertEquals((long)4L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(1, true));
        Assert.assertEquals((Object)1, queue.removeFirst());
        Assert.assertEquals((long)3L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(2, true));
        Assert.assertEquals((Object)2, queue.removeFirst());
        Assert.assertEquals((long)2L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(3, true));
        Assert.assertEquals((Object)3, queue.removeFirst());
        Assert.assertEquals((long)1L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(4, true));
        Assert.assertEquals((Object)4, queue.removeFirst());
        Assert.assertEquals((long)0L, (long)queue.size);
    }

    @Test
    public void resizableQueueTest() {
        Queue<Integer> q = new Queue<Integer>(8);
        Assert.assertTrue((String)"New queue is not empty!", (q.size == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < 100) {
            int size;
            int j = 0;
            while (j < i) {
                try {
                    q.addLast(j);
                }
                catch (IllegalStateException e) {
                    Assert.fail((String)("Failed to add element " + j + " (" + i + ")"));
                }
                Integer peeked = (Integer)q.last();
                Assert.assertTrue((String)("peekLast shows " + peeked + ", should be " + j + " (" + i + ")"), (boolean)peeked.equals(j));
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (j + 1) + " but is " + size + " (" + i + ")"), (size == j + 1 ? 1 : 0) != 0);
                ++j;
            }
            if (i != 0) {
                Integer peek = (Integer)q.first();
                Assert.assertTrue((String)("First thing is not zero but " + peek + " (" + i + ")"), (peek == 0 ? 1 : 0) != 0);
            }
            j = 0;
            while (j < i) {
                Integer pop = (Integer)q.removeFirst();
                Assert.assertTrue((String)("Popped should be " + j + " but is " + pop + " (" + i + ")"), (pop == j ? 1 : 0) != 0);
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (i - 1 - j) + " but is " + size + " (" + i + ")"), (size == i - 1 - j ? 1 : 0) != 0);
                ++j;
            }
            Assert.assertTrue((String)("Not empty after cycle " + i), (q.size == 0 ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 56) {
            q.addLast(42);
            ++i;
        }
        q.clear();
        Assert.assertTrue((String)"Clear did not clear properly", (q.size == 0 ? 1 : 0) != 0);
    }

    @Test
    public void resizableDequeTest() {
        Queue<Integer> q = new Queue<Integer>(8);
        Assert.assertTrue((String)"New deque is not empty!", (q.size == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < 100) {
            int size;
            int j = 0;
            while (j < i) {
                try {
                    q.addFirst(j);
                }
                catch (IllegalStateException e) {
                    Assert.fail((String)("Failed to add element " + j + " (" + i + ")"));
                }
                Integer peeked = (Integer)q.first();
                Assert.assertTrue((String)("peek shows " + peeked + ", should be " + j + " (" + i + ")"), (boolean)peeked.equals(j));
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (j + 1) + " but is " + size + " (" + i + ")"), (size == j + 1 ? 1 : 0) != 0);
                ++j;
            }
            if (i != 0) {
                Integer peek = (Integer)q.last();
                Assert.assertTrue((String)("Last thing is not zero but " + peek + " (" + i + ")"), (peek == 0 ? 1 : 0) != 0);
            }
            j = 0;
            while (j < i) {
                Integer pop = (Integer)q.removeLast();
                Assert.assertTrue((String)("Popped should be " + j + " but is " + pop + " (" + i + ")"), (pop == j ? 1 : 0) != 0);
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (i - 1 - j) + " but is " + size + " (" + i + ")"), (size == i - 1 - j ? 1 : 0) != 0);
                ++j;
            }
            Assert.assertTrue((String)("Not empty after cycle " + i), (q.size == 0 ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 56) {
            q.addFirst(42);
            ++i;
        }
        q.clear();
        Assert.assertTrue((String)"Clear did not clear properly", (q.size == 0 ? 1 : 0) != 0);
    }

    @Test
    public void getTest() {
        Queue<Integer> q = new Queue<Integer>(7);
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 4) {
                q.addLast(j);
                ++j;
            }
            Assert.assertEquals((String)("get(0) is not equal to peek (" + i + ")"), q.get(0), q.first());
            Assert.assertEquals((String)("get(size-1) is not equal to peekLast (" + i + ")"), q.get(q.size - 1), q.last());
            j = 0;
            while (j < 4) {
                Assert.assertTrue(((Integer)q.get(j) == j ? 1 : 0) != 0);
                ++j;
            }
            j = 0;
            while (j < 3) {
                q.removeFirst();
                Assert.assertEquals((String)("get(0) is not equal to peek (" + i + ")"), q.get(0), q.first());
                ++j;
            }
            q.removeFirst();
            assert (q.size == 0);
            try {
                q.get(0);
                Assert.fail((String)"get() on empty queue did not throw");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Test
    public void removeTest() {
        Queue<Integer> q = new Queue<Integer>();
        int j = 0;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        this.assertValues(q, 0, 1, 2, 3, 4, 5, 6);
        q.removeIndex(0);
        this.assertValues(q, 1, 2, 3, 4, 5, 6);
        q.removeIndex(1);
        this.assertValues(q, 1, 3, 4, 5, 6);
        q.removeIndex(4);
        this.assertValues(q, 1, 3, 4, 5);
        q.removeIndex(2);
        this.assertValues(q, 1, 3, 5);
        q.clear();
        j = 2;
        while (j >= 0) {
            q.addFirst(j);
            --j;
        }
        j = 3;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        this.assertValues(q, 0, 1, 2, 3, 4, 5, 6);
        q.removeIndex(1);
        this.assertValues(q, 0, 2, 3, 4, 5, 6);
        q.removeIndex(0);
        this.assertValues(q, 2, 3, 4, 5, 6);
        q.clear();
        j = 2;
        while (j >= 0) {
            q.addFirst(j);
            --j;
        }
        j = 3;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        this.assertValues(q, 0, 1, 2, 3, 4, 5, 6);
        q.removeIndex(5);
        this.assertValues(q, 0, 1, 2, 3, 4, 6);
        q.removeIndex(5);
        this.assertValues(q, 0, 1, 2, 3, 4);
    }

    @Test
    public void indexOfTest() {
        Queue<Integer> q = new Queue<Integer>();
        int j = 0;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        j = 0;
        while (j <= 6) {
            Assert.assertEquals((long)q.indexOf(j, false), (long)j);
            ++j;
        }
        q.clear();
        j = 2;
        while (j >= 0) {
            q.addFirst(j);
            --j;
        }
        j = 3;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        j = 0;
        while (j <= 6) {
            Assert.assertEquals((long)q.indexOf(j, false), (long)j);
            ++j;
        }
    }

    @Test
    public void iteratorTest() {
        Queue<Integer> q = new Queue<Integer>();
        int j = 0;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        Iterator<Object> iter = q.iterator();
        int j2 = 0;
        while (j2 <= 6) {
            Assert.assertEquals((long)((Integer)iter.next()).intValue(), (long)j2);
            ++j2;
        }
        iter = q.iterator();
        iter.next();
        iter.remove();
        this.assertValues(q, 1, 2, 3, 4, 5, 6);
        iter.next();
        iter.remove();
        this.assertValues(q, 2, 3, 4, 5, 6);
        iter.next();
        iter.next();
        iter.remove();
        this.assertValues(q, 2, 4, 5, 6);
        iter.next();
        iter.next();
        iter.next();
        iter.remove();
        this.assertValues(q, 2, 4, 5);
        q.clear();
        j2 = 2;
        while (j2 >= 0) {
            q.addFirst(j2);
            --j2;
        }
        j2 = 3;
        while (j2 <= 6) {
            q.addLast(j2);
            ++j2;
        }
        iter = q.iterator();
        j2 = 0;
        while (j2 <= 6) {
            Assert.assertEquals((long)((Integer)iter.next()).intValue(), (long)j2);
            ++j2;
        }
        iter = q.iterator();
        iter.next();
        iter.remove();
        this.assertValues(q, 1, 2, 3, 4, 5, 6);
        iter.next();
        iter.remove();
        this.assertValues(q, 2, 3, 4, 5, 6);
        iter.next();
        iter.next();
        iter.remove();
        this.assertValues(q, 2, 4, 5, 6);
        iter.next();
        iter.next();
        iter.next();
        iter.remove();
        this.assertValues(q, 2, 4, 5);
    }

    @Test
    public void iteratorRemoveEdgeCaseTest() {
        Queue<Integer> queue = new Queue<Integer>();
        int i = 0;
        while (i < 100) {
            queue.addLast(i);
            if (i > 50) {
                queue.removeFirst();
            }
            ++i;
        }
        Iterator it = queue.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        queue.addLast(1337);
        Integer i2 = (Integer)queue.first();
        Assert.assertEquals((long)1337L, (long)i2.intValue());
    }

    @Test
    public void toStringTest() {
        Queue<Integer> q = new Queue<Integer>(1);
        Assert.assertTrue((boolean)q.toString().equals("[]"));
        q.addLast(4);
        Assert.assertTrue((boolean)q.toString().equals("[4]"));
        q.addLast(5);
        q.addLast(6);
        q.addLast(7);
        Assert.assertTrue((boolean)q.toString().equals("[4, 5, 6, 7]"));
    }

    @Test
    public void hashEqualsTest() {
        Queue<Integer> q1 = new Queue<Integer>();
        Queue<Integer> q2 = new Queue<Integer>();
        this.assertEqualsAndHash(q1, q2);
        q1.addFirst(1);
        Assert.assertNotEquals(q1, q2);
        q2.addFirst(1);
        this.assertEqualsAndHash(q1, q2);
        q1.clear();
        q1.addLast(1);
        q1.addLast(2);
        q2.addLast(2);
        this.assertEqualsAndHash(q1, q2);
        int i = 0;
        while (i < 100) {
            q1.addLast(i);
            q1.addLast(i);
            q1.removeFirst();
            Assert.assertNotEquals(q1, q2);
            q2.addLast(i);
            q2.addLast(i);
            q2.removeFirst();
            this.assertEqualsAndHash(q1, q2);
            ++i;
        }
    }

    private void assertEqualsAndHash(Queue<?> q1, Queue<?> q2) {
        Assert.assertEquals(q1, q2);
        Assert.assertEquals((String)"Hash codes are not equal", (long)q1.hashCode(), (long)q2.hashCode());
    }

    private void assertValues(Queue<Integer> q, Integer ... values) {
        int i = 0;
        int n = values.length;
        while (i < n) {
            Assert.assertEquals((Object)values[i], (Object)q.get(i));
            ++i;
        }
    }
}

