/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.HashMap;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class MixedPutRemoveTest {
    @Test
    public void testLongMapPut() {
        LongMap<Integer> gdxMap = new LongMap<Integer>();
        HashMap<Long, Integer> jdkMap = new HashMap<Long, Integer>();
        long stateA = 0L;
        long stateB = 1L;
        int gdxRepeats = 0;
        int jdkRepeats = 0;
        int i = 0;
        while (i < 0x100000) {
            long item = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L);
            if (gdxMap.put(item &= item >>> 24, i) != null) {
                ++gdxRepeats;
            }
            if (jdkMap.put(item, i) != null) {
                ++jdkRepeats;
            }
            Assert.assertEquals((long)gdxMap.size, (long)jdkMap.size());
            ++i;
        }
        Assert.assertEquals((long)gdxRepeats, (long)jdkRepeats);
    }

    @Test
    public void testLongMapMix() {
        LongMap<Integer> gdxMap = new LongMap<Integer>();
        HashMap<Long, Integer> jdkMap = new HashMap<Long, Integer>();
        long stateA = 0L;
        long stateB = 1L;
        int gdxRemovals = 0;
        int jdkRemovals = 0;
        int i = 0;
        while (i < 0x100000) {
            long item = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L);
            if (gdxMap.remove(item &= item >>> 24) == null) {
                gdxMap.put(item, i);
            } else {
                ++gdxRemovals;
            }
            if (jdkMap.remove(item) == null) {
                jdkMap.put(item, i);
            } else {
                ++jdkRemovals;
            }
            Assert.assertEquals((long)gdxMap.size, (long)jdkMap.size());
            ++i;
        }
        Assert.assertEquals((long)gdxRemovals, (long)jdkRemovals);
    }

    @Test
    public void testLongMapIterator() {
        LongMap<Long> gdxMap = new LongMap<Long>();
        long stateA = 0L;
        long stateB = 1L;
        int actualSize = 0;
        int i = 0;
        while (i < 65536) {
            long item = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L);
            if (gdxMap.put(item &= item >>> 24, item) == null) {
                ++actualSize;
            }
            if (actualSize % 6 == 5) {
                Iterator it = gdxMap.values().iterator();
                int n = (int)(item & 3L) + 1;
                while (n > 0) {
                    it.next();
                    --n;
                }
                it.remove();
                --actualSize;
                int j = 0;
                while (j < 2) {
                    item = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L);
                    if (gdxMap.put(item &= item >>> 24, item) == null) {
                        ++actualSize;
                    }
                    ++j;
                }
            }
            Assert.assertEquals((long)gdxMap.size, (long)actualSize);
            ++i;
        }
        for (LongMap.Entry ent : gdxMap) {
            Assert.assertEquals((long)ent.key, (long)((Long)ent.value));
        }
    }

    @Test
    public void testIntMapPut() {
        IntMap<Integer> gdxMap = new IntMap<Integer>();
        HashMap<Integer, Integer> jdkMap = new HashMap<Integer, Integer>();
        long stateA = 0L;
        long stateB = 1L;
        int gdxRepeats = 0;
        int jdkRepeats = 0;
        int i = 0;
        while (i < 0x100000) {
            long temp;
            int item;
            if (gdxMap.put(item = (int)((temp = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L)) & temp >>> 24), i) != null) {
                ++gdxRepeats;
            }
            if (jdkMap.put(item, i) != null) {
                ++jdkRepeats;
            }
            Assert.assertEquals((long)gdxMap.size, (long)jdkMap.size());
            ++i;
        }
        Assert.assertEquals((long)gdxRepeats, (long)jdkRepeats);
    }

    @Test
    public void testIntMapMix() {
        IntMap<Integer> gdxMap = new IntMap<Integer>();
        HashMap<Integer, Integer> jdkMap = new HashMap<Integer, Integer>();
        long stateA = 0L;
        long stateB = 1L;
        int gdxRemovals = 0;
        int jdkRemovals = 0;
        int i = 0;
        while (i < 0x100000) {
            long temp;
            int item;
            if (gdxMap.remove(item = (int)((temp = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L)) & temp >>> 24)) == null) {
                gdxMap.put(item, i);
            } else {
                ++gdxRemovals;
            }
            if (jdkMap.remove(item) == null) {
                jdkMap.put(item, i);
            } else {
                ++jdkRemovals;
            }
            Assert.assertEquals((long)gdxMap.size, (long)jdkMap.size());
            ++i;
        }
        Assert.assertEquals((long)gdxRemovals, (long)jdkRemovals);
    }

    @Test
    public void testIntMapIterator() {
        IntMap<Integer> gdxMap = new IntMap<Integer>();
        long stateA = 0L;
        long stateB = 1L;
        boolean gdxRemovals = false;
        int actualSize = 0;
        int i = 0;
        while (i < 65536) {
            long temp;
            int item;
            if (gdxMap.put(item = (int)((temp = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L)) & temp >>> 24), item) == null) {
                ++actualSize;
            }
            if (actualSize % 6 == 5) {
                Iterator it = gdxMap.values().iterator();
                int n = (int)(temp & 3L) + 1;
                while (n > 0) {
                    it.next();
                    --n;
                }
                it.remove();
                --actualSize;
                int j = 0;
                while (j < 2) {
                    if (gdxMap.put(item = (int)((temp = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L)) & temp >>> 24), item) == null) {
                        ++actualSize;
                    }
                    ++j;
                }
            }
            Assert.assertEquals((long)gdxMap.size, (long)actualSize);
            ++i;
        }
        for (IntMap.Entry ent : gdxMap) {
            Assert.assertEquals((long)ent.key, (long)((Integer)ent.value).intValue());
        }
    }

    @Test
    public void testObjectMapPut() {
        ObjectMap<Integer, Integer> gdxMap = new ObjectMap<Integer, Integer>();
        HashMap<Integer, Integer> jdkMap = new HashMap<Integer, Integer>();
        long stateA = 0L;
        long stateB = 1L;
        int gdxRepeats = 0;
        int jdkRepeats = 0;
        int i = 0;
        while (i < 0x100000) {
            long temp;
            int item;
            if (gdxMap.put(item = (int)((temp = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L)) & temp >>> 24), i) != null) {
                ++gdxRepeats;
            }
            if (jdkMap.put(item, i) != null) {
                ++jdkRepeats;
            }
            Assert.assertEquals((long)gdxMap.size, (long)jdkMap.size());
            ++i;
        }
        Assert.assertEquals((long)gdxRepeats, (long)jdkRepeats);
    }

    @Test
    public void testObjectMapMix() {
        ObjectMap<Integer, Integer> gdxMap = new ObjectMap<Integer, Integer>();
        HashMap<Integer, Integer> jdkMap = new HashMap<Integer, Integer>();
        long stateA = 0L;
        long stateB = 1L;
        int gdxRemovals = 0;
        int jdkRemovals = 0;
        int i = 0;
        while (i < 0x100000) {
            long temp;
            int item;
            if (gdxMap.remove(item = (int)((temp = ((stateA += -4126379630918253789L) ^ stateA >>> 31) * (stateB += -7046029254386353130L)) & temp >>> 24)) == null) {
                gdxMap.put(item, i);
            } else {
                ++gdxRemovals;
            }
            if (jdkMap.remove(item) == null) {
                jdkMap.put(item, i);
            } else {
                ++jdkRemovals;
            }
            Assert.assertEquals((long)gdxMap.size, (long)jdkMap.size());
            ++i;
        }
        Assert.assertEquals((long)gdxRemovals, (long)jdkRemovals);
    }
}

