/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilsTest {
    @Test
    public void lerpAngleDeg() {
        Assert.assertEquals((float)10.0f, (float)MathUtils.lerpAngleDeg(10.0f, 30.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)20.0f, (float)MathUtils.lerpAngleDeg(10.0f, 30.0f, 0.5f), (float)0.01f);
        Assert.assertEquals((float)30.0f, (float)MathUtils.lerpAngleDeg(10.0f, 30.0f, 1.0f), (float)0.01f);
    }

    @Test
    public void lerpAngleDegCrossingZero() {
        Assert.assertEquals((float)350.0f, (float)MathUtils.lerpAngleDeg(350.0f, 10.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.lerpAngleDeg(350.0f, 10.0f, 0.5f), (float)0.01f);
        Assert.assertEquals((float)10.0f, (float)MathUtils.lerpAngleDeg(350.0f, 10.0f, 1.0f), (float)0.01f);
    }

    @Test
    public void lerpAngleDegCrossingZeroBackwards() {
        Assert.assertEquals((float)10.0f, (float)MathUtils.lerpAngleDeg(10.0f, 350.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.lerpAngleDeg(10.0f, 350.0f, 0.5f), (float)0.01f);
        Assert.assertEquals((float)350.0f, (float)MathUtils.lerpAngleDeg(10.0f, 350.0f, 1.0f), (float)0.01f);
    }

    @Test
    public void testNorm() {
        Assert.assertEquals((float)-1.0f, (float)MathUtils.norm(10.0f, 20.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.norm(10.0f, 20.0f, 10.0f), (float)0.01f);
        Assert.assertEquals((float)0.5f, (float)MathUtils.norm(10.0f, 20.0f, 15.0f), (float)0.01f);
        Assert.assertEquals((float)1.0f, (float)MathUtils.norm(10.0f, 20.0f, 20.0f), (float)0.01f);
        Assert.assertEquals((float)2.0f, (float)MathUtils.norm(10.0f, 20.0f, 30.0f), (float)0.01f);
    }

    @Test
    public void testMap() {
        Assert.assertEquals((float)0.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)100.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 10.0f), (float)0.01f);
        Assert.assertEquals((float)150.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 15.0f), (float)0.01f);
        Assert.assertEquals((float)200.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 20.0f), (float)0.01f);
        Assert.assertEquals((float)300.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 30.0f), (float)0.01f);
    }

    @Test
    public void testRandomLong() {
        int i = 0;
        while (i < 512) {
            long r = MathUtils.random(1L, 5L);
            Assert.assertTrue((r >= 1L && r <= 5L ? 1 : 0) != 0);
            r = MathUtils.random(6L, 1L);
            Assert.assertTrue((r >= 1L && r <= 6L ? 1 : 0) != 0);
            r = MathUtils.random(-1L, -7L);
            Assert.assertTrue((r <= -1L && r >= -7L ? 1 : 0) != 0);
            r = MathUtils.random(-8L, -1L);
            Assert.assertTrue((r <= -1L && r >= -8L ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testSinDeg() {
        Assert.assertEquals((float)0.0f, (float)MathUtils.sinDeg(0.0f), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)MathUtils.sinDeg(90.0f), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.sinDeg(180.0f), (float)0.0f);
        Assert.assertEquals((float)-1.0f, (float)MathUtils.sinDeg(270.0f), (float)0.0f);
    }

    @Test
    public void testCosDeg() {
        Assert.assertEquals((float)1.0f, (float)MathUtils.cosDeg(0.0f), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.cosDeg(90.0f), (float)0.0f);
        Assert.assertEquals((float)-1.0f, (float)MathUtils.cosDeg(180.0f), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.cosDeg(270.0f), (float)0.0f);
    }
}

