/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.utils.ObjectMap;
import java.net.HttpURLConnection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NetJavaImpl {
    private final ThreadPoolExecutor executorService;
    final ObjectMap<Net.HttpRequest, HttpURLConnection> connections;
    final ObjectMap<Net.HttpRequest, Object> listeners;
    final ObjectMap<Net.HttpRequest, Future<?>> tasks;

    public NetJavaImpl() {
        this(Integer.MAX_VALUE);
    }

    public NetJavaImpl(int maxThreads) {
        boolean isCachedPool = maxThreads == Integer.MAX_VALUE;
        this.executorService = new ThreadPoolExecutor(isCachedPool ? 0 : maxThreads, maxThreads, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)(isCachedPool ? new SynchronousQueue() : new LinkedBlockingQueue())), new ThreadFactory(){
            AtomicInteger threadID = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "NetThread" + this.threadID.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        });
        this.executorService.allowCoreThreadTimeOut(!isCachedPool);
        this.connections = new ObjectMap();
        this.listeners = new ObjectMap();
        this.tasks = new ObjectMap();
    }
}

