/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.AbstractGraphics;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3GL20;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3GL30;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3GL31;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3GL32;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.GL31;
import com.badlogic.gdx.graphics.GL32;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.system.Configuration;

public class Lwjgl3Graphics
extends AbstractGraphics
implements Disposable {
    final Lwjgl3Window window;
    GL20 gl20;
    private GL30 gl30;
    private GL31 gl31;
    private GL32 gl32;
    private GLVersion glVersion;
    private volatile int backBufferWidth;
    private volatile int backBufferHeight;
    private volatile int logicalWidth;
    private volatile int logicalHeight;
    private volatile boolean isContinuous = true;
    private Graphics.BufferFormat bufferFormat;
    private long lastFrameTime = -1L;
    private float deltaTime;
    private boolean resetDeltaTime = false;
    private long frameId;
    private long frameCounterStart = 0L;
    private int frames;
    private int fps;
    private Graphics.DisplayMode displayModeBeforeFullscreen = null;
    IntBuffer tmpBuffer = BufferUtils.createIntBuffer(1);
    IntBuffer tmpBuffer2 = BufferUtils.createIntBuffer(1);
    GLFWFramebufferSizeCallback resizeCallback = new GLFWFramebufferSizeCallback(){

        @Override
        public void invoke(long windowHandle, int width, int height) {
            if (!"glfw_async".equals(Configuration.GLFW_LIBRARY_NAME.get())) {
                Lwjgl3Graphics.this.updateFramebufferInfo();
                if (!Lwjgl3Graphics.this.window.isListenerInitialized()) {
                    return;
                }
                Lwjgl3Graphics.this.window.makeCurrent();
                Lwjgl3Graphics.this.gl20.glViewport(0, 0, Lwjgl3Graphics.this.backBufferWidth, Lwjgl3Graphics.this.backBufferHeight);
                Lwjgl3Graphics.this.window.getListener().resize(Lwjgl3Graphics.this.getWidth(), Lwjgl3Graphics.this.getHeight());
                Lwjgl3Graphics.this.update();
                Lwjgl3Graphics.this.window.getListener().render();
                GLFW.glfwSwapBuffers(windowHandle);
            } else {
                Lwjgl3Graphics.this.window.asyncResized = true;
            }
        }
    };

    public Lwjgl3Graphics(Lwjgl3Window window) {
        this.window = window;
        if (window.getConfig().glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.GL32) {
            this.gl32 = new Lwjgl3GL32();
            this.gl31 = this.gl32;
            this.gl30 = this.gl32;
            this.gl20 = this.gl32;
        } else if (window.getConfig().glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.GL31) {
            this.gl31 = new Lwjgl3GL31();
            this.gl30 = this.gl31;
            this.gl20 = this.gl31;
        } else if (window.getConfig().glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.GL30) {
            this.gl30 = new Lwjgl3GL30();
            this.gl20 = this.gl30;
        } else {
            try {
                this.gl20 = window.getConfig().glEmulation == Lwjgl3ApplicationConfiguration.GLEmulation.GL20 ? new Lwjgl3GL20() : (GL20)Class.forName("com.badlogic.gdx.backends.lwjgl3.angle.Lwjgl3GLES20").newInstance();
            }
            catch (Throwable t) {
                throw new GdxRuntimeException("Couldn't instantiate GLES20.", t);
            }
            this.gl30 = null;
        }
        this.updateFramebufferInfo();
        this.initiateGL();
        GLFW.glfwSetFramebufferSizeCallback(window.getWindowHandle(), this.resizeCallback);
    }

    private void initiateGL() {
        String versionString = this.gl20.glGetString(7938);
        String vendorString = this.gl20.glGetString(7936);
        String rendererString = this.gl20.glGetString(7937);
        this.glVersion = new GLVersion(Application.ApplicationType.Desktop, versionString, vendorString, rendererString);
        if (this.supportsCubeMapSeamless()) {
            this.enableCubeMapSeamless(true);
        }
    }

    public boolean supportsCubeMapSeamless() {
        return this.glVersion.isVersionEqualToOrHigher(3, 2) || this.supportsExtension("GL_ARB_seamless_cube_map");
    }

    public void enableCubeMapSeamless(boolean enable) {
        if (enable) {
            this.gl20.glEnable(34895);
        } else {
            this.gl20.glDisable(34895);
        }
    }

    void updateFramebufferInfo() {
        GLFW.glfwGetFramebufferSize(this.window.getWindowHandle(), this.tmpBuffer, this.tmpBuffer2);
        this.backBufferWidth = this.tmpBuffer.get(0);
        this.backBufferHeight = this.tmpBuffer2.get(0);
        GLFW.glfwGetWindowSize(this.window.getWindowHandle(), this.tmpBuffer, this.tmpBuffer2);
        this.logicalWidth = this.tmpBuffer.get(0);
        this.logicalHeight = this.tmpBuffer2.get(0);
        Lwjgl3ApplicationConfiguration config = this.window.getConfig();
        this.bufferFormat = new Graphics.BufferFormat(config.r, config.g, config.b, config.a, config.depth, config.stencil, config.samples, false);
    }

    void update() {
        long time = System.nanoTime();
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = time;
        }
        if (this.resetDeltaTime) {
            this.resetDeltaTime = false;
            this.deltaTime = 0.0f;
        } else {
            this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        }
        this.lastFrameTime = time;
        if (time - this.frameCounterStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameCounterStart = time;
        }
        ++this.frames;
        ++this.frameId;
    }

    public GL20 getGL20() {
        return this.gl20;
    }

    public GL30 getGL30() {
        return this.gl30;
    }

    public GL31 getGL31() {
        return this.gl31;
    }

    public GL32 getGL32() {
        return this.gl32;
    }

    @Override
    public int getWidth() {
        if (this.window.getConfig().hdpiMode == HdpiMode.Pixels) {
            return this.backBufferWidth;
        }
        return this.logicalWidth;
    }

    @Override
    public int getHeight() {
        if (this.window.getConfig().hdpiMode == HdpiMode.Pixels) {
            return this.backBufferHeight;
        }
        return this.logicalHeight;
    }

    @Override
    public int getBackBufferWidth() {
        return this.backBufferWidth;
    }

    @Override
    public int getBackBufferHeight() {
        return this.backBufferHeight;
    }

    public int getLogicalWidth() {
        return this.logicalWidth;
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    @Override
    public float getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return GLFW.glfwExtensionSupported(extension);
    }

    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    @Override
    public void requestRendering() {
        this.window.requestRendering();
    }

    @Override
    public void dispose() {
        this.resizeCallback.free();
    }

    public static class Lwjgl3Monitor
    extends Graphics.Monitor {
        final long monitorHandle;

        Lwjgl3Monitor(long monitor, int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
            this.monitorHandle = monitor;
        }
    }

    public static class Lwjgl3DisplayMode
    extends Graphics.DisplayMode {
        final long monitorHandle;

        Lwjgl3DisplayMode(long monitor, int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
            this.monitorHandle = monitor;
        }

        public long getMonitor() {
            return this.monitorHandle;
        }
    }
}

