/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ShortArray;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.utils.Triangulator;

public class SkeletonClipping {
    private final Triangulator triangulator = new Triangulator();
    private final FloatArray clippingPolygon = new FloatArray();
    private final FloatArray clipOutput = new FloatArray(128);
    private final FloatArray clippedVertices = new FloatArray(128);
    private final FloatArray clippedUvs = new FloatArray(128);
    private final ShortArray clippedTriangles = new ShortArray(128);
    private final FloatArray scratch = new FloatArray();
    private ClippingAttachment clipAttachment;
    private Array<FloatArray> clippingPolygons;

    public void clipStart(Slot slot, ClippingAttachment clippingAttachment) {
        if (this.clipAttachment != null) {
            return;
        }
        int n = clippingAttachment.getWorldVerticesLength();
        if (n < 6) {
            return;
        }
        this.clipAttachment = clippingAttachment;
        float[] fArray = this.clippingPolygon.setSize(n);
        clippingAttachment.computeWorldVertices(slot, 0, n, fArray, 0, 2);
        SkeletonClipping.makeClockwise(this.clippingPolygon);
        ShortArray shortArray = this.triangulator.triangulate(this.clippingPolygon);
        this.clippingPolygons = this.triangulator.decompose(this.clippingPolygon, shortArray);
        for (FloatArray floatArray : this.clippingPolygons) {
            SkeletonClipping.makeClockwise(floatArray);
            floatArray.add(floatArray.items[0]);
            floatArray.add(floatArray.items[1]);
        }
    }

    public void clipEnd(Slot slot) {
        if (this.clipAttachment != null && this.clipAttachment.getEndSlot() == slot.getData()) {
            this.clipEnd();
        }
    }

    public void clipEnd() {
        if (this.clipAttachment == null) {
            return;
        }
        this.clipAttachment = null;
        this.clippingPolygons = null;
        this.clippedVertices.clear();
        this.clippedUvs.clear();
        this.clippedTriangles.clear();
        this.clippingPolygon.clear();
    }

    public boolean isClipping() {
        return this.clipAttachment != null;
    }

    public boolean clipTriangles(float[] fArray, short[] sArray, int n, float[] fArray2, float f, float f2, boolean bl, int n2) {
        FloatArray floatArray = this.clipOutput;
        FloatArray floatArray2 = this.clippedVertices;
        ShortArray shortArray = this.clippedTriangles;
        T[] TArray = this.clippingPolygons.items;
        int n3 = this.clippingPolygons.size;
        short s = 0;
        floatArray2.clear();
        this.clippedUvs.clear();
        shortArray.clear();
        float[] fArray3 = null;
        block0: for (int i = 0; i < n; i += 3) {
            short s2 = sArray[i];
            float f3 = fArray2[s2 << 1];
            float f4 = fArray2[(s2 << 1) + 1];
            float f5 = fArray[s2 * n2];
            float f6 = fArray[s2 * n2 + 1];
            s2 = sArray[i + 1];
            float f7 = fArray2[s2 << 1];
            float f8 = fArray2[(s2 << 1) + 1];
            float f9 = fArray[s2 * n2];
            float f10 = fArray[s2 * n2 + 1];
            s2 = sArray[i + 2];
            float f11 = fArray2[s2 << 1];
            float f12 = fArray2[(s2 << 1) + 1];
            float f13 = fArray[s2 * n2];
            float f14 = fArray[s2 * n2 + 1];
            for (int j = 0; j < n3; ++j) {
                int n4 = floatArray2.size;
                if (this.clip(f5, f6, f9, f10, f13, f14, (FloatArray)TArray[j], floatArray)) {
                    fArray3 = floatArray.items;
                    int n5 = floatArray.size;
                    if (n5 == 0) continue;
                    float f15 = f10 - f14;
                    float f16 = f13 - f9;
                    float f17 = f5 - f13;
                    float f18 = f14 - f6;
                    float f19 = 1.0f / (f15 * f17 + f16 * (f6 - f14));
                    int n6 = n5 >> 1;
                    float[] fArray4 = floatArray2.setSize(n4 + n6 * n2);
                    int n7 = 0;
                    while (n7 < n5) {
                        float f20 = fArray3[n7];
                        float f21 = fArray3[n7 + 1];
                        fArray4[n4] = f20;
                        fArray4[n4 + 1] = f21;
                        fArray4[n4 + 2] = f;
                        if (bl) {
                            fArray4[n4 + 3] = f2;
                            n4 += 4;
                        } else {
                            n4 += 3;
                        }
                        float f22 = f20 - f13;
                        float f23 = f21 - f14;
                        float f24 = (f15 * f22 + f16 * f23) * f19;
                        float f25 = (f18 * f22 + f17 * f23) * f19;
                        float f26 = 1.0f - f24 - f25;
                        fArray4[n4] = f3 * f24 + f7 * f25 + f11 * f26;
                        fArray4[n4 + 1] = f4 * f24 + f8 * f25 + f12 * f26;
                        n7 += 2;
                        n4 += 2;
                    }
                    n4 = shortArray.size;
                    short[] sArray2 = shortArray.setSize(n4 + 3 * (n6 - 2));
                    --n6;
                    int n8 = 1;
                    while (n8 < n6) {
                        sArray2[n4] = s;
                        sArray2[n4 + 1] = (short)(s + n8);
                        sArray2[n4 + 2] = (short)(s + n8 + 1);
                        ++n8;
                        n4 += 3;
                    }
                    s = (short)(s + (n6 + 1));
                    continue;
                }
                float[] fArray5 = floatArray2.setSize(n4 + 3 * n2);
                fArray5[n4] = f5;
                fArray5[n4 + 1] = f6;
                fArray5[n4 + 2] = f;
                if (!bl) {
                    fArray5[n4 + 3] = f3;
                    fArray5[n4 + 4] = f4;
                    fArray5[n4 + 5] = f9;
                    fArray5[n4 + 6] = f10;
                    fArray5[n4 + 7] = f;
                    fArray5[n4 + 8] = f7;
                    fArray5[n4 + 9] = f8;
                    fArray5[n4 + 10] = f13;
                    fArray5[n4 + 11] = f14;
                    fArray5[n4 + 12] = f;
                    fArray5[n4 + 13] = f11;
                    fArray5[n4 + 14] = f12;
                } else {
                    fArray5[n4 + 3] = f2;
                    fArray5[n4 + 4] = f3;
                    fArray5[n4 + 5] = f4;
                    fArray5[n4 + 6] = f9;
                    fArray5[n4 + 7] = f10;
                    fArray5[n4 + 8] = f;
                    fArray5[n4 + 9] = f2;
                    fArray5[n4 + 10] = f7;
                    fArray5[n4 + 11] = f8;
                    fArray5[n4 + 12] = f13;
                    fArray5[n4 + 13] = f14;
                    fArray5[n4 + 14] = f;
                    fArray5[n4 + 15] = f2;
                    fArray5[n4 + 16] = f11;
                    fArray5[n4 + 17] = f12;
                }
                n4 = shortArray.size;
                short[] sArray3 = shortArray.setSize(n4 + 3);
                sArray3[n4] = s;
                sArray3[n4 + 1] = (short)(s + 1);
                sArray3[n4 + 2] = (short)(s + 2);
                s = (short)(s + 3);
                continue block0;
            }
        }
        return fArray3 != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean clip(float f, float f2, float f3, float f4, float f5, float f6, FloatArray floatArray, FloatArray floatArray2) {
        FloatArray floatArray3 = floatArray2;
        boolean bl = false;
        FloatArray floatArray4 = null;
        if (floatArray.size % 4 >= 2) {
            floatArray4 = floatArray2;
            floatArray2 = this.scratch;
        } else {
            floatArray4 = this.scratch;
        }
        floatArray4.clear();
        floatArray4.add(f);
        floatArray4.add(f2);
        floatArray4.add(f3);
        floatArray4.add(f4);
        floatArray4.add(f5);
        floatArray4.add(f6);
        floatArray4.add(f);
        floatArray4.add(f2);
        floatArray2.clear();
        int n = floatArray.size - 4;
        float[] fArray = floatArray.items;
        int n2 = 0;
        while (true) {
            float f7 = fArray[n2];
            float f8 = fArray[n2 + 1];
            float f9 = f7 - fArray[n2 + 2];
            float f10 = f8 - fArray[n2 + 3];
            int n3 = floatArray2.size;
            float[] fArray2 = floatArray4.items;
            int n4 = 0;
            int n5 = floatArray4.size - 2;
            while (n4 < n5) {
                block13: {
                    float f11;
                    float f12;
                    float f13;
                    float f14;
                    float f15 = fArray2[n4];
                    float f16 = fArray2[n4 + 1];
                    float f17 = fArray2[n4 += 2];
                    boolean bl2 = f10 * (f7 - f17) > f9 * (f8 - (f14 = fArray2[n4 + 1]));
                    float f18 = f10 * (f7 - f15) - f9 * (f8 - f16);
                    if (f18 > 0.0f) {
                        if (bl2) {
                            floatArray2.add(f17);
                            floatArray2.add(f14);
                            continue;
                        }
                        f13 = f17 - f15;
                        f12 = f14 - f16;
                        f11 = f18 / (f13 * f10 - f12 * f9);
                        if (f11 >= 0.0f && f11 <= 1.0f) {
                            floatArray2.add(f15 + f13 * f11);
                            floatArray2.add(f16 + f12 * f11);
                            break block13;
                        } else {
                            floatArray2.add(f17);
                            floatArray2.add(f14);
                            continue;
                        }
                    }
                    if (bl2) {
                        f13 = f17 - f15;
                        f12 = f14 - f16;
                        f11 = f18 / (f13 * f10 - f12 * f9);
                        if (f11 >= 0.0f && f11 <= 1.0f) {
                            floatArray2.add(f15 + f13 * f11);
                            floatArray2.add(f16 + f12 * f11);
                            floatArray2.add(f17);
                            floatArray2.add(f14);
                        } else {
                            floatArray2.add(f17);
                            floatArray2.add(f14);
                            continue;
                        }
                    }
                }
                bl = true;
            }
            if (n3 == floatArray2.size) {
                floatArray3.clear();
                return true;
            }
            floatArray2.add(floatArray2.items[0]);
            floatArray2.add(floatArray2.items[1]);
            if (n2 == n) {
                if (floatArray3 != floatArray2) break;
                floatArray3.setSize(floatArray3.size - 2);
                return bl;
            }
            FloatArray floatArray5 = floatArray2;
            floatArray2 = floatArray4;
            floatArray2.clear();
            floatArray4 = floatArray5;
            n2 += 2;
        }
        floatArray3.clear();
        floatArray3.addAll(floatArray2.items, 0, floatArray2.size - 2);
        return bl;
    }

    public FloatArray getClippedVertices() {
        return this.clippedVertices;
    }

    public ShortArray getClippedTriangles() {
        return this.clippedTriangles;
    }

    static void makeClockwise(FloatArray floatArray) {
        int n;
        float[] fArray = floatArray.items;
        int n2 = floatArray.size;
        float f = fArray[n2 - 2] * fArray[1] - fArray[0] * fArray[n2 - 1];
        int n3 = n2 - 3;
        for (n = 0; n < n3; n += 2) {
            float f2 = fArray[n];
            float f3 = fArray[n + 1];
            float f4 = fArray[n + 2];
            float f5 = fArray[n + 3];
            f += f2 * f5 - f4 * f3;
        }
        if (f < 0.0f) {
            return;
        }
        n3 = n2 - 2;
        int n4 = n2 >> 1;
        for (n = 0; n < n4; n += 2) {
            float f6 = fArray[n];
            float f7 = fArray[n + 1];
            int n5 = n3 - n;
            fArray[n] = fArray[n5];
            fArray[n + 1] = fArray[n5 + 1];
            fArray[n5] = f6;
            fArray[n5 + 1] = f7;
        }
    }
}

