/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class PointAttachment
extends Attachment {
    float x;
    float y;
    float rotation;
    final Color color = new Color(0.9451f, 0.9451f, 0.0f, 1.0f);

    public PointAttachment(String string) {
        super(string);
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public Color getColor() {
        return this.color;
    }

    public Vector2 computeWorldPosition(Bone bone, Vector2 vector2) {
        vector2.x = this.x * bone.getA() + this.y * bone.getB() + bone.getWorldX();
        vector2.y = this.x * bone.getC() + this.y * bone.getD() + bone.getWorldY();
        return vector2;
    }

    public float computeWorldRotation(Bone bone) {
        float f = this.rotation * ((float)Math.PI / 180);
        float f2 = SpineUtils.cos(f);
        float f3 = SpineUtils.sin(f);
        float f4 = f2 * bone.getA() + f3 * bone.getB();
        float f5 = f2 * bone.getC() + f3 * bone.getD();
        return SpineUtils.atan2Deg(f5, f4);
    }
}

