/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;

public class SplitPane
extends WidgetGroup {
    SplitPaneStyle style;
    private Actor firstWidget;
    private Actor secondWidget;
    boolean vertical;
    float splitAmount;
    float minAmount;
    float maxAmount;
    private final Rectangle firstWidgetBounds;
    private final Rectangle secondWidgetBounds;
    final Rectangle handleBounds;
    private final Rectangle tempScissors;

    public void setStyle(SplitPaneStyle style) {
        this.style = style;
        this.invalidateHierarchy();
    }

    public SplitPaneStyle getStyle() {
        return this.style;
    }

    @Override
    public void layout() {
        Actor secondWidget;
        this.clampSplitAmount();
        if (!this.vertical) {
            this.calculateHorizBoundsAndPositions();
        } else {
            this.calculateVertBoundsAndPositions();
        }
        Actor firstWidget = this.firstWidget;
        if (firstWidget != null) {
            Rectangle firstWidgetBounds = this.firstWidgetBounds;
            firstWidget.setBounds(firstWidgetBounds.x, firstWidgetBounds.y, firstWidgetBounds.width, firstWidgetBounds.height);
            if (firstWidget instanceof Layout) {
                ((Layout)((Object)firstWidget)).validate();
            }
        }
        if ((secondWidget = this.secondWidget) != null) {
            Rectangle secondWidgetBounds = this.secondWidgetBounds;
            secondWidget.setBounds(secondWidgetBounds.x, secondWidgetBounds.y, secondWidgetBounds.width, secondWidgetBounds.height);
            if (secondWidget instanceof Layout) {
                ((Layout)((Object)secondWidget)).validate();
            }
        }
    }

    @Override
    public float getPrefWidth() {
        float second;
        float first;
        float f = this.firstWidget == null ? 0.0f : (first = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefWidth() : this.firstWidget.getWidth());
        float f2 = this.secondWidget == null ? 0.0f : (second = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefWidth() : this.secondWidget.getWidth());
        if (this.vertical) {
            return Math.max(first, second);
        }
        return first + this.style.handle.getMinWidth() + second;
    }

    @Override
    public float getPrefHeight() {
        float second;
        float first;
        float f = this.firstWidget == null ? 0.0f : (first = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getPrefHeight() : this.firstWidget.getHeight());
        float f2 = this.secondWidget == null ? 0.0f : (second = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getPrefHeight() : this.secondWidget.getHeight());
        if (!this.vertical) {
            return Math.max(first, second);
        }
        return first + this.style.handle.getMinHeight() + second;
    }

    @Override
    public float getMinWidth() {
        float second;
        float first = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getMinWidth() : 0.0f;
        float f = second = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getMinWidth() : 0.0f;
        if (this.vertical) {
            return Math.max(first, second);
        }
        return first + this.style.handle.getMinWidth() + second;
    }

    @Override
    public float getMinHeight() {
        float second;
        float first = this.firstWidget instanceof Layout ? ((Layout)((Object)this.firstWidget)).getMinHeight() : 0.0f;
        float f = second = this.secondWidget instanceof Layout ? ((Layout)((Object)this.secondWidget)).getMinHeight() : 0.0f;
        if (!this.vertical) {
            return Math.max(first, second);
        }
        return first + this.style.handle.getMinHeight() + second;
    }

    private void calculateHorizBoundsAndPositions() {
        Drawable handle = this.style.handle;
        float height = this.getHeight();
        float availWidth = this.getWidth() - handle.getMinWidth();
        float leftAreaWidth = (int)(availWidth * this.splitAmount);
        float rightAreaWidth = availWidth - leftAreaWidth;
        float handleWidth = handle.getMinWidth();
        this.firstWidgetBounds.set(0.0f, 0.0f, leftAreaWidth, height);
        this.secondWidgetBounds.set(leftAreaWidth + handleWidth, 0.0f, rightAreaWidth, height);
        this.handleBounds.set(leftAreaWidth, 0.0f, handleWidth, height);
    }

    private void calculateVertBoundsAndPositions() {
        Drawable handle = this.style.handle;
        float width = this.getWidth();
        float height = this.getHeight();
        float availHeight = height - handle.getMinHeight();
        float topAreaHeight = (int)(availHeight * this.splitAmount);
        float bottomAreaHeight = availHeight - topAreaHeight;
        float handleHeight = handle.getMinHeight();
        this.firstWidgetBounds.set(0.0f, height - topAreaHeight, width, topAreaHeight);
        this.secondWidgetBounds.set(0.0f, 0.0f, width, bottomAreaHeight);
        this.handleBounds.set(0.0f, bottomAreaHeight, width, handleHeight);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        this.validate();
        Color color = this.getColor();
        float alpha = color.a * parentAlpha;
        this.applyTransform(batch, this.computeTransform());
        if (this.firstWidget != null && this.firstWidget.isVisible()) {
            batch.flush();
            stage.calculateScissors(this.firstWidgetBounds, this.tempScissors);
            if (ScissorStack.pushScissors(this.tempScissors)) {
                this.firstWidget.draw(batch, alpha);
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        if (this.secondWidget != null && this.secondWidget.isVisible()) {
            batch.flush();
            stage.calculateScissors(this.secondWidgetBounds, this.tempScissors);
            if (ScissorStack.pushScissors(this.tempScissors)) {
                this.secondWidget.draw(batch, alpha);
                batch.flush();
                ScissorStack.popScissors();
            }
        }
        batch.setColor(color.r, color.g, color.b, alpha);
        this.style.handle.draw(batch, this.handleBounds.x, this.handleBounds.y, this.handleBounds.width, this.handleBounds.height);
        this.resetTransform(batch);
    }

    protected void clampSplitAmount() {
        float effectiveMinAmount = this.minAmount;
        float effectiveMaxAmount = this.maxAmount;
        if (this.vertical) {
            float availableHeight = this.getHeight() - this.style.handle.getMinHeight();
            if (this.firstWidget instanceof Layout) {
                effectiveMinAmount = Math.max(effectiveMinAmount, Math.min(((Layout)((Object)this.firstWidget)).getMinHeight() / availableHeight, 1.0f));
            }
            if (this.secondWidget instanceof Layout) {
                effectiveMaxAmount = Math.min(effectiveMaxAmount, 1.0f - Math.min(((Layout)((Object)this.secondWidget)).getMinHeight() / availableHeight, 1.0f));
            }
        } else {
            float availableWidth = this.getWidth() - this.style.handle.getMinWidth();
            if (this.firstWidget instanceof Layout) {
                effectiveMinAmount = Math.max(effectiveMinAmount, Math.min(((Layout)((Object)this.firstWidget)).getMinWidth() / availableWidth, 1.0f));
            }
            if (this.secondWidget instanceof Layout) {
                effectiveMaxAmount = Math.min(effectiveMaxAmount, 1.0f - Math.min(((Layout)((Object)this.secondWidget)).getMinWidth() / availableWidth, 1.0f));
            }
        }
        this.splitAmount = effectiveMinAmount > effectiveMaxAmount ? 0.5f * (effectiveMinAmount + effectiveMaxAmount) : Math.max(Math.min(this.splitAmount, effectiveMaxAmount), effectiveMinAmount);
    }

    public void setFirstWidget(Actor widget) {
        if (this.firstWidget != null) {
            super.removeActor(this.firstWidget);
        }
        this.firstWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    public void setSecondWidget(Actor widget) {
        if (this.secondWidget != null) {
            super.removeActor(this.secondWidget);
        }
        this.secondWidget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
        this.invalidate();
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use SplitPane#setWidget.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor == this.firstWidget) {
            this.setFirstWidget(null);
            return true;
        }
        if (actor == this.secondWidget) {
            this.setSecondWidget(null);
            return true;
        }
        return true;
    }

    @Override
    public boolean removeActor(Actor actor, boolean unfocus) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        if (actor == this.firstWidget) {
            super.removeActor(actor, unfocus);
            this.firstWidget = null;
            this.invalidate();
            return true;
        }
        if (actor == this.secondWidget) {
            super.removeActor(actor, unfocus);
            this.secondWidget = null;
            this.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public Actor removeActorAt(int index, boolean unfocus) {
        Actor actor = super.removeActorAt(index, unfocus);
        if (actor == this.firstWidget) {
            super.removeActor(actor, unfocus);
            this.firstWidget = null;
            this.invalidate();
        } else if (actor == this.secondWidget) {
            super.removeActor(actor, unfocus);
            this.secondWidget = null;
            this.invalidate();
        }
        return actor;
    }

    public static class SplitPaneStyle {
        public Drawable handle;

        public SplitPaneStyle() {
        }

        public SplitPaneStyle(SplitPaneStyle style) {
            this.handle = style.handle;
        }
    }
}

