/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowAdapter;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBinary;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.SkeletonRenderer;
import com.esotericsoftware.spine.SkeletonRendererDebug;
import com.esotericsoftware.spine.SkeletonViewerAtlas;
import com.esotericsoftware.spine.SkeletonViewerUI;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.utils.TwoColorPolygonBatch;
import java.awt.Toolkit;
import java.lang.reflect.Field;

public class SkeletonViewer
extends ApplicationAdapter {
    static final String[] startSuffixes = new String[]{"", "-pro", "-ess"};
    static final String[] dataSuffixes = new String[]{".json", ".skel"};
    static final String[] endSuffixes = new String[]{"", ".txt", ".bytes"};
    static final String[] atlasSuffixes = new String[]{".atlas", "-pma.atlas"};
    static String[] args;
    static float uiScale;
    Preferences prefs;
    TwoColorPolygonBatch batch;
    OrthographicCamera camera;
    SkeletonRenderer renderer;
    SkeletonRendererDebug debugRenderer;
    SkeletonViewerUI ui;
    SkeletonViewerAtlas atlas;
    SkeletonData skeletonData;
    Skeleton skeleton;
    AnimationState state;
    FileHandle skeletonFile;
    long skeletonModified;
    long atlasModified;
    float lastModifiedCheck;
    float reloadTimer;
    final StringBuilder status = new StringBuilder();

    @Override
    public void create() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                System.out.println("Uncaught exception:");
                throwable.printStackTrace();
                Runtime.getRuntime().halt(0);
            }
        });
        this.prefs = Gdx.app.getPreferences("spine-skeletonviewer");
        this.batch = new TwoColorPolygonBatch(3100);
        this.camera = new OrthographicCamera();
        this.renderer = new SkeletonRenderer();
        this.debugRenderer = new SkeletonRendererDebug();
        this.ui = new SkeletonViewerUI(this);
        this.resetCameraPosition();
        this.ui.loadPrefs();
        if (args.length == 0) {
            FileHandle fileHandle = Gdx.files.internal(Gdx.app.getPreferences("spine-skeletonviewer").getString("lastFile", "spineboy/spineboy.json"));
            if (fileHandle.exists()) {
                this.loadSkeleton(fileHandle);
            }
        } else {
            this.loadSkeleton(Gdx.files.internal(args[0]));
        }
        this.ui.loadPrefs();
        this.ui.prefsLoaded = true;
        this.setAnimation(true);
    }

    boolean loadSkeleton(FileHandle fileHandle) {
        Array<String> array;
        if (fileHandle == null) {
            return false;
        }
        try {
            fileHandle = new FileHandle(fileHandle.file().getCanonicalFile());
        }
        catch (Throwable throwable) {
            fileHandle = new FileHandle(fileHandle.file().getAbsoluteFile());
        }
        FileHandle fileHandle2 = this.skeletonFile;
        this.skeletonFile = fileHandle;
        this.reloadTimer = 0.0f;
        try {
            this.atlas = new SkeletonViewerAtlas(this, fileHandle);
            array = fileHandle.extension();
            SkeletonLoader skeletonLoader = ((String)((Object)array)).equalsIgnoreCase("json") || ((String)((Object)array)).equalsIgnoreCase("txt") ? new SkeletonJson(this.atlas) : new SkeletonBinary(this.atlas);
            skeletonLoader.setScale(this.ui.loadScaleSlider.getValue());
            this.skeletonData = skeletonLoader.readSkeletonData(fileHandle);
            if (this.skeletonData.getBones().size == 0) {
                throw new Exception("No bones in skeleton data.");
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error loading skeleton: " + fileHandle.path());
            throwable.printStackTrace();
            this.ui.toast("Error loading skeleton: " + fileHandle.name());
            this.skeletonFile = fileHandle2;
            return false;
        }
        this.skeleton = new Skeleton(this.skeletonData);
        this.skeleton.updateWorldTransform();
        this.skeleton.setToSetupPose();
        this.skeleton = new Skeleton(this.skeleton);
        this.skeleton.updateWorldTransform();
        this.state = new AnimationState(new AnimationStateData(this.skeletonData));
        this.state.addListener(new AnimationState.AnimationStateAdapter(){

            @Override
            public void event(AnimationState.TrackEntry trackEntry, Event event) {
                SkeletonViewer.this.ui.toast(event.getData().getName());
            }
        });
        this.skeletonModified = fileHandle.lastModified();
        this.atlasModified = this.atlas.lastModified();
        this.lastModifiedCheck = 0.25f;
        this.prefs.putString("lastFile", fileHandle.path());
        this.prefs.flush();
        this.ui.window.getTitleLabel().setText(fileHandle.name());
        array = new Array();
        for (Skin object : this.skeletonData.getSkins()) {
            array.add(object.getName());
        }
        this.ui.skinList.setItems(array);
        array = new Array<String>();
        for (Animation animation : this.skeletonData.getAnimations()) {
            array.add(animation.getName());
        }
        this.ui.animationList.setItems(array);
        this.ui.trackButtons.getButtons().first().setChecked(true);
        if (this.ui.skinList.getSelected() != null) {
            this.skeleton.setSkin(this.ui.skinList.getSelected());
        }
        this.setAnimation(true);
        return true;
    }

    void setAnimation(boolean bl) {
        AnimationState.TrackEntry trackEntry;
        if (!this.ui.prefsLoaded) {
            return;
        }
        if (this.ui.animationList.getSelected() == null) {
            return;
        }
        int n = this.ui.trackButtons.getCheckedIndex();
        if (!bl && this.state.getCurrent(n) == null) {
            this.state.setEmptyAnimation(n, 0.0f);
            trackEntry = this.state.addAnimation(n, this.ui.animationList.getSelected(), this.ui.loopCheckbox.isChecked(), 0.0f);
            trackEntry.setMixDuration(this.ui.mixSlider.getValue());
        } else {
            trackEntry = this.state.setAnimation(n, this.ui.animationList.getSelected(), this.ui.loopCheckbox.isChecked());
            trackEntry.setHoldPrevious(n > 0 && this.ui.holdPrevCheckbox.isChecked());
        }
        trackEntry.setMixBlend(n > 0 && this.ui.addCheckbox.isChecked() ? Animation.MixBlend.add : Animation.MixBlend.replace);
        trackEntry.setReverse(this.ui.reverseCheckbox.isChecked());
        trackEntry.setAlpha(this.ui.alphaSlider.getValue());
    }

    @Override
    public void render() {
        AnimationState.TrackEntry trackEntry;
        float f;
        Gdx.gl.glClearColor(0.4392157f, 0.43529412f, 0.4627451f, 1.0f);
        Gdx.gl.glClear(16384);
        float f2 = Gdx.graphics.getDeltaTime();
        this.camera.update();
        this.batch.getProjectionMatrix().set(this.camera.combined);
        this.debugRenderer.getShapeRenderer().setProjectionMatrix(this.camera.combined);
        ShapeRenderer shapeRenderer = this.debugRenderer.getShapeRenderer();
        if (this.state != null) {
            shapeRenderer.setColor(Color.DARK_GRAY);
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            shapeRenderer.line(0.0f, -99999.0f, 0.0f, 99999.0f);
            shapeRenderer.line(-99999.0f, 0.0f, 99999.0f, 0.0f);
            shapeRenderer.end();
        }
        if (this.skeleton != null) {
            if (this.reloadTimer <= 0.0f) {
                this.lastModifiedCheck -= f2;
                if (this.lastModifiedCheck < 0.0f) {
                    this.lastModifiedCheck = 0.25f;
                    long l = this.skeletonFile.lastModified();
                    if (l != 0L && this.skeletonModified != l) {
                        this.reloadTimer = 1.0f;
                    }
                    if ((l = this.atlas.lastModified()) != 0L && this.atlasModified != 0L && this.atlasModified != l) {
                        this.reloadTimer = 1.0f;
                    }
                }
            } else {
                this.reloadTimer -= f2;
                if (this.reloadTimer <= 0.0f && this.loadSkeleton(this.skeletonFile)) {
                    this.ui.toast("Reloaded.");
                }
            }
            this.state.getData().setDefaultMix(this.ui.mixSlider.getValue());
            this.renderer.setPremultipliedAlpha(this.ui.pmaCheckbox.isChecked());
            this.batch.setPremultipliedAlpha(this.ui.pmaCheckbox.isChecked());
            float f3 = this.ui.xScaleSlider.getValue();
            f = this.ui.yScaleSlider.getValue();
            if (this.skeleton.scaleX == 0.0f) {
                this.skeleton.scaleX = 0.01f;
            }
            if (this.skeleton.scaleY == 0.0f) {
                this.skeleton.scaleY = 0.01f;
            }
            this.skeleton.setScale(f3, f);
            if (this.ui.setupPoseButton.isChecked()) {
                this.skeleton.setToSetupPose();
            } else if (this.ui.bonesSetupPoseButton.isChecked()) {
                this.skeleton.setBonesToSetupPose();
            } else if (this.ui.slotsSetupPoseButton.isChecked()) {
                this.skeleton.setSlotsToSetupPose();
            }
            f2 = Math.min(f2, 0.032f) * this.ui.speedSlider.getValue();
            this.state.update(f2);
            this.state.apply(this.skeleton);
            this.skeleton.updateWorldTransform();
            this.batch.begin();
            this.renderer.draw(this.batch, this.skeleton);
            this.batch.end();
            this.debugRenderer.setBones(this.ui.debugBonesCheckbox.isChecked());
            this.debugRenderer.setRegionAttachments(this.ui.debugRegionsCheckbox.isChecked());
            this.debugRenderer.setBoundingBoxes(this.ui.debugBoundingBoxesCheckbox.isChecked());
            this.debugRenderer.setMeshHull(this.ui.debugMeshHullCheckbox.isChecked());
            this.debugRenderer.setMeshTriangles(this.ui.debugMeshTrianglesCheckbox.isChecked());
            this.debugRenderer.setPaths(this.ui.debugPathsCheckbox.isChecked());
            this.debugRenderer.setPoints(this.ui.debugPointsCheckbox.isChecked());
            this.debugRenderer.setClipping(this.ui.debugClippingCheckbox.isChecked());
            this.debugRenderer.draw(this.skeleton);
        }
        if (this.state != null) {
            this.status.setLength(0);
            for (int i = this.state.getTracks().size - 1; i >= 0; --i) {
                AnimationState.TrackEntry trackEntry2 = this.state.getTracks().get(i);
                if (trackEntry2 == null) continue;
                this.status.append(i);
                this.status.append(": [LIGHT_GRAY]");
                this.status(trackEntry2);
                this.status.append("[WHITE]");
                this.status.append(trackEntry2.animation.name);
                this.status.append('\n');
            }
            this.ui.statusLabel.setText(this.status);
        }
        this.ui.render();
        if (this.state != null && (trackEntry = this.state.getCurrent(0)) != null) {
            shapeRenderer.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            shapeRenderer.updateMatrices();
            shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            f = trackEntry.getAnimationTime() / trackEntry.getAnimationEnd();
            float f4 = this.ui.window.getRight() * uiScale + ((float)Gdx.graphics.getWidth() - this.ui.window.getRight() * uiScale) * f;
            shapeRenderer.setColor(Color.CYAN);
            shapeRenderer.line(f4, 0.0f, f4, 12.0f);
            f = trackEntry.getMixDuration() == 0.0f ? 1.0f : Math.min(1.0f, trackEntry.getMixTime() / trackEntry.getMixDuration());
            f4 = this.ui.window.getRight() * uiScale + ((float)Gdx.graphics.getWidth() - this.ui.window.getRight() * uiScale) * f;
            shapeRenderer.setColor(Color.RED);
            shapeRenderer.line(f4, 0.0f, f4, 12.0f);
            shapeRenderer.end();
        }
    }

    void status(AnimationState.TrackEntry trackEntry) {
        AnimationState.TrackEntry trackEntry2 = trackEntry.mixingFrom;
        if (trackEntry2 == null) {
            return;
        }
        this.status(trackEntry2);
        this.status.append(trackEntry2.animation.name);
        this.status.append(' ');
        this.status.append(Math.min(100, (int)(trackEntry.mixTime / trackEntry.mixDuration * 100.0f)));
        this.status.append("% -> ");
    }

    void resetCameraPosition() {
        this.camera.position.x = -this.ui.window.getWidth() / 2.0f * uiScale;
        this.camera.position.y = Gdx.graphics.getHeight() / 4;
    }

    @Override
    public void resize(int n, int n2) {
        float f = this.camera.position.x;
        float f2 = this.camera.position.y;
        this.camera.setToOrtho(false);
        this.camera.position.set(f, f2, 0.0f);
        ((ScreenViewport)this.ui.stage.getViewport()).setUnitsPerPixel(1.0f / uiScale);
        this.ui.stage.getViewport().update(n, n2, true);
        if (!this.ui.minimizeButton.isChecked()) {
            this.ui.window.setHeight((float)n2 / uiScale + 8.0f);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        Runtime.getRuntime().exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        try {
            object3 = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field field = ((Class)object3).getDeclaredField("logger");
            object2 = Class.forName("sun.misc.Unsafe");
            object = ((Class)object2).getDeclaredField("theUnsafe");
            ((Field)object).setAccessible(true);
            Object object4 = ((Field)object).get(null);
            Long l = (Long)((Class)object2).getMethod("staticFieldOffset", Field.class).invoke(object4, field);
            ((Class)object2).getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(object4, object3, l, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        args = stringArray;
        object3 = System.getProperty("os.name");
        float f = 1.0f;
        if (((String)object3).contains("Windows")) {
            f = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0f;
        }
        if (((String)object3).contains("OS X") && (object2 = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor")) instanceof Float && ((Float)object2).intValue() >= 2) {
            f = 2.0f;
        }
        if (f >= 2.0f) {
            uiScale = 2.0f;
        }
        object2 = new SkeletonViewer();
        object = new Lwjgl3ApplicationConfiguration();
        ((Lwjgl3WindowConfiguration)object).setWindowedMode((int)(800.0f * uiScale), (int)(600.0f * uiScale));
        ((Lwjgl3WindowConfiguration)object).setTitle("Skeleton Viewer 4.1.24");
        ((Lwjgl3ApplicationConfiguration)object).setBackBufferConfig(8, 8, 8, 8, 24, 0, 2);
        ((Lwjgl3WindowConfiguration)object).setWindowListener(new Lwjgl3WindowAdapter((SkeletonViewer)object2){
            final /* synthetic */ SkeletonViewer val$skeletonViewer;
            {
                this.val$skeletonViewer = skeletonViewer;
            }

            @Override
            public void filesDropped(String[] stringArray) {
                for (String string : stringArray) {
                    for (String string2 : endSuffixes) {
                        for (String string3 : dataSuffixes) {
                            if (!string.endsWith(string3 + string2) || !this.val$skeletonViewer.loadSkeleton(Gdx.files.absolute(string))) continue;
                            return;
                        }
                    }
                }
            }
        });
        new Lwjgl3Application((ApplicationListener)object2, (Lwjgl3ApplicationConfiguration)object);
    }

    static {
        uiScale = 1.0f;
    }
}

