/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;

public class AnimationState {
    static final Animation emptyAnimation = new Animation("<empty>", new Array<Animation.Timeline>(0), 0.0f);
    private AnimationStateData data;
    final Array<TrackEntry> tracks = new Array();
    private final Array<Event> events = new Array();
    final SnapshotArray<AnimationStateListener> listeners = new SnapshotArray();
    private final EventQueue queue = new EventQueue();
    private final ObjectSet<String> propertyIds = new ObjectSet();
    boolean animationsChanged;
    private float timeScale = 1.0f;
    private int unkeyedState;
    final Pool<TrackEntry> trackEntryPool = new Pool(){

        protected Object newObject() {
            return new TrackEntry();
        }
    };

    public AnimationState() {
    }

    public AnimationState(AnimationStateData animationStateData) {
        if (animationStateData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = animationStateData;
    }

    public void update(float f) {
        f *= this.timeScale;
        T[] TArray = this.tracks.items;
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry;
            TrackEntry trackEntry2 = (TrackEntry)TArray[i];
            if (trackEntry2 == null) continue;
            trackEntry2.animationLast = trackEntry2.nextAnimationLast;
            trackEntry2.trackLast = trackEntry2.nextTrackLast;
            float f2 = f * trackEntry2.timeScale;
            if (trackEntry2.delay > 0.0f) {
                trackEntry2.delay -= f2;
                if (trackEntry2.delay > 0.0f) continue;
                f2 = -trackEntry2.delay;
                trackEntry2.delay = 0.0f;
            }
            if ((trackEntry = trackEntry2.next) != null) {
                float f3 = trackEntry2.trackLast - trackEntry.delay;
                if (f3 >= 0.0f) {
                    trackEntry.delay = 0.0f;
                    trackEntry.trackTime = trackEntry.trackTime + (trackEntry2.timeScale == 0.0f ? 0.0f : (f3 / trackEntry2.timeScale + f) * trackEntry.timeScale);
                    trackEntry2.trackTime += f2;
                    this.setCurrent(i, trackEntry, true);
                    while (trackEntry.mixingFrom != null) {
                        trackEntry.mixTime += f;
                        trackEntry = trackEntry.mixingFrom;
                    }
                    continue;
                }
            } else if (trackEntry2.trackLast >= trackEntry2.trackEnd && trackEntry2.mixingFrom == null) {
                TArray[i] = null;
                this.queue.end(trackEntry2);
                this.clearNext(trackEntry2);
                continue;
            }
            if (trackEntry2.mixingFrom != null && this.updateMixingFrom(trackEntry2, f)) {
                TrackEntry trackEntry3 = trackEntry2.mixingFrom;
                trackEntry2.mixingFrom = null;
                if (trackEntry3 != null) {
                    trackEntry3.mixingTo = null;
                }
                while (trackEntry3 != null) {
                    this.queue.end(trackEntry3);
                    trackEntry3 = trackEntry3.mixingFrom;
                }
            }
            trackEntry2.trackTime += f2;
        }
        this.queue.drain();
    }

    private boolean updateMixingFrom(TrackEntry trackEntry, float f) {
        TrackEntry trackEntry2 = trackEntry.mixingFrom;
        if (trackEntry2 == null) {
            return true;
        }
        boolean bl = this.updateMixingFrom(trackEntry2, f);
        trackEntry2.animationLast = trackEntry2.nextAnimationLast;
        trackEntry2.trackLast = trackEntry2.nextTrackLast;
        if (trackEntry.mixTime > 0.0f && trackEntry.mixTime >= trackEntry.mixDuration) {
            if (trackEntry2.totalAlpha == 0.0f || trackEntry.mixDuration == 0.0f) {
                trackEntry.mixingFrom = trackEntry2.mixingFrom;
                if (trackEntry2.mixingFrom != null) {
                    trackEntry2.mixingFrom.mixingTo = trackEntry;
                }
                trackEntry.interruptAlpha = trackEntry2.interruptAlpha;
                this.queue.end(trackEntry2);
            }
            return bl;
        }
        trackEntry2.trackTime += f * trackEntry2.timeScale;
        trackEntry.mixTime += f;
        return false;
    }

    public boolean apply(Skeleton skeleton) {
        int n;
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (this.animationsChanged) {
            this.animationsChanged();
        }
        Array<Event> array = this.events;
        boolean bl = false;
        T[] TArray = this.tracks.items;
        int n2 = this.tracks.size;
        for (n = 0; n < n2; ++n) {
            float f;
            TrackEntry trackEntry = (TrackEntry)TArray[n];
            if (trackEntry == null || trackEntry.delay > 0.0f) continue;
            bl = true;
            Animation.MixBlend mixBlend = n == 0 ? Animation.MixBlend.first : trackEntry.mixBlend;
            float f2 = trackEntry.alpha;
            if (trackEntry.mixingFrom != null) {
                f2 *= this.applyMixingFrom(trackEntry, skeleton, mixBlend);
            } else if (trackEntry.trackTime >= trackEntry.trackEnd && trackEntry.next == null) {
                f2 = 0.0f;
            }
            float f3 = trackEntry.animationLast;
            float f4 = f = trackEntry.getAnimationTime();
            Array<Event> array2 = array;
            if (trackEntry.reverse) {
                f4 = trackEntry.animation.duration - f4;
                array2 = null;
            }
            int n3 = trackEntry.animation.timelines.size;
            T[] TArray2 = trackEntry.animation.timelines.items;
            if (n == 0 && f2 == 1.0f || mixBlend == Animation.MixBlend.add) {
                for (int i = 0; i < n3; ++i) {
                    Object t = TArray2[i];
                    if (t instanceof Animation.AttachmentTimeline) {
                        this.applyAttachmentTimeline((Animation.AttachmentTimeline)t, skeleton, f4, mixBlend, true);
                        continue;
                    }
                    ((Animation.Timeline)t).apply(skeleton, f3, f4, array2, f2, mixBlend, Animation.MixDirection.in);
                }
            } else {
                boolean bl2;
                int[] nArray = trackEntry.timelineMode.items;
                boolean bl3 = trackEntry.shortestRotation;
                boolean bl4 = bl2 = !bl3 && trackEntry.timelinesRotation.size != n3 << 1;
                if (bl2) {
                    trackEntry.timelinesRotation.setSize(n3 << 1);
                }
                float[] fArray = trackEntry.timelinesRotation.items;
                for (int i = 0; i < n3; ++i) {
                    Animation.MixBlend mixBlend2;
                    Animation.Timeline timeline = (Animation.Timeline)TArray2[i];
                    Animation.MixBlend mixBlend3 = mixBlend2 = nArray[i] == 0 ? mixBlend : Animation.MixBlend.setup;
                    if (!bl3 && timeline instanceof Animation.RotateTimeline) {
                        this.applyRotateTimeline((Animation.RotateTimeline)timeline, skeleton, f4, f2, mixBlend2, fArray, i << 1, bl2);
                        continue;
                    }
                    if (timeline instanceof Animation.AttachmentTimeline) {
                        this.applyAttachmentTimeline((Animation.AttachmentTimeline)timeline, skeleton, f4, mixBlend, true);
                        continue;
                    }
                    timeline.apply(skeleton, f3, f4, array2, f2, mixBlend2, Animation.MixDirection.in);
                }
            }
            this.queueEvents(trackEntry, f);
            array.clear();
            trackEntry.nextAnimationLast = f;
            trackEntry.nextTrackLast = trackEntry.trackTime;
        }
        n = this.unkeyedState + 1;
        T[] TArray3 = skeleton.slots.items;
        int n4 = skeleton.slots.size;
        for (int i = 0; i < n4; ++i) {
            Slot slot = (Slot)TArray3[i];
            if (slot.attachmentState != n) continue;
            String string = slot.data.attachmentName;
            slot.setAttachment(string == null ? null : skeleton.getAttachment(slot.data.index, string));
        }
        this.unkeyedState += 2;
        this.queue.drain();
        return bl;
    }

    private float applyMixingFrom(TrackEntry trackEntry, Skeleton skeleton, Animation.MixBlend mixBlend) {
        float f;
        float f2;
        TrackEntry trackEntry2 = trackEntry.mixingFrom;
        if (trackEntry2.mixingFrom != null) {
            this.applyMixingFrom(trackEntry2, skeleton, mixBlend);
        }
        if (trackEntry.mixDuration == 0.0f) {
            f2 = 1.0f;
            if (mixBlend == Animation.MixBlend.first) {
                mixBlend = Animation.MixBlend.setup;
            }
        } else {
            f2 = trackEntry.mixTime / trackEntry.mixDuration;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            if (mixBlend != Animation.MixBlend.first) {
                mixBlend = trackEntry2.mixBlend;
            }
        }
        boolean bl = f2 < trackEntry2.attachmentThreshold;
        boolean bl2 = f2 < trackEntry2.drawOrderThreshold;
        int n = trackEntry2.animation.timelines.size;
        T[] TArray = trackEntry2.animation.timelines.items;
        float f3 = trackEntry2.alpha * trackEntry.interruptAlpha;
        float f4 = f3 * (1.0f - f2);
        float f5 = trackEntry2.animationLast;
        float f6 = f = trackEntry2.getAnimationTime();
        Array<Event> array = null;
        if (trackEntry2.reverse) {
            f6 = trackEntry2.animation.duration - f6;
        } else if (f2 < trackEntry2.eventThreshold) {
            array = this.events;
        }
        if (mixBlend == Animation.MixBlend.add) {
            for (int i = 0; i < n; ++i) {
                ((Animation.Timeline)TArray[i]).apply(skeleton, f5, f6, array, f4, mixBlend, Animation.MixDirection.out);
            }
        } else {
            boolean bl3;
            int[] nArray = trackEntry2.timelineMode.items;
            T[] TArray2 = trackEntry2.timelineHoldMix.items;
            boolean bl4 = trackEntry2.shortestRotation;
            boolean bl5 = bl3 = !bl4 && trackEntry2.timelinesRotation.size != n << 1;
            if (bl3) {
                trackEntry2.timelinesRotation.setSize(n << 1);
            }
            float[] fArray = trackEntry2.timelinesRotation.items;
            trackEntry2.totalAlpha = 0.0f;
            block7: for (int i = 0; i < n; ++i) {
                float f7;
                Animation.MixBlend mixBlend2;
                Animation.Timeline timeline = (Animation.Timeline)TArray[i];
                Animation.MixDirection mixDirection = Animation.MixDirection.out;
                switch (nArray[i]) {
                    case 0: {
                        if (!bl2 && timeline instanceof Animation.DrawOrderTimeline) continue block7;
                        mixBlend2 = mixBlend;
                        f7 = f4;
                        break;
                    }
                    case 1: {
                        mixBlend2 = Animation.MixBlend.setup;
                        f7 = f4;
                        break;
                    }
                    case 2: {
                        mixBlend2 = mixBlend;
                        f7 = f3;
                        break;
                    }
                    case 3: {
                        mixBlend2 = Animation.MixBlend.setup;
                        f7 = f3;
                        break;
                    }
                    default: {
                        mixBlend2 = Animation.MixBlend.setup;
                        TrackEntry trackEntry3 = (TrackEntry)TArray2[i];
                        f7 = f3 * Math.max(0.0f, 1.0f - trackEntry3.mixTime / trackEntry3.mixDuration);
                    }
                }
                trackEntry2.totalAlpha += f7;
                if (!bl4 && timeline instanceof Animation.RotateTimeline) {
                    this.applyRotateTimeline((Animation.RotateTimeline)timeline, skeleton, f6, f7, mixBlend2, fArray, i << 1, bl3);
                    continue;
                }
                if (timeline instanceof Animation.AttachmentTimeline) {
                    this.applyAttachmentTimeline((Animation.AttachmentTimeline)timeline, skeleton, f6, mixBlend2, bl);
                    continue;
                }
                if (bl2 && timeline instanceof Animation.DrawOrderTimeline && mixBlend2 == Animation.MixBlend.setup) {
                    mixDirection = Animation.MixDirection.in;
                }
                timeline.apply(skeleton, f5, f6, array, f7, mixBlend2, mixDirection);
            }
        }
        if (trackEntry.mixDuration > 0.0f) {
            this.queueEvents(trackEntry2, f);
        }
        this.events.clear();
        trackEntry2.nextAnimationLast = f;
        trackEntry2.nextTrackLast = trackEntry2.trackTime;
        return f2;
    }

    private void applyAttachmentTimeline(Animation.AttachmentTimeline attachmentTimeline, Skeleton skeleton, float f, Animation.MixBlend mixBlend, boolean bl) {
        Slot slot = skeleton.slots.get(attachmentTimeline.slotIndex);
        if (!slot.bone.active) {
            return;
        }
        if (f < attachmentTimeline.frames[0]) {
            if (mixBlend == Animation.MixBlend.setup || mixBlend == Animation.MixBlend.first) {
                this.setAttachment(skeleton, slot, slot.data.attachmentName, bl);
            }
        } else {
            this.setAttachment(skeleton, slot, attachmentTimeline.attachmentNames[Animation.Timeline.search(attachmentTimeline.frames, f)], bl);
        }
        if (slot.attachmentState <= this.unkeyedState) {
            slot.attachmentState = this.unkeyedState + 1;
        }
    }

    private void setAttachment(Skeleton skeleton, Slot slot, String string, boolean bl) {
        slot.setAttachment(string == null ? null : skeleton.getAttachment(slot.data.index, string));
        if (bl) {
            slot.attachmentState = this.unkeyedState + 2;
        }
    }

    private void applyRotateTimeline(Animation.RotateTimeline rotateTimeline, Skeleton skeleton, float f, float f2, Animation.MixBlend mixBlend, float[] fArray, int n, boolean bl) {
        float f3;
        float f4;
        float f5;
        if (bl) {
            fArray[n] = 0.0f;
        }
        if (f2 == 1.0f) {
            rotateTimeline.apply(skeleton, 0.0f, f, null, 1.0f, mixBlend, Animation.MixDirection.in);
            return;
        }
        Bone bone = skeleton.bones.get(rotateTimeline.boneIndex);
        if (!bone.active) {
            return;
        }
        float[] fArray2 = rotateTimeline.frames;
        if (f < fArray2[0]) {
            switch (mixBlend) {
                case setup: {
                    bone.rotation = bone.data.rotation;
                }
                default: {
                    return;
                }
                case first: 
            }
            f5 = bone.rotation;
            f4 = bone.data.rotation;
        } else {
            f5 = mixBlend == Animation.MixBlend.setup ? bone.data.rotation : bone.rotation;
            f4 = bone.data.rotation + rotateTimeline.getCurveValue(f);
        }
        float f6 = f4 - f5;
        f6 -= (float)((16384 - (int)(16384.499999999996 - (double)(f6 / 360.0f))) * 360);
        if (f6 == 0.0f) {
            f3 = fArray[n];
        } else {
            boolean bl2;
            float f7;
            float f8;
            if (bl) {
                f8 = 0.0f;
                f7 = f6;
            } else {
                f8 = fArray[n];
                f7 = fArray[n + 1];
            }
            boolean bl3 = f6 > 0.0f;
            boolean bl4 = bl2 = f8 >= 0.0f;
            if (Math.signum(f7) != Math.signum(f6) && Math.abs(f7) <= 90.0f) {
                if (Math.abs(f8) > 180.0f) {
                    f8 += 360.0f * Math.signum(f8);
                }
                bl2 = bl3;
            }
            f3 = f6 + f8 - f8 % 360.0f;
            if (bl2 != bl3) {
                f3 += 360.0f * Math.signum(f8);
            }
            fArray[n] = f3;
        }
        fArray[n + 1] = f6;
        bone.rotation = f5 + f3 * f2;
    }

    private void queueEvents(TrackEntry trackEntry, float f) {
        boolean bl;
        int n;
        float f2 = trackEntry.animationStart;
        float f3 = trackEntry.animationEnd;
        float f4 = f3 - f2;
        float f5 = trackEntry.trackLast % f4;
        T[] TArray = this.events.items;
        int n2 = this.events.size;
        for (n = 0; n < n2; ++n) {
            Event event = (Event)TArray[n];
            if (event.time < f5) break;
            if (event.time > f3) continue;
            this.queue.event(trackEntry, event);
        }
        if (trackEntry.loop) {
            bl = f4 == 0.0f || f5 > trackEntry.trackTime % f4;
        } else {
            boolean bl2 = bl = f >= f3 && trackEntry.animationLast < f3;
        }
        if (bl) {
            this.queue.complete(trackEntry);
        }
        while (n < n2) {
            Event event = (Event)TArray[n];
            if (!(event.time < f2)) {
                this.queue.event(trackEntry, event);
            }
            ++n;
        }
    }

    private void setCurrent(int n, TrackEntry trackEntry, boolean bl) {
        TrackEntry trackEntry2 = this.expandToIndex(n);
        this.tracks.set(n, trackEntry);
        trackEntry.previous = null;
        if (trackEntry2 != null) {
            if (bl) {
                this.queue.interrupt(trackEntry2);
            }
            trackEntry.mixingFrom = trackEntry2;
            trackEntry2.mixingTo = trackEntry;
            trackEntry.mixTime = 0.0f;
            if (trackEntry2.mixingFrom != null && trackEntry2.mixDuration > 0.0f) {
                trackEntry.interruptAlpha *= Math.min(1.0f, trackEntry2.mixTime / trackEntry2.mixDuration);
            }
            trackEntry2.timelinesRotation.clear();
        }
        this.queue.start(trackEntry);
    }

    public TrackEntry setAnimation(int n, String string, boolean bl) {
        Animation animation = this.data.skeletonData.findAnimation(string);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + string);
        }
        return this.setAnimation(n, animation, bl);
    }

    public TrackEntry setAnimation(int n, Animation animation, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("trackIndex must be >= 0.");
        }
        if (animation == null) {
            throw new IllegalArgumentException("animation cannot be null.");
        }
        boolean bl2 = true;
        TrackEntry trackEntry = this.expandToIndex(n);
        if (trackEntry != null) {
            if (trackEntry.nextTrackLast == -1.0f) {
                this.tracks.set(n, trackEntry.mixingFrom);
                this.queue.interrupt(trackEntry);
                this.queue.end(trackEntry);
                this.clearNext(trackEntry);
                trackEntry = trackEntry.mixingFrom;
                bl2 = false;
            } else {
                this.clearNext(trackEntry);
            }
        }
        TrackEntry trackEntry2 = this.trackEntry(n, animation, bl, trackEntry);
        this.setCurrent(n, trackEntry2, bl2);
        this.queue.drain();
        return trackEntry2;
    }

    public TrackEntry addAnimation(int n, String string, boolean bl, float f) {
        Animation animation = this.data.skeletonData.findAnimation(string);
        if (animation == null) {
            throw new IllegalArgumentException("Animation not found: " + string);
        }
        return this.addAnimation(n, animation, bl, f);
    }

    public TrackEntry addAnimation(int n, Animation animation, boolean bl, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("trackIndex must be >= 0.");
        }
        if (animation == null) {
            throw new IllegalArgumentException("animation cannot be null.");
        }
        TrackEntry trackEntry = this.expandToIndex(n);
        if (trackEntry != null) {
            while (trackEntry.next != null) {
                trackEntry = trackEntry.next;
            }
        }
        TrackEntry trackEntry2 = this.trackEntry(n, animation, bl, trackEntry);
        if (trackEntry == null) {
            this.setCurrent(n, trackEntry2, true);
            this.queue.drain();
        } else {
            trackEntry.next = trackEntry2;
            trackEntry2.previous = trackEntry;
            if (f <= 0.0f) {
                f += trackEntry.getTrackComplete() - trackEntry2.mixDuration;
            }
        }
        trackEntry2.delay = f;
        return trackEntry2;
    }

    public TrackEntry setEmptyAnimation(int n, float f) {
        TrackEntry trackEntry = this.setAnimation(n, emptyAnimation, false);
        trackEntry.mixDuration = f;
        trackEntry.trackEnd = f;
        return trackEntry;
    }

    private TrackEntry expandToIndex(int n) {
        if (n < this.tracks.size) {
            return this.tracks.get(n);
        }
        this.tracks.ensureCapacity(n - this.tracks.size + 1);
        this.tracks.size = n + 1;
        return null;
    }

    private TrackEntry trackEntry(int n, Animation animation, boolean bl, TrackEntry trackEntry) {
        TrackEntry trackEntry2 = this.trackEntryPool.obtain();
        trackEntry2.trackIndex = n;
        trackEntry2.animation = animation;
        trackEntry2.loop = bl;
        trackEntry2.holdPrevious = false;
        trackEntry2.reverse = false;
        trackEntry2.shortestRotation = false;
        trackEntry2.eventThreshold = 0.0f;
        trackEntry2.attachmentThreshold = 0.0f;
        trackEntry2.drawOrderThreshold = 0.0f;
        trackEntry2.animationStart = 0.0f;
        trackEntry2.animationEnd = animation.getDuration();
        trackEntry2.animationLast = -1.0f;
        trackEntry2.nextAnimationLast = -1.0f;
        trackEntry2.delay = 0.0f;
        trackEntry2.trackTime = 0.0f;
        trackEntry2.trackLast = -1.0f;
        trackEntry2.nextTrackLast = -1.0f;
        trackEntry2.trackEnd = Float.MAX_VALUE;
        trackEntry2.timeScale = 1.0f;
        trackEntry2.alpha = 1.0f;
        trackEntry2.mixTime = 0.0f;
        trackEntry2.mixDuration = trackEntry == null ? 0.0f : this.data.getMix(trackEntry.animation, animation);
        trackEntry2.interruptAlpha = 1.0f;
        trackEntry2.totalAlpha = 0.0f;
        trackEntry2.mixBlend = Animation.MixBlend.replace;
        return trackEntry2;
    }

    public void clearNext(TrackEntry trackEntry) {
        TrackEntry trackEntry2 = trackEntry.next;
        while (trackEntry2 != null) {
            this.queue.dispose(trackEntry2);
            trackEntry2 = trackEntry2.next;
        }
        trackEntry.next = null;
    }

    void animationsChanged() {
        this.animationsChanged = false;
        this.propertyIds.clear(2048);
        int n = this.tracks.size;
        T[] TArray = this.tracks.items;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry = (TrackEntry)TArray[i];
            if (trackEntry == null) continue;
            while (trackEntry.mixingFrom != null) {
                trackEntry = trackEntry.mixingFrom;
            }
            do {
                if (trackEntry.mixingTo != null && trackEntry.mixBlend == Animation.MixBlend.add) continue;
                this.computeHold(trackEntry);
            } while ((trackEntry = trackEntry.mixingTo) != null);
        }
    }

    private void computeHold(TrackEntry trackEntry) {
        TrackEntry trackEntry2 = trackEntry.mixingTo;
        T[] TArray = trackEntry.animation.timelines.items;
        int n = trackEntry.animation.timelines.size;
        int[] nArray = trackEntry.timelineMode.setSize(n);
        trackEntry.timelineHoldMix.clear();
        TrackEntry[] trackEntryArray = trackEntry.timelineHoldMix.setSize(n);
        ObjectSet<String> objectSet = this.propertyIds;
        if (trackEntry2 != null && trackEntry2.holdPrevious) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = objectSet.addAll((String[])((Animation.Timeline)TArray[i]).getPropertyIds()) ? 3 : 2;
            }
            return;
        }
        block1: for (int i = 0; i < n; ++i) {
            Animation.Timeline timeline = (Animation.Timeline)TArray[i];
            String[] stringArray = timeline.getPropertyIds();
            if (!objectSet.addAll((String[])stringArray)) {
                nArray[i] = 0;
                continue;
            }
            if (trackEntry2 == null || timeline instanceof Animation.AttachmentTimeline || timeline instanceof Animation.DrawOrderTimeline || timeline instanceof Animation.EventTimeline || !trackEntry2.animation.hasTimeline(stringArray)) {
                nArray[i] = 1;
                continue;
            }
            TrackEntry trackEntry3 = trackEntry2.mixingTo;
            while (trackEntry3 != null) {
                if (!trackEntry3.animation.hasTimeline(stringArray)) {
                    if (!(trackEntry3.mixDuration > 0.0f)) break;
                    nArray[i] = 4;
                    trackEntryArray[i] = trackEntry3;
                    continue block1;
                }
                trackEntry3 = trackEntry3.mixingTo;
            }
            nArray[i] = 3;
        }
    }

    public TrackEntry getCurrent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("trackIndex must be >= 0.");
        }
        if (n >= this.tracks.size) {
            return null;
        }
        return this.tracks.get(n);
    }

    public void addListener(AnimationStateListener animationStateListener) {
        if (animationStateListener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        this.listeners.add(animationStateListener);
    }

    public AnimationStateData getData() {
        return this.data;
    }

    public Array<TrackEntry> getTracks() {
        return this.tracks;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        T[] TArray = this.tracks.items;
        int n = this.tracks.size;
        for (int i = 0; i < n; ++i) {
            TrackEntry trackEntry = (TrackEntry)TArray[i];
            if (trackEntry == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(trackEntry.toString());
        }
        if (stringBuilder.length() == 0) {
            return "<none>";
        }
        return stringBuilder.toString();
    }

    class EventQueue {
        private final Array objects = new Array();
        boolean drainDisabled;

        EventQueue() {
        }

        void start(TrackEntry trackEntry) {
            this.objects.add(EventType.start);
            this.objects.add(trackEntry);
            AnimationState.this.animationsChanged = true;
        }

        void interrupt(TrackEntry trackEntry) {
            this.objects.add(EventType.interrupt);
            this.objects.add(trackEntry);
        }

        void end(TrackEntry trackEntry) {
            this.objects.add(EventType.end);
            this.objects.add(trackEntry);
            AnimationState.this.animationsChanged = true;
        }

        void dispose(TrackEntry trackEntry) {
            this.objects.add(EventType.dispose);
            this.objects.add(trackEntry);
        }

        void complete(TrackEntry trackEntry) {
            this.objects.add(EventType.complete);
            this.objects.add(trackEntry);
        }

        void event(TrackEntry trackEntry, Event event) {
            this.objects.add(EventType.event);
            this.objects.add(trackEntry);
            this.objects.add(event);
        }

        void drain() {
            if (this.drainDisabled) {
                return;
            }
            this.drainDisabled = true;
            SnapshotArray<AnimationStateListener> snapshotArray = AnimationState.this.listeners;
            for (int i = 0; i < this.objects.size; i += 2) {
                EventType eventType = (EventType)((Object)this.objects.get(i));
                TrackEntry trackEntry = (TrackEntry)this.objects.get(i + 1);
                int n = snapshotArray.size;
                AnimationStateListener[] animationStateListenerArray = snapshotArray.begin();
                switch (eventType) {
                    case start: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.start(trackEntry);
                        }
                        for (int j = 0; j < n; ++j) {
                            animationStateListenerArray[j].start(trackEntry);
                        }
                        break;
                    }
                    case interrupt: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.interrupt(trackEntry);
                        }
                        for (int j = 0; j < n; ++j) {
                            animationStateListenerArray[j].interrupt(trackEntry);
                        }
                        break;
                    }
                    case end: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.end(trackEntry);
                        }
                        for (int j = 0; j < n; ++j) {
                            animationStateListenerArray[j].end(trackEntry);
                        }
                    }
                    case dispose: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.dispose(trackEntry);
                        }
                        for (int j = 0; j < n; ++j) {
                            animationStateListenerArray[j].dispose(trackEntry);
                        }
                        AnimationState.this.trackEntryPool.free(trackEntry);
                        break;
                    }
                    case complete: {
                        if (trackEntry.listener != null) {
                            trackEntry.listener.complete(trackEntry);
                        }
                        for (int j = 0; j < n; ++j) {
                            animationStateListenerArray[j].complete(trackEntry);
                        }
                        break;
                    }
                    case event: {
                        Event event = (Event)this.objects.get(i++ + 2);
                        if (trackEntry.listener != null) {
                            trackEntry.listener.event(trackEntry, event);
                        }
                        for (int j = 0; j < n; ++j) {
                            animationStateListenerArray[j].event(trackEntry, event);
                        }
                        break;
                    }
                }
                snapshotArray.end();
            }
            this.clear();
            this.drainDisabled = false;
        }

        void clear() {
            this.objects.clear();
        }
    }

    public static class TrackEntry
    implements Pool.Poolable {
        Animation animation;
        TrackEntry previous;
        TrackEntry next;
        TrackEntry mixingFrom;
        TrackEntry mixingTo;
        AnimationStateListener listener;
        int trackIndex;
        boolean loop;
        boolean holdPrevious;
        boolean reverse;
        boolean shortestRotation;
        float eventThreshold;
        float attachmentThreshold;
        float drawOrderThreshold;
        float animationStart;
        float animationEnd;
        float animationLast;
        float nextAnimationLast;
        float delay;
        float trackTime;
        float trackLast;
        float nextTrackLast;
        float trackEnd;
        float timeScale;
        float alpha;
        float mixTime;
        float mixDuration;
        float interruptAlpha;
        float totalAlpha;
        Animation.MixBlend mixBlend = Animation.MixBlend.replace;
        final IntArray timelineMode = new IntArray();
        final Array<TrackEntry> timelineHoldMix = new Array();
        final FloatArray timelinesRotation = new FloatArray();

        @Override
        public void reset() {
            this.previous = null;
            this.next = null;
            this.mixingFrom = null;
            this.mixingTo = null;
            this.animation = null;
            this.listener = null;
            this.timelineMode.clear();
            this.timelineHoldMix.clear();
            this.timelinesRotation.clear();
        }

        public boolean getLoop() {
            return this.loop;
        }

        public float getTrackComplete() {
            float f = this.animationEnd - this.animationStart;
            if (f != 0.0f) {
                if (this.loop) {
                    return f * (float)(1 + (int)(this.trackTime / f));
                }
                if (this.trackTime < f) {
                    return f;
                }
            }
            return this.trackTime;
        }

        public float getAnimationEnd() {
            return this.animationEnd;
        }

        public float getAnimationTime() {
            if (this.loop) {
                float f = this.animationEnd - this.animationStart;
                if (f == 0.0f) {
                    return this.animationStart;
                }
                return this.trackTime % f + this.animationStart;
            }
            float f = this.trackTime + this.animationStart;
            return this.animationEnd >= this.animation.duration ? f : Math.min(f, this.animationEnd);
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public float getMixTime() {
            return this.mixTime;
        }

        public float getMixDuration() {
            return this.mixDuration;
        }

        public void setMixDuration(float f) {
            this.mixDuration = f;
        }

        public Animation.MixBlend getMixBlend() {
            return this.mixBlend;
        }

        public void setMixBlend(Animation.MixBlend mixBlend) {
            if (mixBlend == null) {
                throw new IllegalArgumentException("mixBlend cannot be null.");
            }
            this.mixBlend = mixBlend;
        }

        public void setHoldPrevious(boolean bl) {
            this.holdPrevious = bl;
        }

        public boolean getHoldPrevious() {
            return this.holdPrevious;
        }

        public void resetRotationDirections() {
            this.timelinesRotation.clear();
        }

        public void setReverse(boolean bl) {
            this.reverse = bl;
        }

        public boolean getReverse() {
            return this.reverse;
        }

        public String toString() {
            return this.animation == null ? "<none>" : this.animation.name;
        }
    }

    public static abstract class AnimationStateAdapter
    implements AnimationStateListener {
        @Override
        public void start(TrackEntry trackEntry) {
        }

        @Override
        public void interrupt(TrackEntry trackEntry) {
        }

        @Override
        public void end(TrackEntry trackEntry) {
        }

        @Override
        public void dispose(TrackEntry trackEntry) {
        }

        @Override
        public void complete(TrackEntry trackEntry) {
        }

        @Override
        public void event(TrackEntry trackEntry, Event event) {
        }
    }

    public static interface AnimationStateListener {
        public void start(TrackEntry var1);

        public void interrupt(TrackEntry var1);

        public void end(TrackEntry var1);

        public void dispose(TrackEntry var1);

        public void complete(TrackEntry var1);

        public void event(TrackEntry var1, Event var2);
    }

    private static enum EventType {
        start,
        interrupt,
        end,
        dispose,
        complete,
        event;

    }
}

