/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.files;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class FileHandle {
    protected File file;
    protected Files.FileType type;

    protected FileHandle() {
    }

    public FileHandle(String fileName) {
        this.file = new File(fileName);
        this.type = Files.FileType.Absolute;
    }

    public FileHandle(File file) {
        this.file = file;
        this.type = Files.FileType.Absolute;
    }

    protected FileHandle(String fileName, Files.FileType type) {
        this.type = type;
        this.file = new File(fileName);
    }

    protected FileHandle(File file, Files.FileType type) {
        this.file = file;
        this.type = type;
    }

    public String path() {
        return this.file.getPath().replace('\\', '/');
    }

    public String name() {
        return this.file.getName();
    }

    public String extension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex + 1);
    }

    public String nameWithoutExtension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public Files.FileType type() {
        return this.type;
    }

    public File file() {
        if (this.type == Files.FileType.External) {
            return new File(Gdx.files.getExternalStoragePath(), this.file.getPath());
        }
        return this.file;
    }

    public InputStream read() {
        if (this.type == Files.FileType.Classpath || this.type == Files.FileType.Internal && !this.file().exists() || this.type == Files.FileType.Local && !this.file().exists()) {
            InputStream input = FileHandle.class.getResourceAsStream("/" + this.file.getPath().replace('\\', '/'));
            if (input == null) {
                throw new GdxRuntimeException("File not found: " + this.file + " (" + (Object)((Object)this.type) + ")");
            }
            return input;
        }
        try {
            return new FileInputStream(this.file());
        }
        catch (Exception ex) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new GdxRuntimeException("Error reading file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public Reader reader(String charset) {
        InputStream stream = this.read();
        try {
            return new InputStreamReader(stream, charset);
        }
        catch (UnsupportedEncodingException ex) {
            StreamUtils.closeQuietly(stream);
            throw new GdxRuntimeException("Error reading file: " + this, ex);
        }
    }

    public BufferedReader reader(int bufferSize) {
        return new BufferedReader(new InputStreamReader(this.read()), bufferSize);
    }

    public byte[] readBytes() {
        InputStream input = this.read();
        try {
            byte[] byArray = StreamUtils.copyStreamToByteArray(input, this.estimateLength());
            return byArray;
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error reading file: " + this, ex);
        }
        finally {
            StreamUtils.closeQuietly(input);
        }
    }

    private int estimateLength() {
        int length = (int)this.length();
        return length != 0 ? length : 512;
    }

    public OutputStream write(boolean append) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            return new FileOutputStream(this.file(), append);
        }
        catch (Exception ex) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public Writer writer(boolean append, String charset) {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            FileOutputStream output = new FileOutputStream(this.file(), append);
            if (charset == null) {
                return new OutputStreamWriter(output);
            }
            return new OutputStreamWriter((OutputStream)output, charset);
        }
        catch (IOException ex) {
            if (this.file().isDirectory()) {
                throw new GdxRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new GdxRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public FileHandle child(String name) {
        if (this.file.getPath().length() == 0) {
            return new FileHandle(new File(name), this.type);
        }
        return new FileHandle(new File(this.file, name), this.type);
    }

    public FileHandle sibling(String name) {
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return new FileHandle(new File(this.file.getParent(), name), this.type);
    }

    public FileHandle parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            parent = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new FileHandle(parent, this.type);
    }

    public void mkdirs() {
        if (this.type == Files.FileType.Classpath) {
            throw new GdxRuntimeException("Cannot mkdirs with a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.Internal) {
            throw new GdxRuntimeException("Cannot mkdirs with an internal file: " + this.file);
        }
        this.file().mkdirs();
    }

    public boolean exists() {
        switch (this.type) {
            case Internal: {
                if (this.file().exists()) {
                    return true;
                }
            }
            case Classpath: {
                return FileHandle.class.getResource("/" + this.file.getPath().replace('\\', '/')) != null;
            }
        }
        return this.file().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        if (this.type == Files.FileType.Classpath || this.type == Files.FileType.Internal && !this.file.exists()) {
            InputStream input = this.read();
            try {
                long l = input.available();
                return l;
            }
            catch (Exception exception) {
            }
            finally {
                StreamUtils.closeQuietly(input);
            }
            return 0L;
        }
        return this.file().length();
    }

    public long lastModified() {
        return this.file().lastModified();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileHandle)) {
            return false;
        }
        FileHandle other = (FileHandle)obj;
        return this.type == other.type && this.path().equals(other.path());
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + this.type.hashCode();
        hash = hash * 67 + this.path().hashCode();
        return hash;
    }

    public String toString() {
        return this.file.getPath().replace('\\', '/');
    }
}

