/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.backends.lwjgl3.audio.Lwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.Mp3;
import com.badlogic.gdx.backends.lwjgl3.audio.Ogg;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALMusic;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALSound;
import com.badlogic.gdx.backends.lwjgl3.audio.Wav;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALUtil;
import org.lwjgl.openal.SOFTReopenDevice;

public class OpenALLwjgl3Audio
implements Lwjgl3Audio {
    private final int deviceBufferSize;
    private final int deviceBufferCount;
    private IntArray idleSources;
    private IntArray allSources;
    private LongMap<Integer> soundIdToSource;
    private IntMap<Long> sourceToSoundId;
    private long nextSoundId = 0L;
    private ObjectMap<String, Class<? extends OpenALSound>> extensionToSoundClass = new ObjectMap();
    private ObjectMap<String, Class<? extends OpenALMusic>> extensionToMusicClass = new ObjectMap();
    private OpenALSound[] recentSounds;
    private int mostRecetSound = -1;
    private String preferredOutputDevice = null;
    private Thread observerThread;
    Array<OpenALMusic> music = new Array(false, 1, OpenALMusic.class);
    long device;
    long context;
    boolean noDevice = false;

    public OpenALLwjgl3Audio() {
        this(16, 9, 512);
    }

    public OpenALLwjgl3Audio(int simultaneousSources, int deviceBufferCount, int deviceBufferSize) {
        this.deviceBufferSize = deviceBufferSize;
        this.deviceBufferCount = deviceBufferCount;
        this.registerSound("ogg", Ogg.Sound.class);
        this.registerMusic("ogg", Ogg.Music.class);
        this.registerSound("wav", Wav.Sound.class);
        this.registerMusic("wav", Wav.Music.class);
        this.registerSound("mp3", Mp3.Sound.class);
        this.registerMusic("mp3", Mp3.Music.class);
        this.device = ALC10.alcOpenDevice((ByteBuffer)null);
        if (this.device == 0L) {
            this.noDevice = true;
            return;
        }
        ALCCapabilities deviceCapabilities = ALC.createCapabilities((long)this.device);
        this.context = ALC10.alcCreateContext((long)this.device, (IntBuffer)null);
        if (this.context == 0L) {
            ALC10.alcCloseDevice((long)this.device);
            this.noDevice = true;
            return;
        }
        if (!ALC10.alcMakeContextCurrent((long)this.context)) {
            this.noDevice = true;
            return;
        }
        AL.createCapabilities((ALCCapabilities)deviceCapabilities);
        AL10.alGetError();
        this.allSources = new IntArray(false, simultaneousSources);
        for (int i = 0; i < simultaneousSources; ++i) {
            int sourceID = AL10.alGenSources();
            if (AL10.alGetError() != 0) break;
            this.allSources.add(sourceID);
        }
        this.idleSources = new IntArray(this.allSources);
        this.soundIdToSource = new LongMap();
        this.sourceToSoundId = new IntMap();
        FloatBuffer orientation = BufferUtils.createFloatBuffer(6).put(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f});
        ((Buffer)orientation).flip();
        AL10.alListenerfv((int)4111, (FloatBuffer)orientation);
        FloatBuffer velocity = BufferUtils.createFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f});
        ((Buffer)velocity).flip();
        AL10.alListenerfv((int)4102, (FloatBuffer)velocity);
        FloatBuffer position = BufferUtils.createFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f});
        ((Buffer)position).flip();
        AL10.alListenerfv((int)4100, (FloatBuffer)position);
        AL10.alDisable((int)6571);
        this.observerThread = new Thread(new Runnable(){
            private String[] lastAvailableDevices = new String[0];

            @Override
            public void run() {
                while (true) {
                    boolean isConnected;
                    boolean bl = isConnected = ALC10.alcGetInteger((long)OpenALLwjgl3Audio.this.device, (int)787) != 0;
                    if (!isConnected) {
                        OpenALLwjgl3Audio.this.switchOutputDevice(null, false);
                        continue;
                    }
                    if (OpenALLwjgl3Audio.this.preferredOutputDevice != null) {
                        if (Arrays.asList(OpenALLwjgl3Audio.this.getAvailableOutputDevices()).contains(OpenALLwjgl3Audio.this.preferredOutputDevice)) {
                            if (!OpenALLwjgl3Audio.this.preferredOutputDevice.equals(ALC10.alcGetString((long)OpenALLwjgl3Audio.this.device, (int)4115))) {
                                OpenALLwjgl3Audio.this.switchOutputDevice(OpenALLwjgl3Audio.this.preferredOutputDevice);
                            }
                        } else if (OpenALLwjgl3Audio.this.preferredOutputDevice.equals(ALC10.alcGetString((long)OpenALLwjgl3Audio.this.device, (int)4115))) {
                            OpenALLwjgl3Audio.this.switchOutputDevice(null, false);
                        }
                    } else {
                        Object[] currentDevices = OpenALLwjgl3Audio.this.getAvailableOutputDevices();
                        if (!Arrays.equals(currentDevices, this.lastAvailableDevices)) {
                            OpenALLwjgl3Audio.this.switchOutputDevice(null);
                        }
                        this.lastAvailableDevices = currentDevices;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        return;
                    }
                }
            }
        });
        this.observerThread.setDaemon(true);
        this.observerThread.start();
        this.recentSounds = new OpenALSound[simultaneousSources];
    }

    public void registerSound(String extension, Class<? extends OpenALSound> soundClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (soundClass == null) {
            throw new IllegalArgumentException("soundClass cannot be null.");
        }
        this.extensionToSoundClass.put(extension, soundClass);
    }

    public void registerMusic(String extension, Class<? extends OpenALMusic> musicClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (musicClass == null) {
            throw new IllegalArgumentException("musicClass cannot be null.");
        }
        this.extensionToMusicClass.put(extension, musicClass);
    }

    public boolean switchOutputDevice(String deviceIdentifier) {
        return this.switchOutputDevice(deviceIdentifier, true);
    }

    private boolean switchOutputDevice(String deviceIdentifier, boolean setPreferred) {
        if (setPreferred) {
            this.preferredOutputDevice = deviceIdentifier;
        }
        return SOFTReopenDevice.alcReopenDeviceSOFT((long)this.device, (CharSequence)deviceIdentifier, (IntBuffer)null);
    }

    public String[] getAvailableOutputDevices() {
        List devices = ALUtil.getStringList((long)0L, (int)4115);
        if (devices == null) {
            return new String[0];
        }
        return devices.toArray(new String[0]);
    }

    void freeSource(int sourceID) {
        if (this.noDevice) {
            return;
        }
        AL10.alSourceStop((int)sourceID);
        AL10.alSourcei((int)sourceID, (int)4105, (int)0);
        Long soundId = this.sourceToSoundId.remove(sourceID);
        if (soundId != null) {
            this.soundIdToSource.remove(soundId);
        }
        this.idleSources.add(sourceID);
    }

    void freeBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL10.alGetSourcei((int)sourceID, (int)4105) != bufferID) continue;
            Long soundId = this.sourceToSoundId.remove(sourceID);
            if (soundId != null) {
                this.soundIdToSource.remove(soundId);
            }
            AL10.alSourceStop((int)sourceID);
            AL10.alSourcei((int)sourceID, (int)4105, (int)0);
        }
    }

    @Override
    public void update() {
        if (this.noDevice) {
            return;
        }
        for (int i = 0; i < this.music.size; ++i) {
            ((OpenALMusic[])this.music.items)[i].update();
        }
    }

    @Override
    public void dispose() {
        if (this.noDevice) {
            return;
        }
        this.observerThread.interrupt();
        int n = this.allSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.allSources.get(i);
            int state = AL10.alGetSourcei((int)sourceID, (int)4112);
            if (state != 4116) {
                AL10.alSourceStop((int)sourceID);
            }
            AL10.alDeleteSources((int)sourceID);
        }
        this.sourceToSoundId = null;
        this.soundIdToSource = null;
        ALC10.alcDestroyContext((long)this.context);
        ALC10.alcCloseDevice((long)this.device);
    }

    public void forget(OpenALSound sound) {
        for (int i = 0; i < this.recentSounds.length; ++i) {
            if (this.recentSounds[i] != sound) continue;
            this.recentSounds[i] = null;
        }
    }
}

