/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;

public class BufferChecks {
    public static void checkFunctionAddress(long pointer) {
        if (LWJGLUtil.CHECKS && pointer == 0L) {
            throw new IllegalStateException("Function is not supported");
        }
    }

    public static void checkDirect(ByteBuffer buf) {
        if (LWJGLUtil.CHECKS && !buf.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer is not direct");
        }
    }

    public static void checkDirect(ShortBuffer buf) {
        if (LWJGLUtil.CHECKS && !buf.isDirect()) {
            throw new IllegalArgumentException("ShortBuffer is not direct");
        }
    }

    public static void checkDirect(IntBuffer buf) {
        if (LWJGLUtil.CHECKS && !buf.isDirect()) {
            throw new IllegalArgumentException("IntBuffer is not direct");
        }
    }

    public static void checkDirect(FloatBuffer buf) {
        if (LWJGLUtil.CHECKS && !buf.isDirect()) {
            throw new IllegalArgumentException("FloatBuffer is not direct");
        }
    }

    public static void checkDirect(DoubleBuffer buf) {
        if (LWJGLUtil.CHECKS && !buf.isDirect()) {
            throw new IllegalArgumentException("DoubleBuffer is not direct");
        }
    }

    private static void throwBufferSizeException(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size + ". Because at most " + size + " elements can be returned, a buffer with at least " + size + " elements is required, regardless of actual returned element count");
    }

    public static void checkBufferSize(Buffer buf, int size) {
        if (LWJGLUtil.CHECKS && buf.remaining() < size) {
            BufferChecks.throwBufferSizeException(buf, size);
        }
    }

    public static void checkBuffer(ByteBuffer buf, int size) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(buf, size);
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkBuffer(ShortBuffer buf, int size) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(buf, size);
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkBuffer(IntBuffer buf, int size) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(buf, size);
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkBuffer(FloatBuffer buf, int size) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(buf, size);
            BufferChecks.checkDirect(buf);
        }
    }

    public static void checkBuffer(DoubleBuffer buf, int size) {
        if (LWJGLUtil.CHECKS) {
            BufferChecks.checkBufferSize(buf, size);
            BufferChecks.checkDirect(buf);
        }
    }
}

