/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Skeleton {
    final SkeletonData data;
    final Array<Bone> bones;
    final Array<Slot> slots;
    Array<Slot> drawOrder;
    final Array<IkConstraint> ikConstraints;
    final Array<TransformConstraint> transformConstraints;
    final Array<PathConstraint> pathConstraints;
    final Array<Updatable> updateCache = new Array();
    final Array<Bone> updateCacheReset = new Array();
    Skin skin;
    final Color color;
    float time;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float x;
    float y;

    public Skeleton(SkeletonData skeletonData) {
        Object object;
        Bone bone;
        if (skeletonData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = skeletonData;
        this.bones = new Array(skeletonData.bones.size);
        for (BoneData object2 : skeletonData.bones) {
            if (object2.parent == null) {
                bone = new Bone(object2, this, null);
            } else {
                object = this.bones.get(object2.parent.index);
                bone = new Bone(object2, this, (Bone)object);
                ((Bone)object).children.add(bone);
            }
            this.bones.add(bone);
        }
        this.slots = new Array(skeletonData.slots.size);
        this.drawOrder = new Array(skeletonData.slots.size);
        for (SlotData slotData : skeletonData.slots) {
            bone = this.bones.get(slotData.boneData.index);
            object = new Slot(slotData, bone);
            this.slots.add((Slot)object);
            this.drawOrder.add((Slot)object);
        }
        this.ikConstraints = new Array(skeletonData.ikConstraints.size);
        for (IkConstraintData ikConstraintData : skeletonData.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraintData, this));
        }
        this.transformConstraints = new Array(skeletonData.transformConstraints.size);
        for (TransformConstraintData transformConstraintData : skeletonData.transformConstraints) {
            this.transformConstraints.add(new TransformConstraint(transformConstraintData, this));
        }
        this.pathConstraints = new Array(skeletonData.pathConstraints.size);
        for (PathConstraintData pathConstraintData : skeletonData.pathConstraints) {
            this.pathConstraints.add(new PathConstraint(pathConstraintData, this));
        }
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.updateCache();
    }

    public Skeleton(Skeleton skeleton) {
        Bone bone;
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = skeleton.data;
        this.bones = new Array(skeleton.bones.size);
        for (Bone object : skeleton.bones) {
            if (object.parent == null) {
                bone = new Bone(object, this, null);
            } else {
                Bone bone2 = this.bones.get(object.parent.data.index);
                bone = new Bone(object, this, bone2);
                bone2.children.add(bone);
            }
            this.bones.add(bone);
        }
        this.slots = new Array(skeleton.slots.size);
        for (Slot slot : skeleton.slots) {
            bone = this.bones.get(slot.bone.data.index);
            this.slots.add(new Slot(slot, bone));
        }
        this.drawOrder = new Array(this.slots.size);
        for (Slot slot : skeleton.drawOrder) {
            this.drawOrder.add(this.slots.get(slot.data.index));
        }
        this.ikConstraints = new Array(skeleton.ikConstraints.size);
        for (IkConstraint ikConstraint : skeleton.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraint, this));
        }
        this.transformConstraints = new Array(skeleton.transformConstraints.size);
        for (TransformConstraint transformConstraint : skeleton.transformConstraints) {
            this.transformConstraints.add(new TransformConstraint(transformConstraint, this));
        }
        this.pathConstraints = new Array(skeleton.pathConstraints.size);
        for (PathConstraint pathConstraint : skeleton.pathConstraints) {
            this.pathConstraints.add(new PathConstraint(pathConstraint, this));
        }
        this.skin = skeleton.skin;
        this.color = new Color(skeleton.color);
        this.time = skeleton.time;
        this.scaleX = skeleton.scaleX;
        this.scaleY = skeleton.scaleY;
        this.updateCache();
    }

    public void updateCache() {
        int n;
        Object object;
        int n2;
        int n3;
        Array<Updatable> array = this.updateCache;
        array.clear();
        this.updateCacheReset.clear();
        int n4 = this.bones.size;
        T[] TArray = this.bones.items;
        for (n3 = 0; n3 < n4; ++n3) {
            Bone bone = (Bone)TArray[n3];
            bone.sorted = bone.data.skinRequired;
            bone.active = !bone.sorted;
        }
        if (this.skin != null) {
            T[] TArray2 = this.skin.bones.items;
            n2 = this.skin.bones.size;
            for (int i = 0; i < n2; ++i) {
                object = (Bone)TArray[((BoneData)TArray2[i]).index];
                do {
                    object.sorted = false;
                    object.active = true;
                } while ((object = object.parent) != null);
            }
        }
        n3 = this.ikConstraints.size;
        int n5 = this.transformConstraints.size;
        n2 = this.pathConstraints.size;
        object = this.ikConstraints.items;
        T[] TArray3 = this.transformConstraints.items;
        T[] TArray4 = this.pathConstraints.items;
        int n6 = n3 + n5 + n2;
        block3: for (n = 0; n < n6; ++n) {
            Updatable updatable;
            int n7;
            for (n7 = 0; n7 < n3; ++n7) {
                updatable = (IkConstraint)object[n7];
                if (updatable.data.order != n) continue;
                this.sortIkConstraint((IkConstraint)updatable);
                continue block3;
            }
            for (n7 = 0; n7 < n5; ++n7) {
                updatable = (TransformConstraint)TArray3[n7];
                if (((TransformConstraint)updatable).data.order != n) continue;
                this.sortTransformConstraint((TransformConstraint)updatable);
                continue block3;
            }
            for (n7 = 0; n7 < n2; ++n7) {
                updatable = (PathConstraint)TArray4[n7];
                if (((PathConstraint)updatable).data.order != n) continue;
                this.sortPathConstraint((PathConstraint)updatable);
                continue block3;
            }
        }
        for (n = 0; n < n4; ++n) {
            this.sortBone((Bone)TArray[n]);
        }
    }

    private void sortIkConstraint(IkConstraint ikConstraint) {
        Bone bone;
        boolean bl = ikConstraint.active = ikConstraint.target.active && (!ikConstraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(ikConstraint.data, true));
        if (!ikConstraint.active) {
            return;
        }
        Bone bone2 = ikConstraint.target;
        this.sortBone(bone2);
        Array<Bone> array = ikConstraint.bones;
        Bone bone3 = array.first();
        this.sortBone(bone3);
        if (array.size > 1 && !this.updateCache.contains(bone = array.peek(), true)) {
            this.updateCacheReset.add(bone);
        }
        this.updateCache.add(ikConstraint);
        this.sortReset(bone3.children);
        array.peek().sorted = true;
    }

    private void sortPathConstraint(PathConstraint pathConstraint) {
        int n;
        Attachment attachment;
        boolean bl = pathConstraint.active = pathConstraint.target.bone.active && (!pathConstraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(pathConstraint.data, true));
        if (!pathConstraint.active) {
            return;
        }
        Slot slot = pathConstraint.target;
        int n2 = slot.getData().index;
        Bone bone = slot.bone;
        if (this.skin != null) {
            this.sortPathConstraintAttachment(this.skin, n2, bone);
        }
        if (this.data.defaultSkin != null && this.data.defaultSkin != this.skin) {
            this.sortPathConstraintAttachment(this.data.defaultSkin, n2, bone);
        }
        if ((attachment = slot.attachment) instanceof PathAttachment) {
            this.sortPathConstraintAttachment(attachment, bone);
        }
        Array<Bone> array = pathConstraint.bones;
        int n3 = array.size;
        for (n = 0; n < n3; ++n) {
            this.sortBone(array.get(n));
        }
        this.updateCache.add(pathConstraint);
        for (n = 0; n < n3; ++n) {
            this.sortReset(array.get((int)n).children);
        }
        for (n = 0; n < n3; ++n) {
            array.get((int)n).sorted = true;
        }
    }

    private void sortTransformConstraint(TransformConstraint transformConstraint) {
        int n;
        boolean bl = transformConstraint.active = transformConstraint.target.active && (!transformConstraint.data.skinRequired || this.skin != null && this.skin.constraints.contains(transformConstraint.data, true));
        if (!transformConstraint.active) {
            return;
        }
        this.sortBone(transformConstraint.target);
        Array<Bone> array = transformConstraint.bones;
        int n2 = array.size;
        if (transformConstraint.data.local) {
            for (n = 0; n < n2; ++n) {
                Bone bone = array.get(n);
                this.sortBone(bone.parent);
                if (this.updateCache.contains(bone, true)) continue;
                this.updateCacheReset.add(bone);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.sortBone(array.get(n));
            }
        }
        this.updateCache.add(transformConstraint);
        for (n = 0; n < n2; ++n) {
            this.sortReset(array.get((int)n).children);
        }
        for (n = 0; n < n2; ++n) {
            array.get((int)n).sorted = true;
        }
    }

    private void sortPathConstraintAttachment(Skin skin, int n, Bone bone) {
        for (Skin.SkinEntry skinEntry : skin.attachments.keys()) {
            if (skinEntry.getSlotIndex() != n) continue;
            this.sortPathConstraintAttachment(skinEntry.getAttachment(), bone);
        }
    }

    private void sortPathConstraintAttachment(Attachment attachment, Bone bone) {
        if (!(attachment instanceof PathAttachment)) {
            return;
        }
        int[] nArray = ((PathAttachment)attachment).getBones();
        if (nArray == null) {
            this.sortBone(bone);
        } else {
            Array<Bone> array = this.bones;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int n3 = nArray[n++];
                n3 += n;
                while (n < n3) {
                    this.sortBone(array.get(nArray[n++]));
                }
            }
        }
    }

    private void sortBone(Bone bone) {
        if (bone.sorted) {
            return;
        }
        Bone bone2 = bone.parent;
        if (bone2 != null) {
            this.sortBone(bone2);
        }
        bone.sorted = true;
        this.updateCache.add(bone);
    }

    private void sortReset(Array<Bone> array) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = array.get(i);
            if (!bone.active) continue;
            if (bone.sorted) {
                this.sortReset(bone.children);
            }
            bone.sorted = false;
        }
    }

    public void updateWorldTransform() {
        Array<Bone> array = this.updateCacheReset;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = array.get(i);
            bone.ax = bone.x;
            bone.ay = bone.y;
            bone.arotation = bone.rotation;
            bone.ascaleX = bone.scaleX;
            bone.ascaleY = bone.scaleY;
            bone.ashearX = bone.shearX;
            bone.ashearY = bone.shearY;
            bone.appliedValid = true;
        }
        Array<Updatable> array2 = this.updateCache;
        int n2 = array2.size;
        for (n = 0; n < n2; ++n) {
            array2.get(n).update();
        }
    }

    public void setToSetupPose() {
        this.setBonesToSetupPose();
        this.setSlotsToSetupPose();
    }

    public void setBonesToSetupPose() {
        Object object;
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            array.get(i).setToSetupPose();
        }
        Array<IkConstraint> array2 = this.ikConstraints;
        int n2 = array2.size;
        for (n = 0; n < n2; ++n) {
            IkConstraint ikConstraint = array2.get(n);
            ikConstraint.mix = ikConstraint.data.mix;
            ikConstraint.softness = ikConstraint.data.softness;
            ikConstraint.bendDirection = ikConstraint.data.bendDirection;
            ikConstraint.compress = ikConstraint.data.compress;
            ikConstraint.stretch = ikConstraint.data.stretch;
        }
        Array<TransformConstraint> array3 = this.transformConstraints;
        int n3 = array3.size;
        for (n2 = 0; n2 < n3; ++n2) {
            TransformConstraint transformConstraint = array3.get(n2);
            object = transformConstraint.data;
            transformConstraint.rotateMix = ((TransformConstraintData)object).rotateMix;
            transformConstraint.translateMix = ((TransformConstraintData)object).translateMix;
            transformConstraint.scaleMix = ((TransformConstraintData)object).scaleMix;
            transformConstraint.shearMix = ((TransformConstraintData)object).shearMix;
        }
        Array<PathConstraint> array4 = this.pathConstraints;
        int n4 = array4.size;
        for (n3 = 0; n3 < n4; ++n3) {
            object = array4.get(n3);
            PathConstraintData pathConstraintData = ((PathConstraint)object).data;
            ((PathConstraint)object).position = pathConstraintData.position;
            ((PathConstraint)object).spacing = pathConstraintData.spacing;
            ((PathConstraint)object).rotateMix = pathConstraintData.rotateMix;
            ((PathConstraint)object).translateMix = pathConstraintData.translateMix;
        }
    }

    public void setSlotsToSetupPose() {
        Array<Slot> array = this.slots;
        SpineUtils.arraycopy(array.items, 0, this.drawOrder.items, 0, array.size);
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            array.get(i).setToSetupPose();
        }
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone findBone(String string) {
        if (string == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = array.get(i);
            if (!bone.data.name.equals(string)) continue;
            return bone;
        }
        return null;
    }

    public Array<Slot> getSlots() {
        return this.slots;
    }

    public Slot findSlot(String string) {
        if (string == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> array = this.slots;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Slot slot = array.get(i);
            if (!slot.data.name.equals(string)) continue;
            return slot;
        }
        return null;
    }

    public void setSkin(String string) {
        Skin skin = this.data.findSkin(string);
        if (skin == null) {
            throw new IllegalArgumentException("Skin not found: " + string);
        }
        this.setSkin(skin);
    }

    public void setSkin(Skin skin) {
        if (skin == this.skin) {
            return;
        }
        if (skin != null) {
            if (this.skin != null) {
                skin.attachAll(this, this.skin);
            } else {
                Array<Slot> array = this.slots;
                int n = array.size;
                for (int i = 0; i < n; ++i) {
                    Attachment attachment;
                    Slot slot = array.get(i);
                    String string = slot.data.attachmentName;
                    if (string == null || (attachment = skin.getAttachment(i, string)) == null) continue;
                    slot.setAttachment(attachment);
                }
            }
        }
        this.skin = skin;
        this.updateCache();
    }

    public Attachment getAttachment(int n, String string) {
        Attachment attachment;
        if (string == null) {
            throw new IllegalArgumentException("attachmentName cannot be null.");
        }
        if (this.skin != null && (attachment = this.skin.getAttachment(n, string)) != null) {
            return attachment;
        }
        if (this.data.defaultSkin != null) {
            return this.data.defaultSkin.getAttachment(n, string);
        }
        return null;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void update(float f) {
        this.time += f;
    }

    public String toString() {
        return this.data.name != null ? this.data.name : super.toString();
    }
}

