/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;

public class SkeletonBounds {
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private Array<BoundingBoxAttachment> boundingBoxes = new Array();
    private Array<FloatArray> polygons = new Array();
    private Pool<FloatArray> polygonPool = new Pool(){

        protected Object newObject() {
            return new FloatArray();
        }
    };

    public void update(Skeleton skeleton, boolean bl) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        Array<BoundingBoxAttachment> array = this.boundingBoxes;
        Array<FloatArray> array2 = this.polygons;
        Array<Slot> array3 = skeleton.slots;
        int n = array3.size;
        array.clear();
        this.polygonPool.freeAll(array2);
        array2.clear();
        for (int i = 0; i < n; ++i) {
            Slot slot = array3.get(i);
            Attachment attachment = slot.attachment;
            if (!(attachment instanceof BoundingBoxAttachment)) continue;
            BoundingBoxAttachment boundingBoxAttachment = (BoundingBoxAttachment)attachment;
            array.add(boundingBoxAttachment);
            FloatArray floatArray = this.polygonPool.obtain();
            array2.add(floatArray);
            boundingBoxAttachment.computeWorldVertices(slot, 0, boundingBoxAttachment.getWorldVerticesLength(), floatArray.setSize(boundingBoxAttachment.getWorldVerticesLength()), 0, 2);
        }
        if (bl) {
            this.aabbCompute();
        } else {
            this.minX = -2.1474836E9f;
            this.minY = -2.1474836E9f;
            this.maxX = 2.1474836E9f;
            this.maxY = 2.1474836E9f;
        }
    }

    private void aabbCompute() {
        float f = 2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = -2.1474836E9f;
        float f4 = -2.1474836E9f;
        Array<FloatArray> array = this.polygons;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            FloatArray floatArray = array.get(i);
            float[] fArray = floatArray.items;
            int n2 = floatArray.size;
            for (int j = 0; j < n2; j += 2) {
                float f5 = fArray[j];
                float f6 = fArray[j + 1];
                f = Math.min(f, f5);
                f2 = Math.min(f2, f6);
                f3 = Math.max(f3, f5);
                f4 = Math.max(f4, f6);
            }
        }
        this.minX = f;
        this.minY = f2;
        this.maxX = f3;
        this.maxY = f4;
    }

    public boolean aabbContainsPoint(float f, float f2) {
        return f >= this.minX && f <= this.maxX && f2 >= this.minY && f2 <= this.maxY;
    }

    public boolean aabbIntersectsSegment(float f, float f2, float f3, float f4) {
        float f5 = this.minX;
        float f6 = this.minY;
        float f7 = this.maxX;
        float f8 = this.maxY;
        if (f <= f5 && f3 <= f5 || f2 <= f6 && f4 <= f6 || f >= f7 && f3 >= f7 || f2 >= f8 && f4 >= f8) {
            return false;
        }
        float f9 = (f4 - f2) / (f3 - f);
        float f10 = f9 * (f5 - f) + f2;
        if (f10 > f6 && f10 < f8) {
            return true;
        }
        f10 = f9 * (f7 - f) + f2;
        if (f10 > f6 && f10 < f8) {
            return true;
        }
        float f11 = (f6 - f2) / f9 + f;
        if (f11 > f5 && f11 < f7) {
            return true;
        }
        f11 = (f8 - f2) / f9 + f;
        return f11 > f5 && f11 < f7;
    }

    public boolean aabbIntersectsSkeleton(SkeletonBounds skeletonBounds) {
        return this.minX < skeletonBounds.maxX && this.maxX > skeletonBounds.minX && this.minY < skeletonBounds.maxY && this.maxY > skeletonBounds.minY;
    }

    public BoundingBoxAttachment containsPoint(float f, float f2) {
        Array<FloatArray> array = this.polygons;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            if (!this.containsPoint(array.get(i), f, f2)) continue;
            return this.boundingBoxes.get(i);
        }
        return null;
    }

    public boolean containsPoint(FloatArray floatArray, float f, float f2) {
        float[] fArray = floatArray.items;
        int n = floatArray.size;
        int n2 = n - 2;
        boolean bl = false;
        for (int i = 0; i < n; i += 2) {
            float f3;
            float f4 = fArray[i + 1];
            float f5 = fArray[n2 + 1];
            if ((f4 < f2 && f5 >= f2 || f5 < f2 && f4 >= f2) && (f3 = fArray[i]) + (f2 - f4) / (f5 - f4) * (fArray[n2] - f3) < f) {
                bl = !bl;
            }
            n2 = i;
        }
        return bl;
    }

    public BoundingBoxAttachment intersectsSegment(float f, float f2, float f3, float f4) {
        Array<FloatArray> array = this.polygons;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            if (!this.intersectsSegment(array.get(i), f, f2, f3, f4)) continue;
            return this.boundingBoxes.get(i);
        }
        return null;
    }

    public boolean intersectsSegment(FloatArray floatArray, float f, float f2, float f3, float f4) {
        float[] fArray = floatArray.items;
        int n = floatArray.size;
        float f5 = f - f3;
        float f6 = f2 - f4;
        float f7 = f * f4 - f2 * f3;
        float f8 = fArray[n - 2];
        float f9 = fArray[n - 1];
        for (int i = 0; i < n; i += 2) {
            float f10;
            float f11 = fArray[i];
            float f12 = f8 - f11;
            float f13 = fArray[i + 1];
            float f14 = f8 * f13 - f9 * f11;
            float f15 = f9 - f13;
            float f16 = f5 * f15 - f6 * f12;
            float f17 = (f7 * f12 - f5 * f14) / f16;
            if ((f17 >= f8 && f17 <= f11 || f17 >= f11 && f17 <= f8) && (f17 >= f && f17 <= f3 || f17 >= f3 && f17 <= f) && ((f10 = (f7 * f15 - f6 * f14) / f16) >= f9 && f10 <= f13 || f10 >= f13 && f10 <= f9) && (f10 >= f2 && f10 <= f4 || f10 >= f4 && f10 <= f2)) {
                return true;
            }
            f8 = f11;
            f9 = f13;
        }
        return false;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getWidth() {
        return this.maxX - this.minX;
    }

    public float getHeight() {
        return this.maxY - this.minY;
    }

    public Array<BoundingBoxAttachment> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public Array<FloatArray> getPolygons() {
        return this.polygons;
    }

    public FloatArray getPolygon(BoundingBoxAttachment boundingBoxAttachment) {
        if (boundingBoxAttachment == null) {
            throw new IllegalArgumentException("boundingBox cannot be null.");
        }
        int n = this.boundingBoxes.indexOf(boundingBoxAttachment, true);
        return n == -1 ? null : this.polygons.get(n);
    }
}

