/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonRenderer;

public class SkeletonActor
extends Actor {
    private SkeletonRenderer renderer;
    private Skeleton skeleton;
    AnimationState state;

    public SkeletonActor() {
    }

    public SkeletonActor(SkeletonRenderer skeletonRenderer, Skeleton skeleton, AnimationState animationState) {
        this.renderer = skeletonRenderer;
        this.skeleton = skeleton;
        this.state = animationState;
    }

    @Override
    public void act(float f) {
        this.state.update(f);
        this.state.apply(this.skeleton);
        this.skeleton.updateWorldTransform();
        super.act(f);
    }

    @Override
    public void draw(Batch batch, float f) {
        Color color = this.skeleton.getColor();
        float f2 = color.a;
        this.skeleton.getColor().a *= f;
        this.skeleton.setPosition(this.getX(), this.getY());
        this.renderer.draw(batch, this.skeleton);
        color.a = f2;
    }

    public SkeletonRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(SkeletonRenderer skeletonRenderer) {
        this.renderer = skeletonRenderer;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public AnimationState getAnimationState() {
        return this.state;
    }

    public void setAnimationState(AnimationState animationState) {
        this.state = animationState;
    }
}

